/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.tasm;

import java.util.HashMap;
import java.util.Map;

enum TasmContigAttribute {
    UNGAPPED_CONSENSUS("sequence"),
    GAPPED_CONSENSUS("lsequence"),
    ASMBL_ID("asmbl_id"),
    CA_CONTIG_ID("ca_contig_id"),
    COMMENT("comment"),
    SEQ_ID("seq_id"),
    COM_NAME("com_name"),
    TYPE("type"),
    METHOD("method"),
    EDIT_STATUS("ed_status"),
    AVG_COVERAGE("redundancy"),
    PERCENT_N("perc_N"),
    NUMBER_OF_READS("seq#"),
    FULL_CDS("full_cds"),
    CDS_START("cds_start"),
    CDS_END("cds_end"),
    EDIT_PERSON("ed_pn"),
    EDIT_DATE("ed_date"),
    FRAME_SHIFT("frameshift"),
    IS_CIRCULAR("is_circular"),
    BAC_ID("bac_id");

    private final String assemblyTableColumn;
    private static final Map<String, TasmContigAttribute> MAP;

    private TasmContigAttribute(String assemblyTableColumn) {
        this.assemblyTableColumn = assemblyTableColumn;
    }

    public String getAssemblyTableColumn() {
        return this.assemblyTableColumn;
    }

    public static TasmContigAttribute getAttributeFor(String attribute) {
        if (MAP.containsKey(attribute)) {
            return MAP.get(attribute);
        }
        throw new IllegalArgumentException("unknown attribute " + attribute);
    }

    static {
        MAP = new HashMap<String, TasmContigAttribute>();
        for (TasmContigAttribute attribute : TasmContigAttribute.values()) {
            MAP.put(attribute.getAssemblyTableColumn(), attribute);
        }
    }
}

