/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.tasm;

import java.io.File;
import java.io.IOException;
import org.jcvi.jillion.assembly.tigr.tasm.AbstractTasmContigBuilderVisitor;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContig;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigBuilder;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigDataStore;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigFileContigIterator;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigVisitor;
import org.jcvi.jillion.assembly.tigr.tasm.TasmFileParser;
import org.jcvi.jillion.assembly.tigr.tasm.TasmVisitor;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;
import org.jcvi.jillion.internal.core.util.iter.AbstractBlockingStreamingIterator;

final class LargeTasmContigFileDataStore
implements TasmContigDataStore {
    private static final String ERROR_PARSING_CONTIG_FILE = "error parsing contig file";
    private final DataStoreFilter filter;
    private final File contigFile;
    private final DataStore<Long> fullLengthSequences;
    private Long size = null;
    private volatile boolean closed = false;

    public LargeTasmContigFileDataStore(File contigFile, DataStore<Long> fullLengthSequences, DataStoreFilter filter) {
        this.contigFile = contigFile;
        this.fullLengthSequences = fullLengthSequences;
        this.filter = filter;
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new DataStoreClosedException("datastore is closed");
        }
    }

    @Override
    public StreamingIterator<String> idIterator() throws DataStoreException {
        this.checkNotClosed();
        IdIterator iter = new IdIterator();
        iter.start();
        return DataStoreStreamingIterator.create(this, iter);
    }

    @Override
    public TasmContig get(String id) throws DataStoreException {
        if (!this.filter.accept(id)) {
            return null;
        }
        GetVisitor visitor = new GetVisitor(id);
        try {
            TasmFileParser.create(this.contigFile).parse(visitor);
            return visitor.getContig();
        }
        catch (IOException e) {
            throw new DataStoreException(ERROR_PARSING_CONTIG_FILE, e);
        }
    }

    @Override
    public boolean contains(String id) throws DataStoreException {
        if (!this.filter.accept(id)) {
            return false;
        }
        ContainsVisitor visitor = new ContainsVisitor(id);
        try {
            TasmFileParser.create(this.contigFile).parse(visitor);
            return visitor.contains();
        }
        catch (IOException e) {
            throw new DataStoreException(ERROR_PARSING_CONTIG_FILE, e);
        }
    }

    @Override
    public synchronized long getNumberOfRecords() throws DataStoreException {
        if (this.size == null) {
            SizeVisitor visitor = new SizeVisitor();
            try {
                TasmFileParser.create(this.contigFile).parse(visitor);
                this.size = visitor.getSize();
            }
            catch (IOException e) {
                throw new DataStoreException(ERROR_PARSING_CONTIG_FILE, e);
            }
        }
        return this.size;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public StreamingIterator<TasmContig> iterator() throws DataStoreException {
        this.checkNotClosed();
        return DataStoreStreamingIterator.create(this, TasmContigFileContigIterator.create(this.contigFile, this.fullLengthSequences, this.filter));
    }

    @Override
    public StreamingIterator<DataStoreEntry<TasmContig>> entryIterator() throws DataStoreException {
        StreamingIterator<DataStoreEntry<TasmContig>> iter = new StreamingIterator<DataStoreEntry<TasmContig>>(){
            StreamingIterator<TasmContig> delegate;
            {
                this.delegate = TasmContigFileContigIterator.create(LargeTasmContigFileDataStore.this.contigFile, LargeTasmContigFileDataStore.this.fullLengthSequences, LargeTasmContigFileDataStore.this.filter);
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public void close() {
                this.delegate.close();
            }

            @Override
            public DataStoreEntry<TasmContig> next() {
                TasmContig asm = this.delegate.next();
                return new DataStoreEntry<TasmContig>(asm.getId(), asm);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return DataStoreStreamingIterator.create(this, iter);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    private class SizeVisitor
    implements TasmVisitor {
        private long size = 0L;

        private SizeVisitor() {
        }

        @Override
        public TasmContigVisitor visitContig(TasmVisitor.TasmVisitorCallback callback, String contigId) {
            if (LargeTasmContigFileDataStore.this.filter.accept(contigId)) {
                ++this.size;
            }
            return null;
        }

        public long getSize() {
            return this.size;
        }

        @Override
        public void halted() {
        }

        @Override
        public void visitEnd() {
        }
    }

    private class GetVisitor
    implements TasmVisitor {
        private final String id;
        private TasmContig contig;

        public GetVisitor(String id) {
            this.id = id;
        }

        @Override
        public TasmContigVisitor visitContig(final TasmVisitor.TasmVisitorCallback callback, String contigId) {
            if (this.id.equals(contigId)) {
                return new AbstractTasmContigBuilderVisitor(contigId, LargeTasmContigFileDataStore.this.fullLengthSequences){

                    @Override
                    protected void visitRecord(TasmContigBuilder builder) {
                        GetVisitor.this.contig = builder.build();
                        callback.halt();
                    }
                };
            }
            return null;
        }

        public TasmContig getContig() {
            return this.contig;
        }

        @Override
        public void halted() {
        }

        @Override
        public void visitEnd() {
        }
    }

    private static final class ContainsVisitor
    implements TasmVisitor {
        private final String id;
        private boolean contains = false;

        public ContainsVisitor(String id) {
            this.id = id;
        }

        @Override
        public TasmContigVisitor visitContig(TasmVisitor.TasmVisitorCallback callback, String contigId) {
            if (this.id.equals(contigId)) {
                this.contains = true;
                callback.halt();
            }
            return null;
        }

        public boolean contains() {
            return this.contains;
        }

        @Override
        public void halted() {
        }

        @Override
        public void visitEnd() {
        }
    }

    private class IdIterator
    extends AbstractBlockingStreamingIterator<String> {
        private IdIterator() {
        }

        @Override
        protected void backgroundThreadRunMethod() throws RuntimeException {
            TasmVisitor visitor = new TasmVisitor(){

                @Override
                public void halted() {
                }

                @Override
                public void visitEnd() {
                }

                @Override
                public TasmContigVisitor visitContig(TasmVisitor.TasmVisitorCallback callback, String contigId) {
                    if (LargeTasmContigFileDataStore.this.filter.accept(contigId)) {
                        IdIterator.this.blockingPut(contigId);
                    }
                    return null;
                }
            };
            try {
                TasmFileParser.create(LargeTasmContigFileDataStore.this.contigFile).parse(visitor);
            }
            catch (IOException e) {
                throw new RuntimeException(LargeTasmContigFileDataStore.ERROR_PARSING_CONTIG_FILE, e);
            }
        }
    }
}

