/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.tasm;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jcvi.jillion.assembly.tigr.tasm.AbstractTasmContigBuilderVisitor;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContig;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigBuilder;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigDataStore;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigVisitor;
import org.jcvi.jillion.assembly.tigr.tasm.TasmFileParser;
import org.jcvi.jillion.assembly.tigr.tasm.TasmParser;
import org.jcvi.jillion.assembly.tigr.tasm.TasmVisitor;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.datastore.DataStoreIterator;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;

final class IndexedTasmFileDataStore
implements TasmContigDataStore {
    private final DataStore<Long> fullLengthSequenceDataStore;
    private final TasmParser parser;
    private final Map<String, TasmVisitor.TasmVisitorCallback.TasmVisitorMemento> mementos;
    private volatile boolean closed = false;

    public static TasmContigDataStore create(File tasmFile, DataStore<Long> fullLengthSequenceDataStore, DataStoreFilter filter) throws IOException {
        IndexVisitor visitor = new IndexVisitor(filter);
        TasmParser parser = TasmFileParser.create(tasmFile);
        parser.parse(visitor);
        return new IndexedTasmFileDataStore(parser, fullLengthSequenceDataStore, visitor.mementos);
    }

    private IndexedTasmFileDataStore(TasmParser parser, DataStore<Long> fullLengthSequenceDataStore, Map<String, TasmVisitor.TasmVisitorCallback.TasmVisitorMemento> mementos) {
        this.parser = parser;
        this.fullLengthSequenceDataStore = fullLengthSequenceDataStore;
        this.mementos = mementos;
    }

    private void checkNotYetClosed() {
        if (this.closed) {
            throw new DataStoreClosedException("closed");
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.mementos.clear();
    }

    @Override
    public StreamingIterator<String> idIterator() throws DataStoreException {
        return DataStoreStreamingIterator.create(this, this.mementos.keySet().iterator());
    }

    @Override
    public TasmContig get(String id) throws DataStoreException {
        this.checkNotYetClosed();
        TasmVisitor.TasmVisitorCallback.TasmVisitorMemento memento = this.mementos.get(id);
        if (memento == null) {
            return null;
        }
        SingleContigVisitor visitor = new SingleContigVisitor();
        try {
            this.parser.parse(visitor, memento);
            return visitor.contig;
        }
        catch (IOException e) {
            throw new DataStoreException("error parsing contig " + id, e);
        }
    }

    @Override
    public boolean contains(String id) throws DataStoreException {
        this.checkNotYetClosed();
        return this.mementos.containsKey(id);
    }

    @Override
    public long getNumberOfRecords() throws DataStoreException {
        this.checkNotYetClosed();
        return this.mementos.size();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public StreamingIterator<TasmContig> iterator() throws DataStoreException {
        return new DataStoreIterator<TasmContig>(this);
    }

    @Override
    public StreamingIterator<DataStoreEntry<TasmContig>> entryIterator() throws DataStoreException {
        StreamingIterator<DataStoreEntry<TasmContig>> iter = new StreamingIterator<DataStoreEntry<TasmContig>>(){
            StreamingIterator<TasmContig> delegate;
            {
                this.delegate = IndexedTasmFileDataStore.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public void close() {
                this.delegate.close();
            }

            @Override
            public DataStoreEntry<TasmContig> next() {
                TasmContig trace = this.delegate.next();
                return new DataStoreEntry<TasmContig>(trace.getId(), trace);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return DataStoreStreamingIterator.create(this, iter);
    }

    private class SingleContigVisitor
    implements TasmVisitor {
        private TasmContig contig;

        private SingleContigVisitor() {
        }

        @Override
        public TasmContigVisitor visitContig(final TasmVisitor.TasmVisitorCallback callback, String contigId) {
            return new AbstractTasmContigBuilderVisitor(contigId, IndexedTasmFileDataStore.this.fullLengthSequenceDataStore){

                @Override
                protected void visitRecord(TasmContigBuilder builder) {
                    SingleContigVisitor.this.contig = builder.build();
                    callback.halt();
                }
            };
        }

        @Override
        public void halted() {
        }

        @Override
        public void visitEnd() {
        }
    }

    private static final class IndexVisitor
    implements TasmVisitor {
        private final DataStoreFilter filter;
        private final Map<String, TasmVisitor.TasmVisitorCallback.TasmVisitorMemento> mementos = new LinkedHashMap<String, TasmVisitor.TasmVisitorCallback.TasmVisitorMemento>();

        public IndexVisitor(DataStoreFilter filter) {
            this.filter = filter;
        }

        @Override
        public TasmContigVisitor visitContig(TasmVisitor.TasmVisitorCallback callback, String contigId) {
            if (this.filter.accept(contigId)) {
                if (!callback.canCreateMemento()) {
                    throw new IllegalStateException("tasm parser must be able to create mementos");
                }
                this.mementos.put(contigId, callback.createMemento());
            }
            return null;
        }

        @Override
        public void halted() {
        }

        @Override
        public void visitEnd() {
        }
    }
}

