/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.tasm;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jcvi.jillion.assembly.tigr.tasm.AbstractTasmContigBuilderVisitor;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContig;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigBuilder;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigDataStore;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigVisitor;
import org.jcvi.jillion.assembly.tigr.tasm.TasmFileParser;
import org.jcvi.jillion.assembly.tigr.tasm.TasmVisitor;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreFilter;

final class DefaultTasmFileContigDataStore {
    public static TasmContigDataStore create(File tasmFile, DataStore<Long> fullLengthSequenceDataStore, DataStoreFilter filter) throws IOException {
        Visitor visitor = new Visitor(filter, fullLengthSequenceDataStore);
        TasmFileParser.create(tasmFile).parse(visitor);
        return DataStore.of(visitor.contigs, TasmContigDataStore.class);
    }

    private DefaultTasmFileContigDataStore() {
    }

    private static final class Visitor
    implements TasmVisitor {
        private final DataStoreFilter filter;
        private final DataStore<Long> fullLengthSequenceDataStore;
        private final Map<String, TasmContig> contigs = new LinkedHashMap<String, TasmContig>();

        public Visitor(DataStoreFilter filter, DataStore<Long> fullLengthSequenceDataStore) {
            this.filter = filter;
            this.fullLengthSequenceDataStore = fullLengthSequenceDataStore;
        }

        @Override
        public TasmContigVisitor visitContig(TasmVisitor.TasmVisitorCallback callback, final String contigId) {
            if (!this.filter.accept(contigId)) {
                return null;
            }
            return new AbstractTasmContigBuilderVisitor(contigId, this.fullLengthSequenceDataStore){

                @Override
                protected void visitRecord(TasmContigBuilder builder) {
                    contigs.put(contigId, builder.build());
                }
            };
        }

        @Override
        public void halted() {
        }

        @Override
        public void visitEnd() {
        }
    }
}

