/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.tasm;

import java.util.Date;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigBuilder;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigReadVisitor;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigVisitor;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;

public abstract class AbstractTasmContigBuilderVisitor
implements TasmContigVisitor {
    private TasmContigBuilder builder;
    private final String contigId;
    private final DataStore<Long> fullRangeLengthDataStore;

    public AbstractTasmContigBuilderVisitor(String contigId, DataStore<Long> fullRangeLengthDataStore) {
        this.contigId = contigId;
        this.fullRangeLengthDataStore = fullRangeLengthDataStore;
    }

    @Override
    public void visitConsensus(NucleotideSequence consensus) {
        this.builder = new TasmContigBuilder(this.contigId, consensus);
    }

    @Override
    public void visitCeleraId(long id) {
        this.builder.withCeleraAssemblerContigId(id);
    }

    @Override
    public void visitComments(Integer bacId, String comment, String commonName, String assemblyMethod, boolean isCircular) {
        if (bacId != null) {
            this.builder.setSampleId(bacId.toString());
        }
        if (commonName != null) {
            this.builder.withCommonName(commonName);
        }
        this.builder.withMethod(assemblyMethod);
        this.builder.isCircular(isCircular);
    }

    @Override
    public void visitCoverageData(int numberOfReads, float avgCoverage) {
        this.builder.setCoverageInfo(numberOfReads, Double.valueOf(avgCoverage));
    }

    @Override
    public void visitLastEdited(String username, Date editDate) {
        this.builder.withEditInfo(username, editDate);
    }

    @Override
    public TasmContigReadVisitor visitRead(final String readId, final long gappedStartOffset, final Direction dir, final Range validRange) {
        this.builder.setCoverageInfo(null, null);
        return new TasmContigReadVisitor(){
            private NucleotideSequence gappedBasecalls;

            @Override
            public void visitEnd() {
                Long fullLength;
                try {
                    fullLength = (Long)AbstractTasmContigBuilderVisitor.this.fullRangeLengthDataStore.get(readId);
                }
                catch (DataStoreException e) {
                    throw new IllegalStateException("error reading from full length sequence datastore for read " + readId, e);
                }
                if (fullLength == null) {
                    throw new IllegalStateException("full length sequence datastore did not contain read " + readId);
                }
                String gappedSequence = this.gappedBasecalls.toString();
                AbstractTasmContigBuilderVisitor.this.builder.addRead(readId, (int)gappedStartOffset, validRange, gappedSequence, dir, fullLength.intValue());
            }

            @Override
            public void visitBasecalls(NucleotideSequence gappedBasecalls) {
                this.gappedBasecalls = gappedBasecalls;
            }
        };
    }

    @Override
    public void halted() {
    }

    @Override
    public void visitEnd() {
        this.visitRecord(this.builder);
        this.builder = null;
    }

    protected abstract void visitRecord(TasmContigBuilder var1);
}

