/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.contig;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import java.util.TreeSet;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.Contig;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.util.JillionUtil;

@SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="\n character is required for .contig format we don't want to accidentally put in a \r\n on diffent OS")
public class TigrContigFileWriter
implements Closeable {
    private static final int INITIAL_RECORD_BUFFER_SIZE = 2048;
    private static final CtgFormatReadSorter READ_SORTER = CtgFormatReadSorter.INSTANCE;
    private final OutputStream out;

    public TigrContigFileWriter(File out) throws IOException {
        IOUtil.mkdirs(out.getParentFile());
        this.out = new BufferedOutputStream(new FileOutputStream(out));
    }

    public TigrContigFileWriter(OutputStream out) {
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <PR extends AssembledRead, C extends Contig<PR>> void write(C contig) throws IOException, UnsupportedEncodingException {
        this.writeContigHeader(contig);
        this.writeBases(contig.getConsensusSequence());
        TreeSet<AssembledRead> readsInContig = new TreeSet<AssembledRead>(READ_SORTER);
        StreamingIterator<PR> iter = null;
        try {
            iter = contig.getReadIterator();
            while (iter.hasNext()) {
                AssembledRead placedRead = (AssembledRead)iter.next();
                readsInContig.add(placedRead);
            }
        }
        finally {
            IOUtil.closeAndIgnoreErrors(iter);
        }
        for (AssembledRead placedRead : readsInContig) {
            this.writePlacedReadHeader(placedRead, contig.getConsensusSequence());
            this.writeBases(placedRead.getNucleotideSequence());
        }
    }

    private void writeContigHeader(Contig<? extends AssembledRead> contig) throws IOException {
        String header = String.format("##%s %d %d bases\n", contig.getId(), contig.getNumberOfReads(), contig.getConsensusSequence().getLength());
        this.writeToOutputStream(header);
    }

    private void writeBases(Sequence<Nucleotide> consensus) throws UnsupportedEncodingException, IOException {
        String result = consensus.toString().replaceAll("(.{60})", "$1\n");
        if (!result.endsWith("\n")) {
            result = result + "\n";
        }
        this.writeToOutputStream(result);
    }

    private void writeToOutputStream(String result) throws IOException, UnsupportedEncodingException {
        this.out.write(result.getBytes("UTF-8"));
    }

    private void writePlacedReadHeader(AssembledRead placedRead, NucleotideSequence consensus) throws IOException {
        StringBuilder header = new StringBuilder(2048);
        header.append(String.format("#%s(%d) [", placedRead.getId(), placedRead.getGappedStartOffset()));
        int validLeft = (int)placedRead.getReadInfo().getValidRange().getBegin();
        int validRight = (int)placedRead.getReadInfo().getValidRange().getEnd();
        if (placedRead.getDirection() == Direction.REVERSE) {
            header.append("RC");
            int temp = validLeft;
            validLeft = validRight;
            validRight = temp;
        }
        header.append(String.format("] %d bases {%d %d} <%d %d>\n", placedRead.getNucleotideSequence().getLength(), validLeft + 1, validRight + 1, placedRead.getGappedStartOffset() + 1L - (long)consensus.getNumberOfGapsUntil((int)placedRead.getGappedStartOffset()), placedRead.getGappedEndOffset() + 1L - (long)consensus.getNumberOfGapsUntil((int)placedRead.getGappedEndOffset())));
        this.writeToOutputStream(header.toString());
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    private static enum CtgFormatReadSorter implements Comparator<AssembledRead>,
    Serializable
    {
        INSTANCE;


        @Override
        public int compare(AssembledRead o1, AssembledRead o2) {
            int startComparison = JillionUtil.compare(o1.getGappedStartOffset(), o2.getGappedStartOffset());
            if (startComparison != 0) {
                return startComparison;
            }
            int lengthComparison = JillionUtil.compare(o1.getGappedLength(), o2.getGappedLength());
            if (lengthComparison != 0) {
                return lengthComparison;
            }
            int idLengthComparison = JillionUtil.compare(o1.getId().length(), o2.getId().length());
            if (idLengthComparison != 0) {
                return idLengthComparison;
            }
            return o1.getId().compareTo(o2.getId());
        }
    }
}

