/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.contig;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigFileVisitor;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigParser;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigReadVisitor;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigVisitor;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.internal.core.io.OpenAwareInputStream;
import org.jcvi.jillion.internal.core.io.RandomAccessFileInputStream;
import org.jcvi.jillion.internal.core.io.TextLineParser;

public abstract class TigrContigFileParser
implements TigrContigParser {
    private static final Pattern NEW_CONTIG_PATTERN = Pattern.compile("##(\\S+).+");
    private static final Pattern NEW_READ_PATTERN = Pattern.compile("#(\\S+)\\((-?\\d+)\\)\\s+\\[(.*)\\].+\\{(-?\\d+) (-?\\d+)\\}.+");

    public static TigrContigParser create(File contigFile) throws IOException {
        return new FileBasedTigrContigParser(contigFile);
    }

    public static TigrContigParser create(InputStream contigFileStream) {
        return new InputStreamBasedTigrContigParser(contigFileStream);
    }

    private TigrContigFileParser() {
    }

    @Override
    public void parse(TigrContigFileVisitor visitor) throws IOException {
        if (visitor == null) {
            throw new NullPointerException("visitor can not be null");
        }
        TextLineParser lineParser = new TextLineParser(this.getInputStream());
        try {
            this.parse(visitor, lineParser);
        }
        finally {
            IOUtil.closeAndIgnoreErrors((Closeable)lineParser);
        }
    }

    @Override
    public abstract void parse(TigrContigFileVisitor var1, TigrContigFileVisitor.TigrContigVisitorCallback.TigrContigVisitorMemento var2) throws IOException;

    final void parse(TigrContigFileVisitor visitor, TextLineParser parser) throws IOException {
        State state = new State(visitor, parser);
        Handler[] handlers = Handler.values();
        while (state.notDone()) {
            String peekedLine = state.peekLine();
            for (Handler handler : handlers) {
                if (handler.handle(state, peekedLine)) break;
            }
            state.advanceLine();
        }
        state.finishedParsing();
    }

    abstract AbstractTigrContigVisitorCallback createCallback(long var1);

    private static Range parseValidRange(Matcher newSequenceMatcher, Direction dir) {
        int left = Integer.parseInt(newSequenceMatcher.group(4));
        int right = Integer.parseInt(newSequenceMatcher.group(5));
        Range validRange = dir == Direction.REVERSE ? Range.of(Range.CoordinateSystem.RESIDUE_BASED, right, left) : Range.of(Range.CoordinateSystem.RESIDUE_BASED, left, right);
        return validRange;
    }

    private static boolean parseComplimentedFlag(Matcher newSequenceMatcher) {
        return !newSequenceMatcher.group(3).isEmpty();
    }

    abstract InputStream getInputStream() throws IOException;

    private static class OffsetMemento
    implements TigrContigFileVisitor.TigrContigVisitorCallback.TigrContigVisitorMemento {
        private final long offset;

        public OffsetMemento(long offset) {
            this.offset = offset;
        }

        public final long getOffset() {
            return this.offset;
        }
    }

    private static class MementoCallback
    extends AbstractTigrContigVisitorCallback {
        private final long offset;

        public MementoCallback(long offset) {
            this.offset = offset;
        }

        @Override
        public boolean canCreateMemento() {
            return true;
        }

        @Override
        public TigrContigFileVisitor.TigrContigVisitorCallback.TigrContigVisitorMemento createMemento() {
            return new OffsetMemento(this.offset);
        }
    }

    private static class NoMementoCallback
    extends AbstractTigrContigVisitorCallback {
        static NoMementoCallback INSTANCE = new NoMementoCallback();

        private NoMementoCallback() {
        }

        @Override
        public boolean canCreateMemento() {
            return false;
        }

        @Override
        public TigrContigFileVisitor.TigrContigVisitorCallback.TigrContigVisitorMemento createMemento() {
            throw new UnsupportedOperationException("can not create memento");
        }
    }

    private static abstract class AbstractTigrContigVisitorCallback
    implements TigrContigFileVisitor.TigrContigVisitorCallback {
        private volatile boolean keepParsing = true;

        private AbstractTigrContigVisitorCallback() {
        }

        @Override
        public void haltParsing() {
            this.keepParsing = false;
        }

        public final boolean keepParsing() {
            return this.keepParsing;
        }
    }

    private static class FileBasedTigrContigParser
    extends TigrContigFileParser {
        private final File contigFile;

        public FileBasedTigrContigParser(File contigFile) throws FileNotFoundException {
            if (contigFile == null) {
                throw new NullPointerException("contig file can not be null");
            }
            if (!contigFile.exists()) {
                throw new FileNotFoundException(contigFile.getAbsolutePath());
            }
            this.contigFile = contigFile;
        }

        @Override
        public boolean canParse() {
            return true;
        }

        @Override
        protected InputStream getInputStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.contigFile));
        }

        @Override
        protected AbstractTigrContigVisitorCallback createCallback(long currentOffset) {
            return new MementoCallback(currentOffset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(TigrContigFileVisitor visitor, TigrContigFileVisitor.TigrContigVisitorCallback.TigrContigVisitorMemento memento) throws IOException {
            if (memento == null) {
                throw new NullPointerException("memento can not be null");
            }
            if (!(memento instanceof OffsetMemento)) {
                throw new IllegalArgumentException("unknown memento type, must use instance created by this parser");
            }
            long startOffset = ((OffsetMemento)memento).getOffset();
            TextLineParser in = null;
            try {
                in = new TextLineParser(new RandomAccessFileInputStream(this.contigFile, startOffset));
                this.parse(visitor, in);
            }
            catch (Throwable throwable) {
                IOUtil.closeAndIgnoreErrors(in);
                throw throwable;
            }
            IOUtil.closeAndIgnoreErrors((Closeable)in);
        }
    }

    private static class InputStreamBasedTigrContigParser
    extends TigrContigFileParser {
        private final OpenAwareInputStream in;

        public InputStreamBasedTigrContigParser(InputStream in) {
            this.in = new OpenAwareInputStream(in);
        }

        @Override
        public void parse(TigrContigFileVisitor visitor, TigrContigFileVisitor.TigrContigVisitorCallback.TigrContigVisitorMemento memento) throws IOException {
            throw new UnsupportedOperationException("inputstream parser does not support mementos");
        }

        @Override
        protected AbstractTigrContigVisitorCallback createCallback(long currentOffset) {
            return NoMementoCallback.INSTANCE;
        }

        @Override
        protected InputStream getInputStream() throws IOException {
            if (!this.canParse()) {
                throw new IOException("inputstream is closed");
            }
            return this.in;
        }

        @Override
        public boolean canParse() {
            return this.in.isOpen();
        }
    }

    private static enum Handler {
        NEW_CONTIG{

            @Override
            protected boolean handle(State state, String line) {
                Matcher matcher = NEW_CONTIG_PATTERN.matcher(line);
                if (!matcher.find()) {
                    return false;
                }
                state.visitReadBases();
                if (state.keepParsing()) {
                    state.visitEndContig();
                }
                if (state.keepParsing()) {
                    String contigId = matcher.group(1);
                    state.visitNewContig(contigId);
                }
                return true;
            }
        }
        ,
        NEW_READ{

            @Override
            protected boolean handle(State state, String line) {
                Matcher matcher = NEW_READ_PATTERN.matcher(line);
                if (!matcher.find()) {
                    return false;
                }
                String seqId = matcher.group(1);
                int offset = Integer.parseInt(matcher.group(2));
                Direction dir = TigrContigFileParser.parseComplimentedFlag(matcher) ? Direction.REVERSE : Direction.FORWARD;
                Range validRange = TigrContigFileParser.parseValidRange(matcher, dir);
                state.beginNewRead(seqId, offset, dir, validRange);
                return true;
            }
        }
        ,
        BASECALL_LINE{

            @Override
            protected boolean handle(State state, String line) {
                state.appendBasecalls(line);
                return true;
            }
        };


        protected abstract boolean handle(State var1, String var2);
    }

    private final class State {
        private boolean inConsensus = true;
        private TigrContigVisitor contigVisitor = null;
        private TigrContigReadVisitor readVisitor = null;
        private NucleotideSequenceBuilder currentBasesBuilder = new NucleotideSequenceBuilder();
        private AbstractTigrContigVisitorCallback callback = null;
        private final TextLineParser parser;
        private final TigrContigFileVisitor visitor;

        public State(TigrContigFileVisitor visitor, TextLineParser parser) {
            this.visitor = visitor;
            this.parser = parser;
        }

        public void visitReadBases() {
            if (this.readVisitor != null) {
                this.readVisitor.visitBasecalls(this.currentBasesBuilder.build());
                this.readVisitor.visitEnd();
            }
            this.currentBasesBuilder = new NucleotideSequenceBuilder();
        }

        public void appendBasecalls(String basecalls) {
            this.currentBasesBuilder.append(basecalls);
        }

        public void finishedParsing() {
            if (this.readVisitor != null && this.keepParsing()) {
                this.readVisitor.visitBasecalls(this.currentBasesBuilder.build());
                this.readVisitor.visitEnd();
            }
            if (this.contigVisitor != null) {
                if (this.keepParsing()) {
                    this.contigVisitor.visitEnd();
                } else {
                    this.contigVisitor.halted();
                }
            }
            if (this.keepParsing()) {
                this.visitor.visitEnd();
            } else {
                this.visitor.halted();
            }
        }

        public boolean keepParsing() {
            if (this.callback != null) {
                return this.callback.keepParsing();
            }
            return true;
        }

        public boolean notDone() {
            return this.keepParsing() && this.parser.hasNextLine();
        }

        public void advanceLine() throws IOException {
            this.parser.nextLine();
        }

        public String peekLine() {
            return this.parser.peekLine();
        }

        public void visitEndContig() {
            if (this.contigVisitor != null) {
                this.contigVisitor.visitEnd();
            }
            this.readVisitor = null;
            this.contigVisitor = null;
        }

        public void visitNewContig(String contigId) {
            this.inConsensus = true;
            this.callback = TigrContigFileParser.this.createCallback(this.parser.getPosition());
            this.contigVisitor = this.visitor.visitContig(this.callback, contigId);
            this.currentBasesBuilder = new NucleotideSequenceBuilder();
        }

        public void beginNewRead(String seqId, int offset, Direction dir, Range validRange) {
            if (this.inConsensus && this.contigVisitor != null) {
                this.contigVisitor.visitConsensus(this.currentBasesBuilder.build());
            }
            if (this.readVisitor != null) {
                this.readVisitor.visitBasecalls(this.currentBasesBuilder.build());
                this.readVisitor.visitEnd();
            }
            this.currentBasesBuilder = new NucleotideSequenceBuilder();
            this.inConsensus = false;
            this.readVisitor = this.contigVisitor == null ? null : this.contigVisitor.visitRead(seqId, offset, dir, validRange);
        }
    }
}

