/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.contig;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jcvi.jillion.assembly.tigr.contig.DefaultTigrContigFileDataStore;
import org.jcvi.jillion.assembly.tigr.contig.IndexedTigrContigFileDataStore;
import org.jcvi.jillion.assembly.tigr.contig.LargeTigrContigFileDataStore;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigDataStore;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.datastore.DataStoreProviderHint;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceDataStore;
import org.jcvi.jillion.fasta.nt.NucleotideFastaDataStore;

public class TigrContigFileDataStoreBuilder {
    private final File contigFile;
    private DataStoreFilter filter = DataStoreFilters.alwaysAccept();
    private DataStoreProviderHint hint = DataStoreProviderHint.RANDOM_ACCESS_OPTIMIZE_SPEED;
    private final DataStore<Long> fullSeqLengthDataStore;

    public TigrContigFileDataStoreBuilder(File contigFile, NucleotideFastaDataStore fullLengthSequenceDataStore) throws IOException {
        if (contigFile == null) {
            throw new NullPointerException("contig file can not be null");
        }
        if (!contigFile.exists()) {
            throw new FileNotFoundException("contig file must exist");
        }
        if (!contigFile.canRead()) {
            throw new IOException("contig file is not readable");
        }
        if (fullLengthSequenceDataStore == null) {
            throw new NullPointerException("sequence datastore can not be null");
        }
        this.contigFile = contigFile;
        this.fullSeqLengthDataStore = this.adapt(fullLengthSequenceDataStore);
    }

    public TigrContigFileDataStoreBuilder(File contigFile, NucleotideSequenceDataStore fullLengthSequenceDataStore) throws IOException {
        if (contigFile == null) {
            throw new NullPointerException("contig file can not be null");
        }
        if (!contigFile.exists()) {
            throw new FileNotFoundException("contig file must exist");
        }
        if (!contigFile.canRead()) {
            throw new IOException("contig file is not readable");
        }
        if (fullLengthSequenceDataStore == null) {
            throw new NullPointerException("sequence datastore can not be null");
        }
        this.contigFile = contigFile;
        this.fullSeqLengthDataStore = this.adapt(fullLengthSequenceDataStore);
    }

    private DataStore<Long> adapt(NucleotideFastaDataStore fullLengthSequenceDataStore) {
        return DataStore.adapt(DataStore.class, fullLengthSequenceDataStore, from -> ((NucleotideSequence)from.getSequence()).getUngappedLength());
    }

    private DataStore<Long> adapt(NucleotideSequenceDataStore fullLengthSequenceDataStore) {
        return DataStore.adapt(DataStore.class, fullLengthSequenceDataStore, from -> from.getUngappedLength());
    }

    public TigrContigFileDataStoreBuilder filter(DataStoreFilter filter) {
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        this.filter = filter;
        return this;
    }

    public TigrContigFileDataStoreBuilder hint(DataStoreProviderHint hint) {
        if (hint == null) {
            throw new NullPointerException("hint can not be null");
        }
        this.hint = hint;
        return this;
    }

    public TigrContigDataStore build() throws IOException {
        switch (this.hint) {
            case RANDOM_ACCESS_OPTIMIZE_SPEED: {
                return DefaultTigrContigFileDataStore.create(this.contigFile, this.fullSeqLengthDataStore, this.filter);
            }
            case RANDOM_ACCESS_OPTIMIZE_MEMORY: {
                return IndexedTigrContigFileDataStore.create(this.contigFile, this.fullSeqLengthDataStore, this.filter);
            }
            case ITERATION_ONLY: {
                return new LargeTigrContigFileDataStore(this.contigFile, this.fullSeqLengthDataStore, this.filter);
            }
        }
        throw new IllegalArgumentException("unknown provider hint : " + (Object)((Object)this.hint));
    }
}

