/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.contig;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jcvi.jillion.assembly.AbstractContigBuilder;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.AssembledReadBuilder;
import org.jcvi.jillion.assembly.Contig;
import org.jcvi.jillion.assembly.ReadInfo;
import org.jcvi.jillion.assembly.tigr.contig.TigrContig;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigRead;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigReadBuilder;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.ReferenceMappedNucleotideSequence;
import org.jcvi.jillion.core.util.MapUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.assembly.DefaultAssembledRead;
import org.jcvi.jillion.internal.assembly.DefaultContig;

public class TigrContigBuilder
extends AbstractContigBuilder<TigrContigRead, TigrContig> {
    public TigrContigBuilder(String id, NucleotideSequence consensus) {
        super(id, consensus);
    }

    protected TigrContigReadBuilder createPlacedReadBuilder(TigrContigRead read) {
        return this.createPlacedReadBuilder(read.getId(), (int)read.getGappedStartOffset(), read.getReadInfo().getValidRange(), read.getNucleotideSequence().toString(), read.getDirection(), read.getReadInfo().getUngappedFullLength());
    }

    protected TigrContigReadBuilder createPlacedReadBuilder(String id, int offset, Range validRange, String basecalls, Direction dir, int fullUngappedLength) {
        return new DefaultTigrContigReadBuilder(id, offset, validRange, basecalls, dir, fullUngappedLength);
    }

    @Override
    public TigrContig build() {
        if (this.consensusCaller != null) {
            this.recallConsensusNow();
        }
        int capacity = MapUtil.computeMinHashMapSizeWithoutRehashing(this.numberOfReads());
        LinkedHashMap<String, TigrContigRead> reads = new LinkedHashMap<String, TigrContigRead>(capacity);
        NucleotideSequence consensus = this.getConsensusBuilder().build();
        for (AssembledReadBuilder builder : this.getAllAssembledReadBuilders()) {
            reads.put(builder.getId(), (TigrContigRead)builder.build(consensus));
        }
        return new DefaultTigrContig(this.getContigId(), consensus, reads);
    }

    private static class DefaultTigrContigReadBuilder
    implements TigrContigReadBuilder {
        private final AssembledReadBuilder<AssembledRead> builder;

        private DefaultTigrContigReadBuilder(AssembledReadBuilder<AssembledRead> copy) {
            this.builder = copy.copy();
        }

        public DefaultTigrContigReadBuilder(String id, int offset, Range validRange, String basecalls, Direction dir, int fullUngappedLength) {
            this.builder = DefaultAssembledRead.createBuilder(id, basecalls, offset, dir, validRange, fullUngappedLength);
        }

        @Override
        public long getBegin() {
            return this.builder.getBegin();
        }

        @Override
        public String getId() {
            return this.builder.getId();
        }

        public TigrContigReadBuilder setStartOffset(int newOffset) {
            this.builder.setStartOffset(newOffset);
            return this;
        }

        public TigrContigReadBuilder shift(int numberOfBases) {
            this.builder.shift(numberOfBases);
            return this;
        }

        @Override
        public Range getClearRange() {
            return this.builder.getClearRange();
        }

        @Override
        public Direction getDirection() {
            return this.builder.getDirection();
        }

        @Override
        public int getUngappedFullLength() {
            return this.builder.getUngappedFullLength();
        }

        @Override
        public TigrContigRead build(NucleotideSequence consensus) {
            return new DefaultTigrContigRead(this.builder.build(consensus));
        }

        public TigrContigReadBuilder reAbacus(Range gappedValidRangeToChange, NucleotideSequence newBasecalls) {
            this.builder.reAbacus(gappedValidRangeToChange, newBasecalls);
            return this;
        }

        @Override
        public long getLength() {
            return this.builder.getLength();
        }

        @Override
        public long getEnd() {
            return this.builder.getEnd();
        }

        @Override
        public Range asRange() {
            return this.builder.asRange();
        }

        @Override
        public NucleotideSequence getCurrentNucleotideSequence() {
            return this.builder.getCurrentNucleotideSequence();
        }

        public TigrContigReadBuilder append(Nucleotide base) {
            this.builder.append(base);
            return this;
        }

        public TigrContigReadBuilder append(Iterable<Nucleotide> sequence) {
            this.builder.append(sequence);
            return this;
        }

        public TigrContigReadBuilder append(String sequence) {
            this.builder.append(sequence);
            return this;
        }

        public TigrContigReadBuilder insert(int offset, String sequence) {
            this.builder.insert(offset, sequence);
            return this;
        }

        public TigrContigReadBuilder replace(int offset, Nucleotide replacement) {
            this.builder.replace(offset, replacement);
            return this;
        }

        public TigrContigReadBuilder delete(Range range) {
            this.builder.delete(range);
            return this;
        }

        @Override
        public int getNumGaps() {
            return this.builder.getNumGaps();
        }

        @Override
        public int getNumNs() {
            return this.builder.getNumNs();
        }

        @Override
        public int getNumAmbiguities() {
            return this.builder.getNumAmbiguities();
        }

        public TigrContigReadBuilder prepend(String sequence) {
            this.builder.prepend(sequence);
            return this;
        }

        public TigrContigReadBuilder insert(int offset, Iterable<Nucleotide> sequence) {
            this.builder.insert(offset, sequence);
            return this;
        }

        public TigrContigReadBuilder insert(int offset, Nucleotide base) {
            this.builder.insert(offset, base);
            return this;
        }

        public TigrContigReadBuilder prepend(Iterable<Nucleotide> sequence) {
            this.builder.prepend(sequence);
            return this;
        }

        public TigrContigReadBuilder trim(Range trimRange) {
            this.builder.trim(trimRange);
            return this;
        }

        public TigrContigReadBuilder copy() {
            return new DefaultTigrContigReadBuilder(this.builder);
        }
    }

    private static class DefaultTigrContigRead
    implements TigrContigRead {
        private final AssembledRead delegate;

        public DefaultTigrContigRead(AssembledRead delegate) {
            this.delegate = delegate;
        }

        @Override
        public long getGappedStartOffset() {
            return this.delegate.getGappedStartOffset();
        }

        @Override
        public long getGappedEndOffset() {
            return this.delegate.getGappedEndOffset();
        }

        @Override
        public long getGappedLength() {
            return this.delegate.getGappedLength();
        }

        @Override
        public Direction getDirection() {
            return this.delegate.getDirection();
        }

        @Override
        public long toGappedValidRangeOffset(long referenceOffset) {
            return this.delegate.toGappedValidRangeOffset(referenceOffset);
        }

        @Override
        public long toReferenceOffset(long gappedValidRangeOffset) {
            return this.delegate.toReferenceOffset(gappedValidRangeOffset);
        }

        @Override
        public Range getGappedContigRange() {
            return this.delegate.getGappedContigRange();
        }

        @Override
        public Range asRange() {
            return this.delegate.asRange();
        }

        @Override
        public String getId() {
            return this.delegate.getId();
        }

        @Override
        public ReferenceMappedNucleotideSequence getNucleotideSequence() {
            return this.delegate.getNucleotideSequence();
        }

        @Override
        public ReadInfo getReadInfo() {
            return this.delegate.getReadInfo();
        }
    }

    private static class DefaultTigrContig
    implements TigrContig {
        private final Contig<TigrContigRead> delegate;

        public DefaultTigrContig(String id, NucleotideSequence consensus, Map<String, TigrContigRead> reads) {
            this.delegate = new DefaultContig<TigrContigRead>(id, consensus, reads);
        }

        @Override
        public String getId() {
            return this.delegate.getId();
        }

        @Override
        public long getNumberOfReads() {
            return this.delegate.getNumberOfReads();
        }

        @Override
        public StreamingIterator<TigrContigRead> getReadIterator() {
            return this.delegate.getReadIterator();
        }

        @Override
        public NucleotideSequence getConsensusSequence() {
            return this.delegate.getConsensusSequence();
        }

        @Override
        public TigrContigRead getRead(String id) {
            return this.delegate.getRead(id);
        }

        @Override
        public boolean containsRead(String readId) {
            return this.delegate.containsRead(readId);
        }
    }
}

