/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.contig;

import java.io.File;
import java.io.IOException;
import org.jcvi.jillion.assembly.tigr.contig.AbstractTigrContigBuilderVisitor;
import org.jcvi.jillion.assembly.tigr.contig.TigrContig;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigBuilder;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigDataStore;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigFileContigIterator;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigFileParser;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigFileVisitor;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigVisitor;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;
import org.jcvi.jillion.internal.core.util.iter.AbstractBlockingStreamingIterator;

final class LargeTigrContigFileDataStore
implements TigrContigDataStore {
    private static final String ERROR_PARSING_CONTIG_FILE = "error parsing contig file";
    private final DataStoreFilter filter;
    private final File contigFile;
    private final DataStore<Long> fullLengthSequences;
    private Long size = null;
    private volatile boolean closed = false;

    public LargeTigrContigFileDataStore(File contigFile, DataStore<Long> fullLengthSequences, DataStoreFilter filter) {
        this.contigFile = contigFile;
        this.fullLengthSequences = fullLengthSequences;
        this.filter = filter;
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new DataStoreClosedException("datastore is closed");
        }
    }

    @Override
    public StreamingIterator<String> idIterator() throws DataStoreException {
        this.checkNotClosed();
        IdIterator iter = new IdIterator();
        iter.start();
        return DataStoreStreamingIterator.create(this, iter);
    }

    @Override
    public TigrContig get(String id) throws DataStoreException {
        if (!this.filter.accept(id)) {
            return null;
        }
        GetVisitor visitor = new GetVisitor(id);
        try {
            TigrContigFileParser.create(this.contigFile).parse(visitor);
            return visitor.getContig();
        }
        catch (IOException e) {
            throw new DataStoreException(ERROR_PARSING_CONTIG_FILE, e);
        }
    }

    @Override
    public boolean contains(String id) throws DataStoreException {
        if (!this.filter.accept(id)) {
            return false;
        }
        ContainsVisitor visitor = new ContainsVisitor(id);
        try {
            TigrContigFileParser.create(this.contigFile).parse(visitor);
            return visitor.contains();
        }
        catch (IOException e) {
            throw new DataStoreException(ERROR_PARSING_CONTIG_FILE, e);
        }
    }

    @Override
    public synchronized long getNumberOfRecords() throws DataStoreException {
        if (this.size == null) {
            SizeVisitor visitor = new SizeVisitor();
            try {
                TigrContigFileParser.create(this.contigFile).parse(visitor);
                this.size = visitor.getSize();
            }
            catch (IOException e) {
                throw new DataStoreException(ERROR_PARSING_CONTIG_FILE, e);
            }
        }
        return this.size;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public StreamingIterator<TigrContig> iterator() throws DataStoreException {
        this.checkNotClosed();
        return DataStoreStreamingIterator.create(this, TigrContigFileContigIterator.create(this.contigFile, this.fullLengthSequences, this.filter));
    }

    @Override
    public StreamingIterator<DataStoreEntry<TigrContig>> entryIterator() throws DataStoreException {
        StreamingIterator<DataStoreEntry<TigrContig>> iter = new StreamingIterator<DataStoreEntry<TigrContig>>(){
            StreamingIterator<TigrContig> delegate;
            {
                this.delegate = TigrContigFileContigIterator.create(LargeTigrContigFileDataStore.this.contigFile, LargeTigrContigFileDataStore.this.fullLengthSequences, LargeTigrContigFileDataStore.this.filter);
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public void close() {
                this.delegate.close();
            }

            @Override
            public DataStoreEntry<TigrContig> next() {
                TigrContig trace = this.delegate.next();
                return new DataStoreEntry<TigrContig>(trace.getId(), trace);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return DataStoreStreamingIterator.create(this, iter);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    private class SizeVisitor
    implements TigrContigFileVisitor {
        private long size = 0L;

        private SizeVisitor() {
        }

        @Override
        public TigrContigVisitor visitContig(TigrContigFileVisitor.TigrContigVisitorCallback callback, String contigId) {
            if (LargeTigrContigFileDataStore.this.filter.accept(contigId)) {
                ++this.size;
            }
            return null;
        }

        public long getSize() {
            return this.size;
        }

        @Override
        public void halted() {
        }

        @Override
        public void visitEnd() {
        }
    }

    private class GetVisitor
    implements TigrContigFileVisitor {
        private final String id;
        private TigrContig contig;

        public GetVisitor(String id) {
            this.id = id;
        }

        @Override
        public TigrContigVisitor visitContig(final TigrContigFileVisitor.TigrContigVisitorCallback callback, String contigId) {
            if (this.id.equals(contigId)) {
                return new AbstractTigrContigBuilderVisitor(contigId, LargeTigrContigFileDataStore.this.fullLengthSequences){

                    @Override
                    protected void visitContig(TigrContigBuilder builder) {
                        GetVisitor.this.contig = builder.build();
                        callback.haltParsing();
                    }
                };
            }
            return null;
        }

        public TigrContig getContig() {
            return this.contig;
        }

        @Override
        public void halted() {
        }

        @Override
        public void visitEnd() {
        }
    }

    private static final class ContainsVisitor
    implements TigrContigFileVisitor {
        private final String id;
        private boolean contains = false;

        public ContainsVisitor(String id) {
            this.id = id;
        }

        @Override
        public TigrContigVisitor visitContig(TigrContigFileVisitor.TigrContigVisitorCallback callback, String contigId) {
            if (this.id.equals(contigId)) {
                this.contains = true;
                callback.haltParsing();
            }
            return null;
        }

        public boolean contains() {
            return this.contains;
        }

        @Override
        public void halted() {
        }

        @Override
        public void visitEnd() {
        }
    }

    private class IdIterator
    extends AbstractBlockingStreamingIterator<String> {
        private IdIterator() {
        }

        @Override
        protected void backgroundThreadRunMethod() throws RuntimeException {
            TigrContigFileVisitor visitor = new TigrContigFileVisitor(){

                @Override
                public void halted() {
                }

                @Override
                public void visitEnd() {
                }

                @Override
                public TigrContigVisitor visitContig(TigrContigFileVisitor.TigrContigVisitorCallback callback, String contigId) {
                    if (LargeTigrContigFileDataStore.this.filter.accept(contigId)) {
                        IdIterator.this.blockingPut(contigId);
                    }
                    return null;
                }
            };
            try {
                TigrContigFileParser.create(LargeTigrContigFileDataStore.this.contigFile).parse(visitor);
            }
            catch (IOException e) {
                throw new RuntimeException(LargeTigrContigFileDataStore.ERROR_PARSING_CONTIG_FILE, e);
            }
        }
    }
}

