/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.contig;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jcvi.jillion.assembly.tigr.contig.AbstractTigrContigBuilderVisitor;
import org.jcvi.jillion.assembly.tigr.contig.TigrContig;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigBuilder;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigDataStore;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigFileContigIterator;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigFileParser;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigFileVisitor;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigParser;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigVisitor;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;

final class IndexedTigrContigFileDataStore
implements TigrContigDataStore {
    private final Map<String, TigrContigFileVisitor.TigrContigVisitorCallback.TigrContigVisitorMemento> mementos;
    private final DataStore<Long> fullLengthSequences;
    private final DataStoreFilter filter;
    private final File contigFile;
    private volatile boolean closed = false;
    private final TigrContigParser parser;

    public static TigrContigDataStore create(File contigFile, DataStore<Long> fullLengthSequences, DataStoreFilter filter) throws IOException {
        TigrContigParser parser = TigrContigFileParser.create(contigFile);
        IndexedDataStorBuilder visitor = new IndexedDataStorBuilder(filter);
        parser.parse(visitor);
        return visitor.build(contigFile, fullLengthSequences, parser);
    }

    private IndexedTigrContigFileDataStore(File contigFile, DataStoreFilter filter, DataStore<Long> fullLengthSequences, TigrContigParser parser, Map<String, TigrContigFileVisitor.TigrContigVisitorCallback.TigrContigVisitorMemento> mementos) {
        this.contigFile = contigFile;
        this.filter = filter;
        this.fullLengthSequences = fullLengthSequences;
        this.mementos = mementos;
        this.parser = parser;
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new DataStoreClosedException("datastore is closed");
        }
    }

    @Override
    public StreamingIterator<String> idIterator() throws DataStoreException {
        this.checkNotClosed();
        return DataStoreStreamingIterator.create(this, this.mementos.keySet().iterator());
    }

    @Override
    public TigrContig get(String id) throws DataStoreException {
        this.checkNotClosed();
        TigrContigFileVisitor.TigrContigVisitorCallback.TigrContigVisitorMemento memento = this.mementos.get(id);
        if (memento == null) {
            return null;
        }
        SingleContigVisitor visitor = new SingleContigVisitor();
        try {
            this.parser.parse(visitor, memento);
        }
        catch (IOException e) {
            throw new DataStoreException("error parsing contig file to get " + id, e);
        }
        return visitor.contig;
    }

    @Override
    public boolean contains(String id) throws DataStoreException {
        this.checkNotClosed();
        return this.mementos.containsKey(id);
    }

    @Override
    public long getNumberOfRecords() throws DataStoreException {
        this.checkNotClosed();
        return this.mementos.size();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public StreamingIterator<TigrContig> iterator() throws DataStoreException {
        this.checkNotClosed();
        return DataStoreStreamingIterator.create(this, TigrContigFileContigIterator.create(this.contigFile, this.fullLengthSequences, this.filter));
    }

    @Override
    public StreamingIterator<DataStoreEntry<TigrContig>> entryIterator() throws DataStoreException {
        StreamingIterator<DataStoreEntry<TigrContig>> iter = new StreamingIterator<DataStoreEntry<TigrContig>>(){
            StreamingIterator<TigrContig> delegate;
            {
                this.delegate = TigrContigFileContigIterator.create(IndexedTigrContigFileDataStore.this.contigFile, IndexedTigrContigFileDataStore.this.fullLengthSequences, IndexedTigrContigFileDataStore.this.filter);
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public void close() {
                this.delegate.close();
            }

            @Override
            public DataStoreEntry<TigrContig> next() {
                TigrContig trace = this.delegate.next();
                return new DataStoreEntry<TigrContig>(trace.getId(), trace);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return DataStoreStreamingIterator.create(this, iter);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.mementos.clear();
    }

    private static final class IndexedDataStorBuilder
    implements TigrContigFileVisitor {
        private final DataStoreFilter filter;
        private final Map<String, TigrContigFileVisitor.TigrContigVisitorCallback.TigrContigVisitorMemento> mementos = new LinkedHashMap<String, TigrContigFileVisitor.TigrContigVisitorCallback.TigrContigVisitorMemento>();

        private IndexedDataStorBuilder(DataStoreFilter filter) {
            this.filter = filter;
        }

        @Override
        public TigrContigVisitor visitContig(TigrContigFileVisitor.TigrContigVisitorCallback callback, String contigId) {
            if (this.filter.accept(contigId)) {
                if (!callback.canCreateMemento()) {
                    throw new IllegalStateException("indexed datastore needs to create mementos");
                }
                this.mementos.put(contigId, callback.createMemento());
            }
            return null;
        }

        @Override
        public void halted() {
        }

        @Override
        public void visitEnd() {
        }

        public TigrContigDataStore build(File contigFile, DataStore<Long> fullLengthSequences, TigrContigParser parser) {
            return new IndexedTigrContigFileDataStore(contigFile, this.filter, fullLengthSequences, parser, this.mementos);
        }
    }

    private final class SingleContigVisitor
    implements TigrContigFileVisitor {
        TigrContig contig = null;

        private SingleContigVisitor() {
        }

        @Override
        public TigrContigVisitor visitContig(final TigrContigFileVisitor.TigrContigVisitorCallback callback, String contigId) {
            return new AbstractTigrContigBuilderVisitor(contigId, IndexedTigrContigFileDataStore.this.fullLengthSequences){

                @Override
                protected void visitContig(TigrContigBuilder builder) {
                    SingleContigVisitor.this.contig = builder.build();
                    callback.haltParsing();
                }
            };
        }

        @Override
        public void halted() {
        }

        @Override
        public void visitEnd() {
        }
    }
}

