/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.contig;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jcvi.jillion.assembly.tigr.contig.AbstractTigrContigBuilderVisitor;
import org.jcvi.jillion.assembly.tigr.contig.TigrContig;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigBuilder;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigDataStore;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigFileParser;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigFileVisitor;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigVisitor;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreFilter;

final class DefaultTigrContigFileDataStore {
    public static TigrContigDataStore create(File contigFile, DataStore<Long> fullLengthSequenceDataStore, DataStoreFilter filter) throws IOException {
        DataStoreBuilder visitor = new DataStoreBuilder(fullLengthSequenceDataStore, filter);
        TigrContigFileParser.create(contigFile).parse(visitor);
        return DataStore.of(visitor.contigs, TigrContigDataStore.class);
    }

    private DefaultTigrContigFileDataStore() {
    }

    private static final class DataStoreBuilder
    implements TigrContigFileVisitor {
        private final Map<String, TigrContig> contigs = new LinkedHashMap<String, TigrContig>();
        private final DataStoreFilter filter;
        private final DataStore<Long> fullLengthSequenceDataStore;

        public DataStoreBuilder(DataStore<Long> fullLengthSequenceDataStore, DataStoreFilter filter) {
            this.filter = filter;
            this.fullLengthSequenceDataStore = fullLengthSequenceDataStore;
        }

        @Override
        public TigrContigVisitor visitContig(TigrContigFileVisitor.TigrContigVisitorCallback callback, final String contigId) {
            if (!this.filter.accept(contigId)) {
                return null;
            }
            return new AbstractTigrContigBuilderVisitor(contigId, this.fullLengthSequenceDataStore){

                @Override
                protected void visitContig(TigrContigBuilder builder) {
                    contigs.put(contigId, builder.build());
                }
            };
        }

        @Override
        public void halted() {
        }

        @Override
        public void visitEnd() {
        }
    }
}

