/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.contig;

import org.jcvi.jillion.assembly.tigr.contig.TigrContigBuilder;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigReadVisitor;
import org.jcvi.jillion.assembly.tigr.contig.TigrContigVisitor;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;

public abstract class AbstractTigrContigBuilderVisitor
implements TigrContigVisitor {
    private final DataStore<Long> fullRangeLengthDataStore;
    private TigrContigBuilder currentContigBuilder;
    private final String contigId;

    public AbstractTigrContigBuilderVisitor(String contigId, DataStore<Long> fullLengthSequenceDataStore) {
        this.fullRangeLengthDataStore = fullLengthSequenceDataStore;
        this.contigId = contigId;
    }

    @Override
    public void visitConsensus(NucleotideSequence consensus) {
        this.currentContigBuilder = new TigrContigBuilder(this.contigId, consensus);
    }

    @Override
    public TigrContigReadVisitor visitRead(final String readId, final long gappedStartOffset, final Direction dir, final Range validRange) {
        return new TigrContigReadVisitor(){
            private NucleotideSequence gappedBasecalls;

            @Override
            public void visitEnd() {
                Long fullLength;
                try {
                    fullLength = (Long)AbstractTigrContigBuilderVisitor.this.fullRangeLengthDataStore.get(readId);
                }
                catch (DataStoreException e) {
                    throw new IllegalStateException("error reading from full length sequence datastore for read " + readId, e);
                }
                if (fullLength == null) {
                    throw new IllegalStateException("full length sequence datastore did not contain read " + readId);
                }
                AbstractTigrContigBuilderVisitor.this.currentContigBuilder.addRead(readId, (int)gappedStartOffset, validRange, this.gappedBasecalls.toString(), dir, fullLength.intValue());
            }

            @Override
            public void visitBasecalls(NucleotideSequence gappedBasecalls) {
                this.gappedBasecalls = gappedBasecalls;
            }
        };
    }

    @Override
    public void halted() {
    }

    @Override
    public final void visitEnd() {
        if (this.currentContigBuilder == null) {
            throw new IllegalStateException("contig does not contain any consensus or read data");
        }
        this.visitContig(this.currentContigBuilder);
        this.currentContigBuilder = null;
    }

    protected abstract void visitContig(TigrContigBuilder var1);
}

