/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.transform;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jcvi.jillion.assembly.AssemblyTransformationService;
import org.jcvi.jillion.assembly.AssemblyTransformer;
import org.jcvi.jillion.assembly.AssemblyUtil;
import org.jcvi.jillion.assembly.ReadInfo;
import org.jcvi.jillion.assembly.consed.ConsedUtil;
import org.jcvi.jillion.assembly.consed.ace.AbstractAceFileVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceContigReadVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceContigVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceFileParser;
import org.jcvi.jillion.assembly.consed.ace.AceFileVisitorCallback;
import org.jcvi.jillion.assembly.consed.phd.PhdDataStore;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;

public class ConsedTransformationService
implements AssemblyTransformationService {
    File consedDir;
    File aceFile;
    private final PhdDataStore phdDataStore;

    private ConsedTransformationService(Builder builder) throws IOException {
        this.consedDir = builder.consedDir;
        this.phdDataStore = builder.includeQualities ? ConsedUtil.createPhdDataStoreFor(this.consedDir) : null;
        File editDir = ConsedUtil.getEditDirFor(this.consedDir);
        this.aceFile = builder.aceVersion == null ? ConsedUtil.getLatestAceFile(editDir, builder.acePrefix) : ConsedUtil.getAceFile(editDir, builder.acePrefix, builder.aceVersion);
        if (this.aceFile == null) {
            throw new IOException("specified ace file not found in edit_dir : " + editDir.getAbsolutePath());
        }
    }

    @Override
    public void transform(final AssemblyTransformer transformer) throws IOException {
        if (transformer == null) {
            throw new NullPointerException("transformer can not be null");
        }
        AceFileParser.create(this.aceFile).parse(new AbstractAceFileVisitor(){

            @Override
            public AceContigVisitor visitContig(AceFileVisitorCallback callback, final String contigId, int consensusLength, int numberOfReads, int numberOfBaseSegments, boolean reverseComplemented) {
                return new AceContigVisitor(){
                    NucleotideSequenceBuilder consensusBuilder = new NucleotideSequenceBuilder();
                    boolean madeReferenceCallYet = false;
                    Map<String, Integer> readStarts = new HashMap<String, Integer>();
                    Map<String, Direction> readDirs = new HashMap<String, Direction>();

                    @Override
                    public void visitEnd() {
                        if (!this.madeReferenceCallYet) {
                            this.makeReferenceCall();
                        }
                    }

                    @Override
                    public void visitConsensusQualities(QualitySequence ungappedConsensusQualities) {
                    }

                    @Override
                    public AceContigReadVisitor visitBeginRead(final String readId, int gappedLength) {
                        if (!this.madeReferenceCallYet) {
                            this.makeReferenceCall();
                        }
                        return new AceContigReadVisitor(){
                            NucleotideSequenceBuilder fullLengthReadBuilder = new NucleotideSequenceBuilder();
                            Range gappedValidRange = null;

                            @Override
                            public void visitTraceDescriptionLine(String traceName, String phdName, Date date) {
                            }

                            @Override
                            public void visitQualityLine(int qualLeft, int qualRight, int alignLeft, int alignRight) {
                                ConsedUtil.ClipPointsType clipPointsType = ConsedUtil.ClipPointsType.getType(qualLeft, qualRight, alignLeft, alignRight);
                                if (clipPointsType != ConsedUtil.ClipPointsType.VALID) {
                                    return;
                                }
                                Range qualityRange = Range.of(Range.CoordinateSystem.RESIDUE_BASED, qualLeft, qualRight);
                                Range alignmentRange = Range.of(Range.CoordinateSystem.RESIDUE_BASED, alignLeft, alignRight);
                                this.gappedValidRange = qualityRange.intersection(alignmentRange);
                            }

                            @Override
                            public void visitEnd() {
                                NucleotideSequence gappedValidRangeSequence = this.fullLengthReadBuilder.copy().trim(this.gappedValidRange).build();
                                NucleotideSequence gappedFullLengthSequence = this.fullLengthReadBuilder.build();
                                NucleotideSequence ungappedFullLengthSequence = this.fullLengthReadBuilder.ungap().build();
                                transformer.aligned(readId, ungappedFullLengthSequence, null, null, null, contigId, readStarts.get(readId).intValue(), readDirs.get(readId), gappedValidRangeSequence, new ReadInfo(AssemblyUtil.toUngappedRange(gappedFullLengthSequence, this.gappedValidRange), (int)ungappedFullLengthSequence.getLength()));
                            }

                            @Override
                            public void visitBasesLine(String mixedCaseBasecalls) {
                                this.fullLengthReadBuilder.append(mixedCaseBasecalls);
                            }

                            @Override
                            public void halted() {
                            }
                        };
                    }

                    private void makeReferenceCall() {
                        this.madeReferenceCallYet = true;
                        transformer.referenceOrConsensus(contigId, this.consensusBuilder.build());
                    }

                    @Override
                    public void visitBasesLine(String mixedCaseBasecalls) {
                        this.consensusBuilder.append(mixedCaseBasecalls);
                    }

                    @Override
                    public void visitBaseSegment(Range gappedConsensusRange, String readId) {
                    }

                    @Override
                    public void visitAlignedReadInfo(String readId, Direction dir, int gappedStartPosition) {
                        this.readStarts.put(readId, gappedStartPosition - 1);
                        this.readDirs.put(readId, dir);
                    }

                    @Override
                    public void halted() {
                    }
                };
            }

            @Override
            public void visitEnd() {
                transformer.endAssembly();
            }
        });
    }

    public static class Builder {
        private final File consedDir;
        private final File editDir;
        private final String acePrefix;
        private Integer aceVersion = null;
        private boolean includeQualities = false;

        public Builder(File consedDir, String acePrefix) {
            if (!consedDir.exists()) {
                throw new IllegalArgumentException("consed directory does not exist : " + consedDir.getAbsolutePath());
            }
            if (acePrefix == null) {
                throw new NullPointerException("ace prefix can not be null");
            }
            this.editDir = ConsedUtil.getEditDirFor(consedDir);
            if (!this.editDir.exists()) {
                throw new IllegalStateException("edit_dir does not exist : " + consedDir.getAbsolutePath());
            }
            this.consedDir = consedDir;
            this.acePrefix = acePrefix;
        }

        public Builder includeQualities(boolean includeQualities) {
            this.includeQualities = includeQualities;
            return this;
        }

        public Builder useAceVersion(int version) {
            File ace = ConsedUtil.getAceFile(this.editDir, this.acePrefix, version);
            if (ace == null) {
                throw new IllegalArgumentException("ace file with version " + version + " does not exist in " + this.editDir.getAbsolutePath());
            }
            this.aceVersion = version;
            return this;
        }

        public ConsedTransformationService build() throws IOException {
            return new ConsedTransformationService(this);
        }
    }
}

