/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.phd;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdBuilder;
import org.jcvi.jillion.assembly.consed.phd.PhdDataStore;
import org.jcvi.jillion.assembly.consed.phd.PhdUtil;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.FileUtil;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;
import org.jcvi.jillion.trace.chromat.Chromatogram;
import org.jcvi.jillion.trace.chromat.ChromatogramFactory;

public class TraceDirPhdDataStoreBuilder {
    private final File dir;
    private Function<File, String> nameConverter = f -> FileUtil.getBaseName(f);
    private Function<File, Date> dateFunction = f -> new Date(f.lastModified());

    public TraceDirPhdDataStoreBuilder(File traceDir) throws IOException {
        IOUtil.verifyIsReadable(traceDir);
        this.dir = traceDir;
    }

    public TraceDirPhdDataStoreBuilder dateFunction(Function<File, Date> dateFunction) {
        Objects.requireNonNull(dateFunction);
        this.dateFunction = dateFunction;
        return this;
    }

    public TraceDirPhdDataStoreBuilder nameConverter(Function<File, String> nameConverter) {
        Objects.requireNonNull(nameConverter);
        this.nameConverter = nameConverter;
        return this;
    }

    public PhdDataStore build() throws IOException {
        return new TraceDirPhdDataStore(this);
    }

    private static final class TraceDirPhdDataStore
    implements PhdDataStore {
        private final Map<String, File> fileMapping = new LinkedHashMap<String, File>();
        private final Function<File, Date> dateFunction;

        public TraceDirPhdDataStore(TraceDirPhdDataStoreBuilder builder) throws IOException {
            File dir = builder.dir;
            Function nameConverter = builder.nameConverter;
            this.dateFunction = builder.dateFunction;
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                String id;
                if (f.isDirectory() || (id = (String)nameConverter.apply(f)) == null) continue;
                this.fileMapping.put(id, f);
            }
        }

        @Override
        public StreamingIterator<String> idIterator() throws DataStoreException {
            return DataStoreStreamingIterator.create(this, IteratorUtil.createStreamingIterator(this.fileMapping.keySet()));
        }

        @Override
        public Phd get(String id) throws DataStoreException {
            File f = this.fileMapping.get(id);
            if (f == null) {
                return null;
            }
            try {
                return this.asPhd(f, id);
            }
            catch (IOException e) {
                throw new DataStoreException(e.getMessage(), e);
            }
        }

        private Phd asPhd(File f, String id) throws IOException {
            Chromatogram chromo = ChromatogramFactory.create(id, f);
            Date chromoDate = this.dateFunction.apply(f);
            return new PhdBuilder(chromo).comments(PhdUtil.createPhdTimeStampAndChromatFileCommentsFor(chromoDate, f.getName())).build();
        }

        @Override
        public boolean contains(String id) throws DataStoreException {
            return this.fileMapping.containsKey(id);
        }

        @Override
        public long getNumberOfRecords() throws DataStoreException {
            return this.fileMapping.size();
        }

        @Override
        public boolean isClosed() {
            return false;
        }

        @Override
        public StreamingIterator<Phd> iterator() throws DataStoreException {
            return DataStoreStreamingIterator.create(this, new StreamingIterator<Phd>(){
                StreamingIterator<String> idIter;
                {
                    this.idIter = this.idIterator();
                }

                @Override
                public boolean hasNext() {
                    return this.idIter.hasNext();
                }

                @Override
                public void close() {
                    this.idIter.close();
                }

                @Override
                public Phd next() {
                    try {
                        return this.get(this.idIter.next());
                    }
                    catch (DataStoreException e) {
                        throw new IllegalStateException(e);
                    }
                }
            });
        }

        @Override
        public StreamingIterator<DataStoreEntry<Phd>> entryIterator() throws DataStoreException {
            return DataStoreStreamingIterator.create(this, new StreamingIterator<DataStoreEntry<Phd>>(){
                StreamingIterator<Phd> iter;
                {
                    this.iter = this.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public void close() {
                    this.iter.close();
                }

                @Override
                public DataStoreEntry<Phd> next() {
                    Phd phd = this.iter.next();
                    return new DataStoreEntry<Phd>(phd.getId(), phd);
                }
            });
        }

        @Override
        public void close() throws IOException {
        }
    }
}

