/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.phd;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdBallWriter;
import org.jcvi.jillion.assembly.consed.phd.PhdWriter;
import org.jcvi.jillion.core.io.IOUtil;

public final class SinglePhdWriter
implements PhdWriter {
    private boolean alreadyWrittenRecord = false;
    private final PhdWriter delegateWriter;

    public SinglePhdWriter(OutputStream out) throws IOException {
        this.delegateWriter = new PhdBallWriter(out);
    }

    public SinglePhdWriter(File outputFile) throws IOException {
        IOUtil.mkdirs(outputFile.getParentFile());
        this.delegateWriter = new PhdBallWriter(new FileOutputStream(outputFile));
    }

    @Override
    public void close() throws IOException {
        this.delegateWriter.close();
    }

    @Override
    public void write(Phd phd) throws IOException {
        this.write(phd, null);
    }

    @Override
    public void write(Phd phd, Integer version) throws IOException {
        if (this.alreadyWrittenRecord) {
            throw new IOException("already wrote a phd to this file; only one allowed per file");
        }
        this.delegateWriter.write(phd, version);
        this.alreadyWrittenRecord = true;
    }
}

