/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.phd;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jcvi.jillion.assembly.consed.ace.AceFileUtil;

public final class PhdUtil {
    private static ThreadLocal<DateFormat> PHD_TAG_DATE_FORMATTER = new ThreadLocal<DateFormat>(){

        @Override
        public DateFormat get() {
            return (DateFormat)super.get();
        }

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("MM/dd/yy HH:mm:ss", Locale.US);
        }

        @Override
        public void remove() {
            super.remove();
        }

        @Override
        public void set(DateFormat value) {
            super.set(value);
        }
    };

    private PhdUtil() {
    }

    public static Date parseReadTagDate(String dateString) throws ParseException {
        return PHD_TAG_DATE_FORMATTER.get().parse(dateString);
    }

    public static String formatReadTagDate(Date date) {
        return PHD_TAG_DATE_FORMATTER.get().format(date);
    }

    public static Map<String, String> createPhdTimeStampCommentFor(Date phdDate) {
        HashMap<String, String> comments = new HashMap<String, String>();
        comments.put("TIME", AceFileUtil.formatPhdDate(phdDate));
        return comments;
    }

    public static Map<String, String> createPhdTimeStampAndChromatFileCommentsFor(Date phdDate, String filename) {
        HashMap<String, String> comments = new HashMap<String, String>();
        comments.put("TIME", AceFileUtil.formatPhdDate(phdDate));
        comments.put("CHROMAT_FILE", filename);
        return comments;
    }
}

