/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.phd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.jcvi.jillion.assembly.consed.phd.DefaultPhdDataStore;
import org.jcvi.jillion.assembly.consed.phd.IndexedPhdDataStore;
import org.jcvi.jillion.assembly.consed.phd.LargePhdballDataStore;
import org.jcvi.jillion.assembly.consed.phd.PhdDataStore;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.datastore.DataStoreProviderHint;
import org.jcvi.jillion.core.util.Builder;

public final class PhdFileDataStoreBuilder
implements Builder<PhdDataStore> {
    private final File phdFile;
    private final InputStream inputStream;
    private DataStoreFilter filter = DataStoreFilters.alwaysAccept();
    private DataStoreProviderHint hint = DataStoreProviderHint.RANDOM_ACCESS_OPTIMIZE_SPEED;

    public PhdFileDataStoreBuilder(File phdFile) {
        if (phdFile == null) {
            throw new NullPointerException("phd file can not be null");
        }
        if (!phdFile.exists()) {
            throw new NullPointerException("phd file does not exist : " + phdFile.getAbsolutePath());
        }
        this.phdFile = phdFile;
        this.inputStream = null;
    }

    public PhdFileDataStoreBuilder(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream can not be null");
        }
        this.phdFile = null;
        this.inputStream = inputStream;
    }

    public PhdFileDataStoreBuilder filter(DataStoreFilter filter) {
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        this.filter = filter;
        return this;
    }

    public PhdFileDataStoreBuilder hint(DataStoreProviderHint hint) {
        if (hint == null) {
            throw new NullPointerException("hint can not be null");
        }
        this.hint = hint;
        return this;
    }

    @Override
    public PhdDataStore build() {
        try {
            if (this.inputStream != null) {
                return DefaultPhdDataStore.create(this.inputStream, this.filter);
            }
            switch (this.hint) {
                case RANDOM_ACCESS_OPTIMIZE_SPEED: {
                    return DefaultPhdDataStore.create(this.phdFile, this.filter);
                }
                case RANDOM_ACCESS_OPTIMIZE_MEMORY: {
                    return IndexedPhdDataStore.create(this.phdFile, this.filter);
                }
                case ITERATION_ONLY: {
                    return new LargePhdballDataStore(this.phdFile, this.filter);
                }
            }
            throw new IllegalStateException("unknown hint " + (Object)((Object)this.hint));
        }
        catch (IOException e) {
            throw new IllegalStateException("error bulding phd datastore ", e);
        }
    }
}

