/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.phd;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdDataStore;
import org.jcvi.jillion.assembly.consed.phd.PhdFileDataStoreBuilder;
import org.jcvi.jillion.assembly.consed.phd.ReadPhdFileFilter;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.FileUtil;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;

public class PhdDirDataStore
implements PhdDataStore {
    private static final Pattern PHD_FILE_PATTERN = Pattern.compile("^(\\S+)\\.phd.\\d+$");
    private final File phdDir;
    private final PhdDataStore phdBallDataStore;
    private volatile boolean closed = false;

    public PhdDirDataStore(File phdDir) throws IOException {
        this.phdDir = phdDir;
        File phdBall = this.getPhdFileFor("phd.ball");
        this.phdBallDataStore = phdBall == null ? null : new PhdFileDataStoreBuilder(phdBall).build();
    }

    private File getPhdFileFor(String readId) {
        int latestVersion = Integer.MIN_VALUE;
        File latestFile = null;
        for (File phd : this.phdDir.listFiles(new ReadPhdFileFilter(readId))) {
            int version = Integer.parseInt(FileUtil.getExtension(phd.getName()));
            if (version <= latestVersion) continue;
            latestVersion = version;
            latestFile = phd;
        }
        return latestFile;
    }

    @Override
    public StreamingIterator<String> idIterator() throws DataStoreException {
        return new StreamingIterator<String>(){
            final StreamingIterator<Phd> phdIter;
            {
                this.phdIter = PhdDirDataStore.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.phdIter.hasNext();
            }

            @Override
            public void close() {
                this.phdIter.close();
            }

            @Override
            public String next() {
                return this.phdIter.next().getId();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Set<String> getPhdDirUniqueNames() {
        HashSet<String> ids = new HashSet<String>();
        for (String filename : this.phdDir.list()) {
            Matcher matcher = PHD_FILE_PATTERN.matcher(filename);
            if (!matcher.matches()) continue;
            ids.add(matcher.group(1));
        }
        return ids;
    }

    @Override
    public Phd get(String id) throws DataStoreException {
        return this.getPhdFor(id);
    }

    private Phd getPhdFor(String id) throws DataStoreException {
        File phdFile = this.getPhdFileFor(id);
        if (phdFile == null) {
            if (this.phdBallDataStore == null) {
                return null;
            }
            return (Phd)this.phdBallDataStore.get(id);
        }
        return (Phd)new PhdFileDataStoreBuilder(phdFile).build().get(id);
    }

    @Override
    public boolean contains(String id) throws DataStoreException {
        boolean hasPhd;
        boolean bl = hasPhd = this.getPhdFileFor(id) != null;
        if (!hasPhd && this.phdBallDataStore != null) {
            return this.phdBallDataStore.contains(id);
        }
        return hasPhd;
    }

    private Set<String> getUniquePhdDirNamesNotInPhdBall() throws DataStoreException {
        if (this.phdBallDataStore == null) {
            return this.getPhdDirUniqueNames();
        }
        Set<String> individualIds = this.getPhdDirUniqueNames();
        Iterator<String> phdDirIter = individualIds.iterator();
        while (phdDirIter.hasNext()) {
            String id = phdDirIter.next();
            if (!this.phdBallDataStore.contains(id)) continue;
            phdDirIter.remove();
        }
        return individualIds;
    }

    @Override
    public long getNumberOfRecords() throws DataStoreException {
        if (this.phdBallDataStore == null) {
            return this.getPhdDirUniqueNames().size();
        }
        return this.phdBallDataStore.getNumberOfRecords() + (long)this.getUniquePhdDirNamesNotInPhdBall().size();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.phdBallDataStore != null) {
            IOUtil.closeAndIgnoreErrors((Closeable)this.phdBallDataStore);
        }
    }

    @Override
    public StreamingIterator<Phd> iterator() {
        try {
            return new PhdFromIdIterator();
        }
        catch (DataStoreException e) {
            throw new IllegalStateException("error getting phd iterator", e);
        }
    }

    @Override
    public StreamingIterator<DataStoreEntry<Phd>> entryIterator() throws DataStoreException {
        return new StreamingIterator<DataStoreEntry<Phd>>(){
            StreamingIterator<Phd> iter;
            {
                this.iter = PhdDirDataStore.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public void close() {
                this.iter.close();
            }

            @Override
            public DataStoreEntry<Phd> next() {
                Phd next = this.iter.next();
                return new DataStoreEntry<Phd>(next.getId(), next);
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    private PhdDirDataStore getOuter() {
        return this;
    }

    private class PhdFromIdIterator
    implements StreamingIterator<Phd> {
        private final Set<String> individualPhds;
        private final StreamingIterator<String> individualPhdIter;
        private final StreamingIterator<Phd> phdBallIter;
        private Phd next = null;

        public PhdFromIdIterator() throws DataStoreException {
            this.individualPhds = PhdDirDataStore.this.getPhdDirUniqueNames();
            this.individualPhdIter = DataStoreStreamingIterator.create(PhdDirDataStore.this.getOuter(), this.individualPhds.iterator());
            this.phdBallIter = PhdDirDataStore.this.phdBallDataStore == null ? null : PhdDirDataStore.this.phdBallDataStore.iterator();
            this.updateNext();
        }

        private void updateNext() throws DataStoreException {
            if (this.individualPhdIter.hasNext()) {
                this.next = PhdDirDataStore.this.getPhdFor(this.individualPhdIter.next());
                return;
            }
            if (PhdDirDataStore.this.phdBallDataStore == null) {
                this.next = null;
            } else {
                boolean done = false;
                while (!done && this.phdBallIter.hasNext()) {
                    Phd nextPhdBallRecord = this.phdBallIter.next();
                    if (this.individualPhds.contains(nextPhdBallRecord.getId())) continue;
                    this.next = nextPhdBallRecord;
                    return;
                }
                this.next = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public void close() {
            IOUtil.closeAndIgnoreErrors(this.phdBallIter, this.individualPhdIter);
        }

        @Override
        public Phd next() {
            Phd ret = this.next;
            try {
                this.updateNext();
            }
            catch (DataStoreException e) {
                throw new IllegalStateException("could not get next record", e);
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

