/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.phd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jcvi.jillion.assembly.consed.phd.ArtificialPhd;
import org.jcvi.jillion.assembly.consed.phd.DefaultPhd;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdReadTag;
import org.jcvi.jillion.assembly.consed.phd.PhdWholeReadItem;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.trace.chromat.Chromatogram;

public final class PhdBuilder
implements Builder<Phd> {
    private static final int DEFAULT_START_POSITION = 15;
    private static final int DEFAULT_PEAK_SPACING = 19;
    private final String id;
    private final NucleotideSequence sequence;
    private final QualitySequence qualities;
    private PositionSequence peaks;
    private boolean fakePositions = false;
    private int fakePeakStartPosition = 15;
    private int fakePeakSpacing = 19;
    private Map<String, String> comments = Collections.emptyMap();
    private List<PhdWholeReadItem> wrs = Collections.emptyList();
    private List<PhdReadTag> readTags = Collections.emptyList();

    public PhdBuilder(String id, NucleotideSequence sequence, QualitySequence qualities) {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        if (sequence == null) {
            throw new NullPointerException("sequence can not be null");
        }
        if (qualities == null) {
            throw new NullPointerException("qualities can not be null");
        }
        if (sequence.getLength() != qualities.getLength()) {
            throw new IllegalArgumentException("sequence and qualities have unequal lengths " + sequence.getLength() + " vs " + qualities.getLength());
        }
        this.id = id;
        this.sequence = sequence;
        this.qualities = qualities;
    }

    public PhdBuilder(Chromatogram chromatogram) {
        if (chromatogram == null) {
            throw new NullPointerException("chromatogram can not be null");
        }
        this.id = chromatogram.getId();
        this.sequence = chromatogram.getNucleotideSequence();
        this.qualities = chromatogram.getQualitySequence();
        this.peaks = chromatogram.getPeakSequence();
    }

    public PhdBuilder(Phd phd) {
        if (phd == null) {
            throw new NullPointerException("phd to copy can not be null");
        }
        this.id = phd.getId();
        this.sequence = phd.getNucleotideSequence();
        this.qualities = phd.getQualitySequence();
        this.peaks = phd.getPeakSequence();
        this.comments = new LinkedHashMap<String, String>(phd.getComments());
        this.wrs = new ArrayList<PhdWholeReadItem>(phd.getWholeReadItems());
        this.readTags = new ArrayList<PhdReadTag>(phd.getReadTags());
    }

    private PhdBuilder(PhdBuilder copy) {
        this.id = copy.id;
        this.sequence = copy.sequence;
        this.qualities = copy.qualities;
        this.peaks = copy.peaks;
        this.comments = new LinkedHashMap<String, String>(copy.comments);
        this.wrs = new ArrayList<PhdWholeReadItem>(copy.wrs);
        this.readTags = new ArrayList<PhdReadTag>(copy.readTags);
        this.fakePeakSpacing = copy.fakePeakSpacing;
        this.fakePeakStartPosition = copy.fakePeakStartPosition;
        this.fakePositions = copy.fakePositions;
    }

    public PhdBuilder copy() {
        return new PhdBuilder(this);
    }

    public PhdBuilder peaks(PositionSequence peaks) {
        if (peaks != null && peaks.getLength() != this.qualities.getLength()) {
            throw new IllegalArgumentException("peaks and qualities have unequal lengths");
        }
        this.peaks = peaks;
        this.fakePositions = false;
        return this;
    }

    public PhdBuilder fakePeaks() {
        return this.fakePeaks(15, 19);
    }

    public PhdBuilder fakePeaks(int firstPeakPosition, int spacing) {
        if (firstPeakPosition < 1) {
            throw new IllegalArgumentException("first peak position must be >0");
        }
        if (spacing < 1) {
            throw new IllegalArgumentException("peak spacing must be >0");
        }
        this.fakePositions = true;
        this.fakePeakSpacing = spacing;
        this.fakePeakStartPosition = firstPeakPosition;
        this.peaks = null;
        return this;
    }

    public PhdBuilder comments(Map<String, String> comments) {
        this.comments = new LinkedHashMap<String, String>(comments);
        return this;
    }

    public PhdBuilder readTags(List<PhdReadTag> readTags) {
        this.readTags = new ArrayList<PhdReadTag>(readTags);
        return this;
    }

    public PhdBuilder wholeReadItems(List<PhdWholeReadItem> wholeReadItems) {
        this.wrs = new ArrayList<PhdWholeReadItem>(wholeReadItems);
        return this;
    }

    @Override
    public Phd build() {
        if (this.fakePositions) {
            return new ArtificialPhd(this.id, this.sequence, this.qualities, this.comments, this.wrs, this.readTags, this.fakePeakStartPosition, this.fakePeakSpacing);
        }
        return new DefaultPhd(this.id, this.sequence, this.qualities, this.peaks, this.comments, this.wrs, this.readTags);
    }
}

