/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.phd;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdReadTag;
import org.jcvi.jillion.assembly.consed.phd.PhdUtil;
import org.jcvi.jillion.assembly.consed.phd.PhdWholeReadItem;
import org.jcvi.jillion.assembly.consed.phd.PhdWriter;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.JoinedStringBuilder;

public class PhdBallWriter
implements PhdWriter {
    private static final int INITIAL_SIZE_READ_TAG_BUFFER = 500;
    private static final String BEGIN_SEQUENCE = "BEGIN_SEQUENCE";
    private static final String BEGIN_COMMENT = "BEGIN_COMMENT";
    private static final String END_SEQUENCE = "END_SEQUENCE";
    private static final String END_COMMENT = "END_COMMENT";
    private static final String BEGIN_DNA = "BEGIN_DNA";
    private static final String END_DNA = "END_DNA";
    private static final String BEGIN_TAG = "BEGIN_TAG\n";
    private static final String END_TAG = "END_TAG\n";
    private static final String NEW_LINE = String.format("%n", new Object[0]);
    private static final int INITIAL_PHD_BUFFER_SIZE = 1024;
    private final Writer writer;

    public PhdBallWriter(OutputStream out) throws IOException {
        this(out, null);
    }

    public PhdBallWriter(OutputStream out, String fileComment) throws IOException {
        if (out == null) {
            throw new NullPointerException("output stream can not be null");
        }
        this.assertCommentIsOnlyOneLine(fileComment);
        this.writer = new BufferedWriter(new OutputStreamWriter(out, IOUtil.UTF_8));
        if (fileComment != null) {
            this.writer.write(String.format("#%s%n", fileComment));
        }
    }

    public PhdBallWriter(File outputFile, String fileComment) throws IOException {
        if (outputFile == null) {
            throw new NullPointerException("output file can not be null");
        }
        this.assertCommentIsOnlyOneLine(fileComment);
        IOUtil.mkdirs(outputFile.getParentFile());
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), IOUtil.UTF_8));
        if (fileComment != null) {
            this.writer.write(String.format("#%s%n", fileComment));
        }
    }

    private void assertCommentIsOnlyOneLine(String fileComment) {
        if (fileComment != null) {
            try (Scanner scanner = new Scanner(fileComment);){
                scanner.nextLine();
                if (scanner.hasNext()) {
                    throw new IllegalArgumentException("fileComment can not be multi-line");
                }
            }
        }
    }

    public PhdBallWriter(File outputFile) throws IOException {
        this(outputFile, null);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void write(Phd phd) throws IOException {
        this.write(phd, null);
    }

    @Override
    public void write(Phd phd, Integer version) throws IOException {
        if (phd == null) {
            throw new NullPointerException("phd can not be null");
        }
        if (version != null && version < 1) {
            throw new IllegalArgumentException("version must be >=1");
        }
        this.writePhd(phd, version);
    }

    private void writePhd(Phd phd, Integer version) throws IOException {
        try {
            StringBuilder phdRecord = new StringBuilder(1024);
            if (version == null) {
                phdRecord.append(String.format("%s %s%n%n", BEGIN_SEQUENCE, phd.getId()));
            } else {
                phdRecord.append(String.format("%s %s %d%n%n", BEGIN_SEQUENCE, phd.getId(), version));
            }
            phdRecord.append((CharSequence)this.createComments(phd)).append((CharSequence)this.writeDnaSection(phd)).append(NEW_LINE);
            List<PhdReadTag> tags = phd.getReadTags();
            if (!tags.isEmpty()) {
                phdRecord.append(this.writeReadTags(tags));
            }
            phdRecord.append(String.format("%s%n", END_SEQUENCE)).append((CharSequence)this.createWholeReadItems(phd));
            this.writer.write(phdRecord.toString());
        }
        catch (Throwable t) {
            throw new IOException("error writing phd record for " + phd.getId(), t);
        }
    }

    private String writeReadTags(List<PhdReadTag> tags) {
        ArrayList<String> printedTags = new ArrayList<String>(tags.size());
        for (PhdReadTag tag : tags) {
            Range range = tag.getUngappedRange();
            StringBuilder builder = new StringBuilder(500).append(BEGIN_TAG).append(String.format("TYPE: %s%n", tag.getType())).append(String.format("SOURCE: %s%n", tag.getSource())).append(String.format("UNPADDED_READ_POS: %d %d%n", range.getBegin(Range.CoordinateSystem.RESIDUE_BASED), range.getEnd(Range.CoordinateSystem.RESIDUE_BASED))).append(String.format("DATE: %s%n", PhdUtil.formatReadTagDate(tag.getDate())));
            if (tag.getComment() != null) {
                builder.append(BEGIN_COMMENT).append(NEW_LINE).append(tag.getComment()).append(NEW_LINE).append(END_COMMENT).append(NEW_LINE);
            }
            if (tag.getFreeFormData() != null) {
                builder.append(tag.getFreeFormData()).append(NEW_LINE);
            }
            printedTags.add(builder.append(END_TAG).toString());
        }
        return JoinedStringBuilder.create(printedTags).glue(NEW_LINE).build();
    }

    private StringBuilder createWholeReadItems(Phd phd) {
        StringBuilder tags = new StringBuilder();
        for (PhdWholeReadItem tag : phd.getWholeReadItems()) {
            String lines = JoinedStringBuilder.create(tag.getLines()).glue(NEW_LINE).build();
            tags.append(String.format("WR{%n%s%n}%n", lines));
        }
        return tags;
    }

    private StringBuilder writeDnaSection(Phd phd) {
        StringBuilder dna = new StringBuilder(1024);
        dna.append(String.format("%s%n", BEGIN_DNA)).append((CharSequence)this.writeCalledInfo(phd)).append(String.format("%s%n", END_DNA));
        return dna;
    }

    private StringBuilder writeCalledInfo(Phd phd) {
        NucleotideSequence nucleotideSequence = phd.getNucleotideSequence();
        int seqLength = (int)nucleotideSequence.getLength();
        Iterator basesIter = nucleotideSequence.iterator();
        Iterator qualIter = phd.getQualitySequence().iterator();
        PositionSequence peaks = phd.getPeakSequence();
        StringBuilder result = new StringBuilder(seqLength * 10);
        if (peaks == null) {
            while (basesIter.hasNext()) {
                result.append(String.format("%s %d%n", basesIter.next(), ((PhredQuality)qualIter.next()).getQualityScore()));
            }
        } else {
            short[] positions = phd.getPeakSequence().toArray();
            int i = 0;
            while (basesIter.hasNext()) {
                result.append(String.format("%s %d %d%n", basesIter.next(), ((PhredQuality)qualIter.next()).getQualityScore(), IOUtil.toUnsignedShort(positions[i])));
                ++i;
            }
        }
        return result;
    }

    private StringBuilder createComments(Phd phd) {
        StringBuilder comments = new StringBuilder(500).append(BEGIN_COMMENT).append(NEW_LINE);
        for (Map.Entry<String, String> entry : phd.getComments().entrySet()) {
            comments.append(String.format("%s: %s%n", entry.getKey(), entry.getValue()));
        }
        comments.append(END_COMMENT).append(NEW_LINE);
        return comments;
    }
}

