/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.phd;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jcvi.jillion.assembly.consed.phd.AbstractPhdBallVisitor;
import org.jcvi.jillion.assembly.consed.phd.AbstractPhdVisitor;
import org.jcvi.jillion.assembly.consed.phd.DefaultPhd;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdBallFileParser;
import org.jcvi.jillion.assembly.consed.phd.PhdBallVisitorCallback;
import org.jcvi.jillion.assembly.consed.phd.PhdReadTag;
import org.jcvi.jillion.assembly.consed.phd.PhdVisitor;
import org.jcvi.jillion.assembly.consed.phd.PhdWholeReadItem;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.internal.core.util.iter.AbstractBlockingStreamingIterator;

final class PhdBallIterator
extends AbstractBlockingStreamingIterator<Phd> {
    private final File phdFile;
    private final DataStoreFilter filter;

    public static PhdBallIterator createNewIterator(File phdFile, DataStoreFilter filter) {
        PhdBallIterator iter = new PhdBallIterator(phdFile, filter);
        iter.start();
        return iter;
    }

    private PhdBallIterator(File phdFile, DataStoreFilter filter) {
        this.phdFile = phdFile;
        this.filter = filter;
    }

    @Override
    protected void backgroundThreadRunMethod() {
        AbstractPhdBallVisitor visitor = new AbstractPhdBallVisitor(){

            @Override
            public PhdVisitor visitPhd(PhdBallVisitorCallback callback, String id, Integer version) {
                if (!PhdBallIterator.this.filter.accept(id)) {
                    return null;
                }
                return new AbstractPhdVisitor(id, version){

                    @Override
                    protected void visitPhd(String id, Integer version, NucleotideSequence basecalls, QualitySequence qualities, PositionSequence positions, Map<String, String> comments, List<PhdWholeReadItem> wholeReadItems, List<PhdReadTag> readTags) {
                        DefaultPhd phd = new DefaultPhd(id, basecalls, qualities, positions, comments, wholeReadItems, readTags);
                        PhdBallIterator.this.blockingPut(phd);
                    }
                };
            }
        };
        try {
            PhdBallFileParser.create(this.phdFile).accept(visitor);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("error parsing phd file: %s", this.phdFile.getAbsolutePath()), e);
        }
    }
}

