/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.phd;

import java.io.File;
import java.io.IOException;
import org.jcvi.jillion.assembly.consed.phd.AbstractPhdBallVisitor;
import org.jcvi.jillion.assembly.consed.phd.PhdBallFileParser;
import org.jcvi.jillion.assembly.consed.phd.PhdBallVisitorCallback;
import org.jcvi.jillion.assembly.consed.phd.PhdVisitor;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.internal.core.util.iter.AbstractBlockingStreamingIterator;

final class PhdBallIdIterator
extends AbstractBlockingStreamingIterator<String> {
    private final File phdFile;
    private final DataStoreFilter filter;

    public static PhdBallIdIterator createNewIterator(File phdFile, DataStoreFilter filter) {
        PhdBallIdIterator iter = new PhdBallIdIterator(phdFile, filter);
        iter.start();
        return iter;
    }

    private PhdBallIdIterator(File phdFile, DataStoreFilter filter) {
        this.phdFile = phdFile;
        this.filter = filter;
    }

    @Override
    protected void backgroundThreadRunMethod() {
        AbstractPhdBallVisitor visitor = new AbstractPhdBallVisitor(){

            @Override
            public PhdVisitor visitPhd(PhdBallVisitorCallback callback, String id, Integer version) {
                if (PhdBallIdIterator.this.filter.accept(id)) {
                    PhdBallIdIterator.this.blockingPut(id);
                }
                return null;
            }
        };
        try {
            PhdBallFileParser.create(this.phdFile).accept(visitor);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("error parsing phd file: %s", this.phdFile.getAbsolutePath()), e);
        }
    }
}

