/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.phd;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.assembly.consed.phd.PhdBallParser;
import org.jcvi.jillion.assembly.consed.phd.PhdBallVisitor;
import org.jcvi.jillion.assembly.consed.phd.PhdBallVisitorCallback;
import org.jcvi.jillion.assembly.consed.phd.PhdReadTagVisitor;
import org.jcvi.jillion.assembly.consed.phd.PhdUtil;
import org.jcvi.jillion.assembly.consed.phd.PhdVisitor;
import org.jcvi.jillion.assembly.consed.phd.PhdWholeReadItemVisitor;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.internal.core.io.LineParser;
import org.jcvi.jillion.internal.core.io.OpenAwareInputStream;
import org.jcvi.jillion.internal.core.io.RandomAccessFileInputStream;
import org.jcvi.jillion.internal.core.io.TextLineParser;

public abstract class PhdBallFileParser
implements PhdBallParser {
    private static final String BEGIN_COMMENT = "BEGIN_COMMENT";
    private static final String END_SEQUENCE = "END_SEQUENCE";
    private static final String END_COMMENT = "END_COMMENT";
    private static final String BEGIN_DNA = "BEGIN_DNA";
    private static final String END_DNA = "END_DNA";
    private static final String BEGIN_TAG = "BEGIN_TAG";
    private static final String END_TAG = "END_TAG";
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("^\\s*(\\w+)\\s*[:]\\s+(.+)\\s*$");
    private static final Pattern CALLED_INFO_PATTERN = Pattern.compile("^\\s*(\\w)\\s+(\\d+)\\s*(\\d+)?\\s*?");
    private static final Pattern BEGIN_SEQUENCE_PATTERN = Pattern.compile("BEGIN_SEQUENCE\\s+(\\S+)\\s*(\\d+)?\\s*$");
    private static final String BEGIN_WR = "WR{";
    private static final String END_WR = "}";
    private static final Pattern FILE_COMMENT_PATTERN = Pattern.compile("^#(.*)\\s*$");
    private static final Pattern RIGHT_TRIM_PATTERN = Pattern.compile("(.*)\\s+$");

    public static PhdBallParser create(File phdBall) throws FileNotFoundException {
        return new FileBasedPhdBallParser(phdBall);
    }

    public static PhdBallParser create(InputStream phdBallStream) {
        return new InputStreamBasedPhdBallParser(phdBallStream);
    }

    private PhdBallFileParser() {
    }

    void accept(TextLineParser parser, PhdBallVisitor visitor) throws IOException {
        ParserState parserState = new ParserState();
        boolean seenFileComment = false;
        PhdVisitor phdVisitor = null;
        while (parser.hasNextLine() && parserState.keepParsing()) {
            Matcher fileCommentMatcher;
            long currentOffset = parser.getPosition();
            String line = parser.nextLine();
            Matcher beginSequenceMatcher = BEGIN_SEQUENCE_PATTERN.matcher(line);
            if (beginSequenceMatcher.matches()) {
                if (phdVisitor != null) {
                    phdVisitor.visitEnd();
                }
                if (!parserState.keepParsing()) {
                    phdVisitor = null;
                    break;
                }
                phdVisitor = this.visitNewRecordHeader(visitor, parserState, currentOffset, beginSequenceMatcher);
                if (phdVisitor == null) {
                    this.skipSequence(parser);
                    continue;
                }
                this.handleSequence(parserState, parser, phdVisitor);
                continue;
            }
            if (seenFileComment || !(fileCommentMatcher = FILE_COMMENT_PATTERN.matcher(line)).matches()) continue;
            seenFileComment = true;
            visitor.visitFileComment(fileCommentMatcher.group(1));
        }
        if (parserState.keepParsing()) {
            if (phdVisitor != null) {
                phdVisitor.visitEnd();
            }
            visitor.visitEnd();
        } else {
            if (phdVisitor != null) {
                phdVisitor.halted();
            }
            visitor.halted();
        }
    }

    private PhdVisitor visitNewRecordHeader(PhdBallVisitor visitor, ParserState parserState, long currentOffset, Matcher beginSequenceMatcher) {
        String readId = beginSequenceMatcher.group(1);
        String optionalVersion = beginSequenceMatcher.group(2);
        PhdBallVisitorCallback callback = this.createCallback(parserState, currentOffset);
        if (optionalVersion == null) {
            return visitor.visitPhd(callback, readId, null);
        }
        return visitor.visitPhd(callback, readId, Integer.parseInt(optionalVersion));
    }

    private void skipSequence(LineParser parser) throws IOException {
        boolean entireSequenceBlockRead = false;
        while (entireSequenceBlockRead && parser.hasNextLine()) {
            String line = parser.nextLine();
            entireSequenceBlockRead = line.startsWith(END_SEQUENCE);
        }
    }

    protected abstract PhdBallVisitorCallback createCallback(ParserState var1, long var2);

    private void handleWholeReadTag(ParserState parserState, LineParser parser, PhdVisitor visitor) throws IOException {
        PhdWholeReadItemVisitor itemVisitor = visitor == null ? null : visitor.visitWholeReadItem();
        while (parser.hasNextLine() && parserState.keepParsing()) {
            String line = parser.nextLine();
            if (line.startsWith(END_WR)) {
                if (itemVisitor == null) break;
                itemVisitor.visitEnd();
                break;
            }
            if (itemVisitor == null) continue;
            itemVisitor.visitLine(this.rightTrim(line));
        }
        if (itemVisitor != null && !parserState.keepParsing()) {
            visitor.halted();
        }
    }

    private String rightTrim(String line) {
        Matcher matcher = RIGHT_TRIM_PATTERN.matcher(line);
        matcher.find();
        return matcher.group(1);
    }

    private void handleSequence(ParserState parserState, LineParser parser, PhdVisitor visitor) throws IOException {
        this.parseCommentBlock(parser, visitor);
        if (!parserState.keepParsing()) {
            visitor.halted();
            return;
        }
        this.parseReadData(parserState, parser, visitor);
        if (!parserState.keepParsing()) {
            visitor.halted();
            return;
        }
        this.parseTags(parserState, parser, visitor);
        if (!parserState.keepParsing()) {
            visitor.halted();
            return;
        }
    }

    private void parseTags(ParserState parserState, LineParser parser, PhdVisitor visitor) throws IOException {
        while (parser.hasNextLine() && parserState.keepParsing()) {
            String peekedLine = parser.peekLine();
            Matcher beginSequenceMatcher = BEGIN_SEQUENCE_PATTERN.matcher(peekedLine);
            if (beginSequenceMatcher.matches()) {
                return;
            }
            String line = parser.nextLine();
            if (line.startsWith(BEGIN_TAG)) {
                this.parseSingleTag(parserState, parser, visitor.visitReadTag());
                continue;
            }
            if (!line.startsWith(BEGIN_WR)) continue;
            this.handleWholeReadTag(parserState, parser, visitor);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseSingleTag(ParserState parserState, LineParser parser, PhdReadTagVisitor visitor) throws IOException {
        boolean inTag = true;
        do {
            String line;
            if ((line = parser.nextLine()).startsWith(END_TAG)) {
                inTag = false;
                continue;
            }
            Matcher keyValueMatcher = KEY_VALUE_PATTERN.matcher(line);
            if (keyValueMatcher.find()) {
                String key = keyValueMatcher.group(1);
                String value = keyValueMatcher.group(2);
                if ("TYPE".equals(key)) {
                    visitor.visitType(value);
                    continue;
                }
                if ("SOURCE".equals(key)) {
                    visitor.visitSource(value);
                    continue;
                }
                if ("UNPADDED_READ_POS".equals(key)) {
                    StringTokenizer tokenizer = new StringTokenizer(value);
                    visitor.visitUngappedRange(Range.of(Range.CoordinateSystem.RESIDUE_BASED, Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken())));
                    continue;
                }
                if ("DATE".equals(key)) {
                    try {
                        visitor.visitDate(PhdUtil.parseReadTagDate(value));
                    }
                    catch (ParseException e) {
                        throw new IOException("error parsing read tag date: " + value, e);
                    }
                } else {
                    visitor.visitFreeFormData(line);
                    continue;
                }
            }
            if (line.startsWith(BEGIN_COMMENT)) {
                visitor.visitComment(this.parseReadTagComment(parser));
                continue;
            }
            visitor.visitFreeFormData(line);
        } while (inTag && parser.hasNextLine() && parserState.keepParsing());
        if (parserState.keepParsing()) {
            visitor.visitEnd();
            return;
        }
        visitor.halted();
    }

    private String parseReadTagComment(LineParser parser) throws IOException {
        boolean inCommentBlock = true;
        StringBuilder comment = new StringBuilder();
        do {
            String line;
            if ((line = parser.nextLine()).startsWith(END_COMMENT)) {
                inCommentBlock = false;
                continue;
            }
            comment.append(line);
        } while (inCommentBlock && parser.hasNextLine());
        return this.rightTrim(comment.toString());
    }

    private void parseReadData(ParserState parserState, LineParser parser, PhdVisitor visitor) throws IOException {
        String line;
        boolean inDnaBlock = false;
        while (!inDnaBlock && parser.hasNextLine()) {
            line = parser.nextLine();
            inDnaBlock = line.startsWith(BEGIN_DNA);
        }
        do {
            Matcher matcher;
            if ((matcher = CALLED_INFO_PATTERN.matcher(line = parser.nextLine())).matches()) {
                Nucleotide base = Nucleotide.parse(matcher.group(1).charAt(0));
                PhredQuality qual = PhredQuality.valueOf(Integer.parseInt(matcher.group(2)));
                if (matcher.group(3) == null) {
                    visitor.visitBasecall(base, qual, null);
                    continue;
                }
                visitor.visitBasecall(base, qual, Integer.parseInt(matcher.group(3)));
                continue;
            }
            boolean bl = inDnaBlock = !line.startsWith(END_DNA);
        } while (inDnaBlock && parser.hasNextLine() && parserState.keepParsing());
    }

    private void parseCommentBlock(LineParser parser, PhdVisitor visitor) throws IOException {
        boolean inCommentBlock = false;
        while (!inCommentBlock && parser.hasNextLine()) {
            String line = parser.nextLine();
            inCommentBlock = line.startsWith(BEGIN_COMMENT);
        }
        Map<String, String> comments = this.parseComments(parser);
        visitor.visitComments(comments);
    }

    private Map<String, String> parseComments(LineParser parser) throws IOException {
        boolean inCommentBlock = true;
        LinkedHashMap<String, String> comments = new LinkedHashMap<String, String>();
        do {
            String line;
            if ((line = parser.nextLine()).startsWith(END_COMMENT)) {
                inCommentBlock = false;
                continue;
            }
            Matcher commentMatcher = KEY_VALUE_PATTERN.matcher(line);
            if (!commentMatcher.find()) continue;
            comments.put(commentMatcher.group(1), commentMatcher.group(2));
        } while (inCommentBlock && parser.hasNextLine());
        return comments;
    }

    private static final class InputStreamBasedPhdBallParser
    extends PhdBallFileParser {
        private final OpenAwareInputStream in;
        private boolean hasParsedBefore = false;

        public InputStreamBasedPhdBallParser(InputStream in) {
            if (in == null) {
                throw new NullPointerException("input stream can not be null");
            }
            this.in = new OpenAwareInputStream(new BufferedInputStream(in));
        }

        @Override
        public void accept(PhdBallVisitor visitor) throws IOException {
            if (visitor == null) {
                throw new NullPointerException("visitor can not be null");
            }
            if (this.hasParsedBefore && !this.canParse()) {
                throw new IllegalStateException("can not accept - inputstream has been closed");
            }
            this.hasParsedBefore = true;
            TextLineParser parser = null;
            try {
                parser = new TextLineParser(this.in);
                this.accept(parser, visitor);
            }
            catch (Throwable throwable) {
                IOUtil.closeAndIgnoreErrors(parser);
                throw throwable;
            }
            IOUtil.closeAndIgnoreErrors((Closeable)parser);
        }

        @Override
        public boolean canParse() {
            return this.in.isOpen();
        }

        @Override
        public void accept(PhdBallVisitor visitor, PhdBallVisitorCallback.PhdBallVisitorMemento memento) throws IOException {
            throw new UnsupportedOperationException("mementos not supported");
        }

        @Override
        protected PhdBallVisitorCallback createCallback(ParserState parserState, long offset) {
            return new NoMementoPhdBallVisitorCallbackImpl(parserState);
        }
    }

    private static final class FileBasedPhdBallParser
    extends PhdBallFileParser {
        private final File phdBall;

        private FileBasedPhdBallParser(File phdBall) throws FileNotFoundException {
            if (phdBall == null) {
                throw new NullPointerException("phdball can not be null");
            }
            if (!phdBall.exists()) {
                throw new FileNotFoundException("phdball must exist");
            }
            this.phdBall = phdBall;
        }

        @Override
        public void accept(PhdBallVisitor visitor) throws IOException {
            if (visitor == null) {
                throw new NullPointerException("visitor can not be null");
            }
            TextLineParser parser = null;
            try {
                parser = new TextLineParser(new BufferedInputStream(new FileInputStream(this.phdBall)));
                this.accept(parser, visitor);
            }
            catch (Throwable throwable) {
                IOUtil.closeAndIgnoreErrors(parser);
                throw throwable;
            }
            IOUtil.closeAndIgnoreErrors((Closeable)parser);
        }

        @Override
        public boolean canParse() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(PhdBallVisitor visitor, PhdBallVisitorCallback.PhdBallVisitorMemento memento) throws IOException {
            if (visitor == null) {
                throw new NullPointerException("visitor can not be null");
            }
            if (memento == null) {
                throw new NullPointerException("memento can not be null");
            }
            if (!(memento instanceof PhdBallVisitorMementoImpl)) {
                throw new IllegalArgumentException("unknown memento type " + memento);
            }
            long offset = ((PhdBallVisitorMementoImpl)memento).getOffset();
            TextLineParser parser = null;
            try {
                RandomAccessFileInputStream in = new RandomAccessFileInputStream(this.phdBall, offset);
                parser = new TextLineParser(in, offset);
                this.accept(parser, visitor);
            }
            catch (Throwable throwable) {
                IOUtil.closeAndIgnoreErrors(parser);
                throw throwable;
            }
            IOUtil.closeAndIgnoreErrors((Closeable)parser);
        }

        @Override
        protected PhdBallVisitorCallback createCallback(ParserState parserState, long offset) {
            return new MementoedPhdBallVisitorCallbackImpl(offset, parserState);
        }
    }

    private static class PhdBallVisitorMementoImpl
    implements PhdBallVisitorCallback.PhdBallVisitorMemento {
        private final long offset;

        public PhdBallVisitorMementoImpl(long offset) {
            this.offset = offset;
        }

        public final long getOffset() {
            return this.offset;
        }
    }

    private static class NoMementoPhdBallVisitorCallbackImpl
    implements PhdBallVisitorCallback {
        private final ParserState parserState;

        public NoMementoPhdBallVisitorCallbackImpl(ParserState parserState) {
            this.parserState = parserState;
        }

        @Override
        public boolean canCreateMemento() {
            return false;
        }

        @Override
        public PhdBallVisitorCallback.PhdBallVisitorMemento createMemento() {
            throw new UnsupportedOperationException("can not create mementos from inputstream");
        }

        @Override
        public void haltParsing() {
            this.parserState.haltParsing();
        }
    }

    private static class MementoedPhdBallVisitorCallbackImpl
    implements PhdBallVisitorCallback {
        private final long byteOffset;
        private final ParserState parserState;

        public MementoedPhdBallVisitorCallbackImpl(long byteOffset, ParserState parserState) {
            this.byteOffset = byteOffset;
            this.parserState = parserState;
        }

        @Override
        public boolean canCreateMemento() {
            return true;
        }

        @Override
        public PhdBallVisitorCallback.PhdBallVisitorMemento createMemento() {
            return new PhdBallVisitorMementoImpl(this.byteOffset);
        }

        @Override
        public void haltParsing() {
            this.parserState.haltParsing();
        }
    }

    private static class ParserState {
        private final AtomicBoolean keepParsing = new AtomicBoolean(true);

        public boolean keepParsing() {
            return this.keepParsing.get();
        }

        public void haltParsing() {
            this.keepParsing.set(false);
        }
    }
}

