/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.phd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdBallIdIterator;
import org.jcvi.jillion.assembly.consed.phd.PhdBallIterator;
import org.jcvi.jillion.assembly.consed.phd.PhdDataStore;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;

final class LargePhdballDataStore
implements PhdDataStore {
    private volatile boolean closed = false;
    private final File phdFile;
    private final DataStoreFilter filter;
    private Long numberOfRecords = null;

    public LargePhdballDataStore(File phdFile, DataStoreFilter filter) throws FileNotFoundException {
        if (!phdFile.exists()) {
            throw new FileNotFoundException(phdFile.getAbsolutePath());
        }
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        this.phdFile = phdFile;
        this.filter = filter;
    }

    @Override
    public StreamingIterator<String> idIterator() throws DataStoreException {
        this.verifyNotClosed();
        return DataStoreStreamingIterator.create(this, PhdBallIdIterator.createNewIterator(this.phdFile, this.filter));
    }

    @Override
    public StreamingIterator<DataStoreEntry<Phd>> entryIterator() throws DataStoreException {
        return new StreamingIterator<DataStoreEntry<Phd>>(){
            StreamingIterator<Phd> iter;
            {
                this.iter = LargePhdballDataStore.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public void close() {
                this.iter.close();
            }

            @Override
            public DataStoreEntry<Phd> next() {
                Phd next = this.iter.next();
                return new DataStoreEntry<Phd>(next.getId(), next);
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Phd get(String id) throws DataStoreException {
        this.verifyNotClosed();
        if (!this.filter.accept(id)) {
            return null;
        }
        StreamingIterator<Phd> iter = null;
        try {
            iter = this.iterator();
            while (iter.hasNext()) {
                Phd phd = iter.next();
                if (!phd.getId().equals(id)) continue;
                Phd phd2 = phd;
                return phd2;
            }
        }
        finally {
            IOUtil.closeAndIgnoreErrors(iter);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(String id) throws DataStoreException {
        this.verifyNotClosed();
        if (!this.filter.accept(id)) {
            return false;
        }
        StreamingIterator<String> idIter = null;
        try {
            idIter = this.idIterator();
            while (idIter.hasNext()) {
                if (!idIter.next().equals(id)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            IOUtil.closeAndIgnoreErrors(idIter);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long getNumberOfRecords() throws DataStoreException {
        this.verifyNotClosed();
        if (this.numberOfRecords == null) {
            StreamingIterator<String> idIter = null;
            long count = 0L;
            try {
                idIter = this.idIterator();
                while (idIter.hasNext()) {
                    idIter.next();
                    ++count;
                }
                this.numberOfRecords = count;
            }
            finally {
                IOUtil.closeAndIgnoreErrors(idIter);
            }
        }
        return this.numberOfRecords;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public StreamingIterator<Phd> iterator() throws DataStoreException {
        this.verifyNotClosed();
        return DataStoreStreamingIterator.create(this, PhdBallIterator.createNewIterator(this.phdFile, this.filter));
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    private void verifyNotClosed() {
        if (this.closed) {
            throw new DataStoreClosedException("data store is closed");
        }
    }
}

