/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.phd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jcvi.jillion.assembly.consed.phd.AbstractPhdBallVisitor;
import org.jcvi.jillion.assembly.consed.phd.AbstractPhdVisitor;
import org.jcvi.jillion.assembly.consed.phd.DefaultPhd;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdBallFileParser;
import org.jcvi.jillion.assembly.consed.phd.PhdBallIterator;
import org.jcvi.jillion.assembly.consed.phd.PhdBallParser;
import org.jcvi.jillion.assembly.consed.phd.PhdBallVisitor;
import org.jcvi.jillion.assembly.consed.phd.PhdBallVisitorCallback;
import org.jcvi.jillion.assembly.consed.phd.PhdDataStore;
import org.jcvi.jillion.assembly.consed.phd.PhdReadTag;
import org.jcvi.jillion.assembly.consed.phd.PhdVisitor;
import org.jcvi.jillion.assembly.consed.phd.PhdWholeReadItem;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.MapUtil;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;

final class IndexedPhdDataStore
implements PhdDataStore {
    private volatile boolean closed = false;
    private final File phdFile;
    private final Map<String, PhdBallVisitorCallback.PhdBallVisitorMemento> mementos;
    private final DataStoreFilter filter;
    private final PhdBallParser parser;

    public static PhdDataStore create(File phdBall, DataStoreFilter filter) throws FileNotFoundException, IOException {
        PhdBallParser parser = PhdBallFileParser.create(phdBall);
        BuilderVisitor visitor = new BuilderVisitor(parser, phdBall, filter);
        parser.accept(visitor);
        return visitor.build();
    }

    private IndexedPhdDataStore(PhdBallParser parser, File phdFile, Map<String, PhdBallVisitorCallback.PhdBallVisitorMemento> mementos, DataStoreFilter filter) {
        this.parser = parser;
        this.phdFile = phdFile;
        this.mementos = mementos;
        this.filter = filter;
    }

    private void verifyNotClosed() {
        if (this.closed) {
            throw new DataStoreClosedException("already closed");
        }
    }

    @Override
    public StreamingIterator<String> idIterator() throws DataStoreException {
        return IteratorUtil.createStreamingIterator(this.mementos.keySet().iterator());
    }

    @Override
    public Phd get(String id) throws DataStoreException {
        this.verifyNotClosed();
        PhdBallVisitorCallback.PhdBallVisitorMemento memento = this.mementos.get(id);
        if (memento == null) {
            return null;
        }
        SinglePhdVisitor visitor = new SinglePhdVisitor(id);
        try {
            this.parser.accept(visitor, memento);
            return visitor.phd;
        }
        catch (IOException e) {
            throw new DataStoreException("error re-parsing phd file for " + id, e);
        }
    }

    @Override
    public boolean contains(String id) throws DataStoreException {
        this.verifyNotClosed();
        return this.mementos.containsKey(id);
    }

    @Override
    public long getNumberOfRecords() throws DataStoreException {
        this.verifyNotClosed();
        return this.mementos.size();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public StreamingIterator<Phd> iterator() throws DataStoreException {
        return DataStoreStreamingIterator.create(this, PhdBallIterator.createNewIterator(this.phdFile, this.filter));
    }

    @Override
    public StreamingIterator<DataStoreEntry<Phd>> entryIterator() throws DataStoreException {
        return new StreamingIterator<DataStoreEntry<Phd>>(){
            StreamingIterator<Phd> iter;
            {
                this.iter = IndexedPhdDataStore.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public void close() {
                this.iter.close();
            }

            @Override
            public DataStoreEntry<Phd> next() {
                Phd next = this.iter.next();
                return new DataStoreEntry<Phd>(next.getId(), next);
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    public static class SinglePhdVisitor
    extends AbstractPhdBallVisitor {
        private Phd phd;
        private final String idWeWant;

        public SinglePhdVisitor(String idWeWant) {
            this.idWeWant = idWeWant;
        }

        @Override
        public PhdVisitor visitPhd(final PhdBallVisitorCallback callback, String id, Integer version) {
            if (this.phd != null) {
                throw new IllegalStateException("should only see one phd");
            }
            if (!this.idWeWant.equals(id)) {
                throw new IllegalStateException("did not visit correct id: expected " + this.idWeWant + " but was " + id);
            }
            return new AbstractPhdVisitor(id, version){

                @Override
                protected void visitPhd(String id, Integer version, NucleotideSequence basecalls, QualitySequence qualities, PositionSequence positions, Map<String, String> comments, List<PhdWholeReadItem> wholeReadItems, List<PhdReadTag> readTags) {
                    phd = new DefaultPhd(id, basecalls, qualities, positions, comments, wholeReadItems, readTags);
                    callback.haltParsing();
                }
            };
        }
    }

    private static final class BuilderVisitor
    implements PhdBallVisitor {
        private static final int INITIAL_MAP_SIZE = MapUtil.computeMinHashMapSizeWithoutRehashing(8192L);
        private final Map<String, PhdBallVisitorCallback.PhdBallVisitorMemento> mementos = new LinkedHashMap<String, PhdBallVisitorCallback.PhdBallVisitorMemento>(INITIAL_MAP_SIZE);
        private final DataStoreFilter filter;
        private final File phdBall;
        private boolean visitedEntireFile = false;
        private final PhdBallParser parser;

        public BuilderVisitor(PhdBallParser parser, File phdBall, DataStoreFilter filter) {
            this.phdBall = phdBall;
            this.filter = filter;
            this.parser = parser;
        }

        @Override
        public void visitFileComment(String comment) {
        }

        @Override
        public PhdVisitor visitPhd(PhdBallVisitorCallback callback, String id, Integer version) {
            if (this.filter.accept(id)) {
                this.mementos.put(id, callback.createMemento());
            }
            return null;
        }

        @Override
        public void visitEnd() {
            this.visitedEntireFile = true;
        }

        @Override
        public void halted() {
        }

        public PhdDataStore build() {
            if (!this.visitedEntireFile) {
                throw new IllegalStateException("did not visit entire file");
            }
            return new IndexedPhdDataStore(this.parser, this.phdBall, this.mementos, this.filter);
        }
    }
}

