/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.phd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jcvi.jillion.assembly.consed.phd.AbstractPhdVisitor;
import org.jcvi.jillion.assembly.consed.phd.DefaultPhd;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdBallFileParser;
import org.jcvi.jillion.assembly.consed.phd.PhdBallParser;
import org.jcvi.jillion.assembly.consed.phd.PhdBallVisitor;
import org.jcvi.jillion.assembly.consed.phd.PhdBallVisitorCallback;
import org.jcvi.jillion.assembly.consed.phd.PhdDataStore;
import org.jcvi.jillion.assembly.consed.phd.PhdReadTag;
import org.jcvi.jillion.assembly.consed.phd.PhdVisitor;
import org.jcvi.jillion.assembly.consed.phd.PhdWholeReadItem;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.internal.core.datastore.AbstractMapBackedDataStore;

final class DefaultPhdDataStore {
    DefaultPhdDataStore() {
    }

    public static PhdDataStore create(File phdBall, DataStoreFilter filter) throws IOException {
        PhdBallParser parser = PhdBallFileParser.create(phdBall);
        DefaultPhdDataStoreBuilderVisitor visitor = new DefaultPhdDataStoreBuilderVisitor(filter);
        parser.accept(visitor);
        return visitor.build();
    }

    public static PhdDataStore create(InputStream inputStream, DataStoreFilter filter) throws IOException {
        PhdBallParser parser = PhdBallFileParser.create(inputStream);
        DefaultPhdDataStoreBuilderVisitor visitor = new DefaultPhdDataStoreBuilderVisitor(filter);
        parser.accept(visitor);
        return visitor.build();
    }

    private static final class Impl
    extends AbstractMapBackedDataStore<Phd>
    implements PhdDataStore {
        public Impl(Map<String, Phd> map) {
            super(map);
        }
    }

    public static class DefaultPhdDataStoreBuilderVisitor
    implements PhdBallVisitor {
        private final DataStoreFilter filter;
        private final Map<String, Phd> phds = new LinkedHashMap<String, Phd>();

        public DefaultPhdDataStoreBuilderVisitor(DataStoreFilter filter) {
            this.filter = filter;
        }

        @Override
        public void visitFileComment(String comment) {
        }

        @Override
        public PhdVisitor visitPhd(PhdBallVisitorCallback callback, String id, Integer version) {
            return this.handlePhd(id, version);
        }

        private PhdVisitor handlePhd(String id, Integer version) {
            if (!this.filter.accept(id)) {
                return null;
            }
            return new AbstractPhdVisitor(id, version){

                @Override
                protected void visitPhd(String id, Integer version, NucleotideSequence basescalls, QualitySequence qualities, PositionSequence positions, Map<String, String> comments, List<PhdWholeReadItem> wholeReadItems, List<PhdReadTag> readTags) {
                    phds.put(id, new DefaultPhd(id, basescalls, qualities, positions, comments, wholeReadItems, readTags));
                }
            };
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }

        public PhdDataStore build() {
            return new Impl(this.phds);
        }
    }
}

