/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.phd;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdReadTag;
import org.jcvi.jillion.assembly.consed.phd.PhdWholeReadItem;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;

final class DefaultPhd
implements Phd {
    private final String id;
    private final NucleotideSequence basecalls;
    private final QualitySequence qualities;
    private final PositionSequence peaks;
    private final Map<String, String> comments;
    private final List<PhdWholeReadItem> wrs;
    private final List<PhdReadTag> readTags;

    public DefaultPhd(String id, NucleotideSequence basecalls, QualitySequence qualities, PositionSequence peaks, Map<String, String> comments, List<PhdWholeReadItem> wholeReadItems, List<PhdReadTag> readTags) {
        this.id = id;
        this.basecalls = basecalls;
        this.qualities = qualities;
        this.peaks = peaks;
        this.comments = comments;
        this.wrs = wholeReadItems;
        this.readTags = readTags;
    }

    public DefaultPhd(String id, NucleotideSequence basecalls, QualitySequence qualities, PositionSequence peaks, Map<String, String> comments) {
        this(id, basecalls, qualities, peaks, comments, Collections.emptyList(), Collections.emptyList());
    }

    public DefaultPhd(String id, NucleotideSequence basecalls, QualitySequence qualities, PositionSequence peaks) {
        this(id, basecalls, qualities, peaks, Collections.emptyMap());
    }

    @Override
    public Map<String, String> getComments() {
        return this.comments;
    }

    @Override
    public PositionSequence getPeakSequence() {
        return this.peaks;
    }

    @Override
    public NucleotideSequence getNucleotideSequence() {
        return this.basecalls;
    }

    @Override
    public QualitySequence getQualitySequence() {
        return this.qualities;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.basecalls.hashCode();
        result = 31 * result + this.comments.hashCode();
        result = 31 * result + (this.peaks == null ? 0 : this.peaks.hashCode());
        result = 31 * result + this.qualities.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Phd)) {
            return false;
        }
        Phd other = (Phd)obj;
        if (!this.id.equals(other.getId())) {
            return false;
        }
        if (!this.basecalls.equals(other.getNucleotideSequence())) {
            return false;
        }
        if (!this.comments.equals(other.getComments())) {
            return false;
        }
        if (this.peaks == null ? other.getPeakSequence() != null : !this.peaks.equals(other.getPeakSequence())) {
            return false;
        }
        if (!this.qualities.equals(other.getQualitySequence())) {
            return false;
        }
        if (!this.wrs.equals(other.getWholeReadItems())) {
            return false;
        }
        return this.readTags.equals(other.getReadTags());
    }

    public String toString() {
        return "DefaultPhd [id=" + this.id + "]";
    }

    @Override
    public List<PhdWholeReadItem> getWholeReadItems() {
        return Collections.unmodifiableList(this.wrs);
    }

    @Override
    public List<PhdReadTag> getReadTags() {
        return Collections.unmodifiableList(this.readTags);
    }
}

