/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.phd;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdReadTag;
import org.jcvi.jillion.assembly.consed.phd.PhdWholeReadItem;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.pos.PositionSequenceBuilder;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;

final class ArtificialPhd
implements Phd {
    private static final int NEWBLER_454_START_POSITION = 15;
    private static final int NEWBLER_454_PEAK_SPACING = 19;
    private final NucleotideSequence basecalls;
    private final QualitySequence qualities;
    private final Map<String, String> comments;
    private final List<PhdWholeReadItem> wholeReadItems;
    private final List<PhdReadTag> readTags;
    private PositionSequence fakePositions = null;
    private final int numberOfPositionsForEachPeak;
    private final int numberOfBases;
    private final int positionOfFirstPeak;
    private final String id;

    public static ArtificialPhd createNewbler454Phd(String id, NucleotideSequence basecalls, QualitySequence qualities, Map<String, String> comments, List<PhdWholeReadItem> wholeReadItems) {
        return new ArtificialPhd(id, basecalls, qualities, comments, wholeReadItems, Collections.emptyList(), 15, 19);
    }

    public static ArtificialPhd createNewbler454Phd(String id, NucleotideSequence basecalls, QualitySequence qualities, Map<String, String> comments) {
        return ArtificialPhd.createNewbler454Phd(id, basecalls, qualities, comments, Collections.emptyList());
    }

    public static ArtificialPhd createNewbler454Phd(String id, NucleotideSequence basecalls, QualitySequence qualities) {
        return ArtificialPhd.createNewbler454Phd(id, basecalls, qualities, Collections.emptyMap(), Collections.emptyList());
    }

    public ArtificialPhd(String id, NucleotideSequence basecalls, QualitySequence qualities, int numberOfPositionsForEachPeak) {
        this(id, basecalls, qualities, Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), numberOfPositionsForEachPeak);
    }

    public ArtificialPhd(String id, NucleotideSequence basecalls, QualitySequence qualities, Map<String, String> comments, List<PhdWholeReadItem> wholeReadItems, List<PhdReadTag> readTags, int numberOfPositionsForEachPeak) {
        this(id, basecalls, qualities, comments, wholeReadItems, readTags, numberOfPositionsForEachPeak, numberOfPositionsForEachPeak);
    }

    public ArtificialPhd(String id, NucleotideSequence basecalls, QualitySequence qualities, Map<String, String> comments, List<PhdWholeReadItem> wholeReadItems, List<PhdReadTag> readTags, int positionOfFirstPeak, int numberOfPositionsForEachPeak) {
        this.id = id;
        this.basecalls = basecalls;
        this.qualities = qualities;
        this.wholeReadItems = wholeReadItems;
        this.comments = comments;
        this.numberOfBases = (int)basecalls.getLength();
        this.numberOfPositionsForEachPeak = numberOfPositionsForEachPeak;
        this.positionOfFirstPeak = positionOfFirstPeak;
        this.readTags = readTags;
    }

    @Override
    public Map<String, String> getComments() {
        return this.comments;
    }

    @Override
    public List<PhdReadTag> getReadTags() {
        return this.readTags;
    }

    @Override
    public List<PhdWholeReadItem> getWholeReadItems() {
        return this.wholeReadItems;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public synchronized PositionSequence getPeakSequence() {
        if (this.fakePositions == null) {
            PositionSequenceBuilder builder = new PositionSequenceBuilder(this.numberOfBases);
            for (int i = 0; i < this.numberOfBases; ++i) {
                builder.append(i * this.numberOfPositionsForEachPeak + this.positionOfFirstPeak);
            }
            this.fakePositions = builder.build();
        }
        return this.fakePositions;
    }

    @Override
    public NucleotideSequence getNucleotideSequence() {
        return this.basecalls;
    }

    @Override
    public QualitySequence getQualitySequence() {
        return this.qualities;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.basecalls == null ? 0 : this.basecalls.hashCode());
        result = 31 * result + (this.comments == null ? 0 : this.comments.hashCode());
        PositionSequence positions = this.getPeakSequence();
        result = 31 * result + positions.hashCode();
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.qualities == null ? 0 : this.qualities.hashCode());
        result = 31 * result + (this.wholeReadItems == null ? 0 : this.wholeReadItems.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Phd)) {
            return false;
        }
        Phd other = (Phd)obj;
        if (!this.id.equals(other.getId())) {
            return false;
        }
        if (!this.basecalls.equals(other.getNucleotideSequence())) {
            return false;
        }
        if (!this.comments.equals(other.getComments())) {
            return false;
        }
        if (!this.getPeakSequence().equals(other.getPeakSequence())) {
            return false;
        }
        if (!this.qualities.equals(other.getQualitySequence())) {
            return false;
        }
        if (!this.wholeReadItems.equals(other.getWholeReadItems())) {
            return false;
        }
        return this.readTags.equals(other.getReadTags());
    }
}

