/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.phd;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jcvi.jillion.assembly.consed.phd.AbstractPhdReadTagVisitor;
import org.jcvi.jillion.assembly.consed.phd.DefaultPhdReadTag;
import org.jcvi.jillion.assembly.consed.phd.DefaultPhdWholeReadItem;
import org.jcvi.jillion.assembly.consed.phd.PhdReadTag;
import org.jcvi.jillion.assembly.consed.phd.PhdReadTagVisitor;
import org.jcvi.jillion.assembly.consed.phd.PhdVisitor;
import org.jcvi.jillion.assembly.consed.phd.PhdWholeReadItem;
import org.jcvi.jillion.assembly.consed.phd.PhdWholeReadItemVisitor;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.pos.PositionSequenceBuilder;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;

public abstract class AbstractPhdVisitor
implements PhdVisitor {
    private final String id;
    private final Integer version;
    private final Map<String, String> comments = new LinkedHashMap<String, String>();
    private final NucleotideSequenceBuilder sequenceBuilder = new NucleotideSequenceBuilder(1024);
    private final QualitySequenceBuilder qualityBuilder = new QualitySequenceBuilder(1024);
    private final PositionSequenceBuilder positionBuilder = new PositionSequenceBuilder(1024);
    private final List<PhdWholeReadItem> wholeReadItems = new ArrayList<PhdWholeReadItem>();
    private final List<PhdReadTag> readTags = new ArrayList<PhdReadTag>();

    public AbstractPhdVisitor(String id, Integer version) {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        if (version != null && version < 1) {
            throw new IllegalArgumentException("version must be >=1 : " + version);
        }
        this.id = id;
        this.version = version;
    }

    @Override
    public final void visitComments(Map<String, String> comments) {
        this.comments.putAll(comments);
    }

    @Override
    public final void visitBasecall(Nucleotide base, PhredQuality quality, Integer tracePosition) {
        this.sequenceBuilder.append(base);
        this.qualityBuilder.append(quality);
        if (tracePosition != null) {
            this.positionBuilder.append(tracePosition);
        }
    }

    @Override
    public final PhdReadTagVisitor visitReadTag() {
        return new AbstractPhdReadTagVisitor(){

            @Override
            protected void visitPhdReadTag(String type, String source, Range ungappedRange, Date date, String comment, String freeFormData) {
                AbstractPhdVisitor.this.readTags.add(new DefaultPhdReadTag(type, source, ungappedRange, date, comment, freeFormData));
            }
        };
    }

    @Override
    public final PhdWholeReadItemVisitor visitWholeReadItem() {
        return new PhdWholeReadItemVisitor(){
            List<String> lines = new ArrayList<String>();

            @Override
            public void visitLine(String line) {
                this.lines.add(line);
            }

            @Override
            public void visitEnd() {
                AbstractPhdVisitor.this.wholeReadItems.add(new DefaultPhdWholeReadItem(this.lines));
            }

            @Override
            public void halted() {
            }
        };
    }

    @Override
    public final void visitEnd() {
        PositionSequence peaks;
        if (this.positionBuilder.getLength() == 0L) {
            peaks = null;
        } else {
            if (this.positionBuilder.getLength() != this.sequenceBuilder.getLength()) {
                throw new IllegalStateException("not all basecalls have positions set");
            }
            peaks = this.positionBuilder.build();
        }
        this.visitPhd(this.id, this.version, this.sequenceBuilder.build(), this.qualityBuilder.build(), peaks, this.comments, this.wholeReadItems, this.readTags);
    }

    protected abstract void visitPhd(String var1, Integer var2, NucleotideSequence var3, QualitySequence var4, PositionSequence var5, Map<String, String> var6, List<PhdWholeReadItem> var7, List<PhdReadTag> var8);

    @Override
    public void halted() {
    }
}

