/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.nav;

import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.AssemblyUtil;
import org.jcvi.jillion.assembly.consed.nav.AbstractNavigationElement;
import org.jcvi.jillion.assembly.consed.nav.NavigationElement;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;

public class ReadNavigationElement
extends AbstractNavigationElement {
    public ReadNavigationElement(String readId, Range ungappedPositionRange, String comment) {
        super(NavigationElement.Type.READ, readId, ungappedPositionRange, comment);
    }

    public ReadNavigationElement(String readId, Range ungappedPositionRange) {
        super(NavigationElement.Type.READ, readId, ungappedPositionRange);
    }

    public ReadNavigationElement buildReadNavigationElement(AssembledRead read, Range gappedFeatureValidRange, int fullLength) {
        return this.buildReadNavigationElement(read, gappedFeatureValidRange, fullLength, null);
    }

    public ReadNavigationElement buildReadNavigationElement(AssembledRead read, Range gappedFeatureValidRange, int fullLength, String comment) {
        Range ungappedRange = AssemblyUtil.toUngappedRange(read.getNucleotideSequence(), gappedFeatureValidRange);
        if (read.getDirection() == Direction.REVERSE) {
            ungappedRange = AssemblyUtil.reverseComplementValidRange(ungappedRange, fullLength);
        }
        return new ReadNavigationElement(read.getId(), ungappedRange, comment);
    }
}

