/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.nav;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jcvi.jillion.assembly.consed.nav.ConsensusNavigationElement;
import org.jcvi.jillion.assembly.consed.nav.ReadNavigationElement;
import org.jcvi.jillion.core.Range;

@SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="\n character is required for .ace format (?) we don't want to accidentally put in a \r\n on diffent OSand break consed")
public final class ConsedNavigationWriter
implements Closeable {
    private final OutputStream out;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final int NAV_ELEMENT_BUFFER_SIZE = 1024;

    public static ConsedNavigationWriter create(String title, OutputStream out) throws IOException {
        if (title == null) {
            throw new NullPointerException("title can not be null");
        }
        return new ConsedNavigationWriter(title, out);
    }

    public static ConsedNavigationWriter createPartial(OutputStream out) {
        return new ConsedNavigationWriter(out);
    }

    public ConsedNavigationWriter(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("output stream can not be null");
        }
        this.out = out;
    }

    public ConsedNavigationWriter(String title, OutputStream out) throws IOException {
        if (out == null) {
            throw new NullPointerException("output stream can not be null");
        }
        if (title != null) {
            out.write((String.format("TITLE: %s", title) + "\n").getBytes(UTF_8));
        }
        this.out = out;
    }

    public ConsedNavigationWriter(String title, File outFile) throws IOException {
        this(title, new BufferedOutputStream(new FileOutputStream(outFile)));
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public void writeNavigationElement(ReadNavigationElement element) throws IOException {
        Range range = element.getUngappedPositionRange();
        String comment = element.getComment();
        StringBuilder builder = new StringBuilder(1024).append("BEGIN_REGION\n").append(String.format("TYPE: %s\n", new Object[]{element.getType()})).append(String.format("READ: %s\n", element.getTargetId())).append(String.format("UNPADDED_READ_POS: %d %d\n", range.getBegin(Range.CoordinateSystem.RESIDUE_BASED), range.getEnd(Range.CoordinateSystem.RESIDUE_BASED))).append(String.format("COMMENT: %s\n", comment == null ? "" : comment)).append("END_REGION\n");
        this.out.write(builder.toString().getBytes(UTF_8));
    }

    public void writeNavigationElement(ConsensusNavigationElement element) throws IOException {
        Range range = element.getUngappedPositionRange();
        String comment = element.getComment();
        StringBuilder builder = new StringBuilder(1024).append("BEGIN_REGION\n").append(String.format("TYPE: %s\n", new Object[]{element.getType()})).append(String.format("CONTIG: %s\n", element.getTargetId())).append(String.format("UNPADDED_CONS_POS: %d %d\n", range.getBegin(Range.CoordinateSystem.RESIDUE_BASED), range.getEnd(Range.CoordinateSystem.RESIDUE_BASED))).append(String.format("COMMENT: %s\n", comment == null ? "" : comment)).append("END_REGION\n");
        this.out.write(builder.toString().getBytes(UTF_8));
    }
}

