/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.nav;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.assembly.consed.nav.ConsedNavigationVisitor;
import org.jcvi.jillion.assembly.consed.nav.ConsensusNavigationElement;
import org.jcvi.jillion.assembly.consed.nav.NavigationElement;
import org.jcvi.jillion.assembly.consed.nav.ReadNavigationElement;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.core.io.TextLineParser;

public final class ConsedNavigationParser {
    private static final Pattern TITLE_PATTERN = Pattern.compile("TITLE: (\\.+)\n");
    private static final Pattern TYPE_PATTERN = Pattern.compile("TYPE: (\\S+)\n");
    private static final Pattern READ_ID_PATTERN = Pattern.compile("READ: (.+)\n");
    private static final Pattern CONTIG_ID_PATTERN = Pattern.compile("CONTIG: (.+)\n");
    private static final Pattern COMMENT_PATTERN = Pattern.compile("COMMENT: (.+)\n");
    private static final Pattern READ_POSITION_PATTERN = Pattern.compile("UNPADDED_READ_POS: (\\d+) (\\d+)\n");
    private static final Pattern CONSENSUS_POSITION_PATTERN = Pattern.compile("UNPADDED_CONS_POS: (\\d+) (\\d+)\n");

    private ConsedNavigationParser() {
    }

    public static void parse(File navFile, ConsedNavigationVisitor visitor) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(navFile);
            ConsedNavigationParser.parse(in, visitor);
        }
        catch (Throwable throwable) {
            IOUtil.closeAndIgnoreErrors(in);
            throw throwable;
        }
        IOUtil.closeAndIgnoreErrors((Closeable)in);
    }

    public static void parse(InputStream in, ConsedNavigationVisitor visitor) throws IOException {
        TextLineParser parser = new TextLineParser(in);
        boolean inRegion = false;
        NavigationElement.Type regionType = null;
        String id = null;
        String currentComment = null;
        Range range = null;
        visitor.visitFile();
        while (parser.hasNextLine()) {
            String line = parser.nextLine();
            visitor.visitLine(line);
            Matcher matcher = TITLE_PATTERN.matcher(line);
            if (matcher.find()) {
                String title = matcher.group(1);
                visitor.visitTitle(title);
                continue;
            }
            if (inRegion) {
                if (line.startsWith("TYPE:")) {
                    Matcher typeMatcher = TYPE_PATTERN.matcher(line);
                    typeMatcher.find();
                    regionType = NavigationElement.Type.valueOf(typeMatcher.group(1));
                    continue;
                }
                if (line.startsWith("READ:")) {
                    Matcher readIdMatcher = READ_ID_PATTERN.matcher(line);
                    readIdMatcher.find();
                    id = readIdMatcher.group(1);
                    continue;
                }
                if (line.startsWith("CONTIG:")) {
                    Matcher contigIdMatcher = CONTIG_ID_PATTERN.matcher(line);
                    contigIdMatcher.find();
                    id = contigIdMatcher.group(1);
                    continue;
                }
                if (line.startsWith("COMMENT:")) {
                    Matcher commentMatcher = COMMENT_PATTERN.matcher(line);
                    commentMatcher.find();
                    currentComment = commentMatcher.group(1);
                    continue;
                }
                if (line.startsWith("UNPADDED_")) {
                    Matcher positionMatcher;
                    switch (regionType) {
                        case CONSENSUS: {
                            positionMatcher = CONSENSUS_POSITION_PATTERN.matcher(line);
                            break;
                        }
                        case READ: {
                            positionMatcher = READ_POSITION_PATTERN.matcher(line);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("could not find region type");
                        }
                    }
                    positionMatcher.find();
                    range = Range.of(Range.CoordinateSystem.RESIDUE_BASED, Integer.parseInt(positionMatcher.group(1)), Integer.parseInt(positionMatcher.group(2)));
                    continue;
                }
                if (!line.startsWith("END_REGION")) continue;
                inRegion = false;
                if (regionType == null) {
                    throw new IllegalStateException("could not find region type");
                }
                if (regionType == NavigationElement.Type.CONSENSUS) {
                    visitor.visitElement(new ConsensusNavigationElement(id, range, currentComment));
                    continue;
                }
                visitor.visitElement(new ReadNavigationElement(id, range, currentComment));
                continue;
            }
            if (!line.startsWith("BEGIN_REGION")) continue;
            inRegion = true;
            regionType = null;
            id = null;
            currentComment = null;
        }
        visitor.visitEndOfFile();
    }
}

