/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.nav;

import org.jcvi.jillion.assembly.consed.nav.NavigationElement;
import org.jcvi.jillion.core.Range;

public abstract class AbstractNavigationElement
implements NavigationElement {
    private final NavigationElement.Type type;
    private final Range ungappedPositionRange;
    private final String comment;
    private final String targetId;

    public AbstractNavigationElement(NavigationElement.Type type, String targetId, Range ungappedPositionRange, String comment) {
        if (type == null) {
            throw new NullPointerException("type can not be null");
        }
        if (targetId == null) {
            throw new NullPointerException("element id can not be null");
        }
        if (ungappedPositionRange == null) {
            throw new NullPointerException("ungappedPositionRange can not be null");
        }
        this.type = type;
        this.targetId = targetId;
        this.ungappedPositionRange = ungappedPositionRange;
        this.comment = comment;
    }

    public AbstractNavigationElement(NavigationElement.Type type, String elementId, Range ungappedPositionRange) {
        this(type, elementId, ungappedPositionRange, null);
    }

    @Override
    public NavigationElement.Type getType() {
        return this.type;
    }

    @Override
    public Range getUngappedPositionRange() {
        return this.ungappedPositionRange;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String getTargetId() {
        return this.targetId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = 31 * result + this.targetId.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.ungappedPositionRange.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractNavigationElement)) {
            return false;
        }
        AbstractNavigationElement other = (AbstractNavigationElement)obj;
        if (this.comment == null ? other.comment != null : !this.comment.equals(other.comment)) {
            return false;
        }
        if (!this.targetId.equals(other.targetId)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.ungappedPositionRange.equals(other.ungappedPositionRange);
    }
}

