/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import java.util.Date;

public final class PhdInfo {
    private final String traceName;
    private final String phdName;
    private final long phdDateMillis;

    public PhdInfo(String traceName, String phdName, Date phdDate) {
        if (traceName == null) {
            throw new NullPointerException("trace name can not be null");
        }
        if (phdName == null) {
            throw new NullPointerException("phd name can not be null");
        }
        if (phdDate == null) {
            throw new NullPointerException("phd date can not be null");
        }
        this.traceName = traceName;
        this.phdName = phdName;
        this.phdDateMillis = phdDate.getTime();
    }

    public Date getPhdDate() {
        return new Date(this.phdDateMillis);
    }

    public String getPhdName() {
        return this.phdName;
    }

    public String getTraceName() {
        return this.traceName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.phdDateMillis ^ this.phdDateMillis >>> 32);
        result = 31 * result + (this.phdName == null ? 0 : this.phdName.hashCode());
        result = 31 * result + (this.traceName == null ? 0 : this.traceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhdInfo)) {
            return false;
        }
        PhdInfo other = (PhdInfo)obj;
        if (this.phdDateMillis != other.getPhdDate().getTime()) {
            return false;
        }
        if (this.phdName == null ? other.phdName != null : !this.phdName.equals(other.phdName)) {
            return false;
        }
        return !(this.traceName == null ? other.traceName != null : !this.traceName.equals(other.traceName));
    }

    public String toString() {
        return "DefaultPhdInfo [traceName=" + this.traceName + ", phdName=" + this.phdName + ", phdDate=" + this.phdDateMillis + "]";
    }
}

