/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jcvi.jillion.assembly.consed.ace.AceContigReadVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceContigVisitor;
import org.jcvi.jillion.assembly.consed.ace.MultipleAceContigReadVisitor;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.QualitySequence;

public class MultipleAceContigVisitor
implements AceContigVisitor {
    private final List<AceContigVisitor> delegates;

    public MultipleAceContigVisitor(AceContigVisitor ... delegates) {
        this(Arrays.asList(delegates));
    }

    public MultipleAceContigVisitor(List<? extends AceContigVisitor> delegates) {
        this.delegates = new ArrayList<AceContigVisitor>(delegates.size());
        for (AceContigVisitor aceContigVisitor : delegates) {
            if (aceContigVisitor == null) continue;
            this.delegates.add(aceContigVisitor);
        }
    }

    @Override
    public void visitBasesLine(String mixedCaseBasecalls) {
        for (AceContigVisitor visitor : this.delegates) {
            visitor.visitBasesLine(mixedCaseBasecalls);
        }
    }

    @Override
    public void visitConsensusQualities(QualitySequence ungappedConsensusQualities) {
        for (AceContigVisitor visitor : this.delegates) {
            visitor.visitConsensusQualities(ungappedConsensusQualities);
        }
    }

    @Override
    public void visitAlignedReadInfo(String readId, Direction dir, int gappedStartPosition) {
        for (AceContigVisitor visitor : this.delegates) {
            visitor.visitAlignedReadInfo(readId, dir, gappedStartPosition);
        }
    }

    @Override
    public void visitBaseSegment(Range gappedConsensusRange, String readId) {
        for (AceContigVisitor visitor : this.delegates) {
            visitor.visitBaseSegment(gappedConsensusRange, readId);
        }
    }

    @Override
    public AceContigReadVisitor visitBeginRead(String readId, int gappedLength) {
        ArrayList<AceContigReadVisitor> readVisitors = new ArrayList<AceContigReadVisitor>(this.delegates.size());
        for (AceContigVisitor visitor : this.delegates) {
            AceContigReadVisitor readVisitor = visitor.visitBeginRead(readId, gappedLength);
            if (readVisitor == null) continue;
            readVisitors.add(readVisitor);
        }
        if (readVisitors.isEmpty()) {
            return null;
        }
        return new MultipleAceContigReadVisitor(readVisitors);
    }

    @Override
    public void visitEnd() {
        for (AceContigVisitor visitor : this.delegates) {
            visitor.visitEnd();
        }
    }

    @Override
    public void halted() {
        for (AceContigVisitor visitor : this.delegates) {
            visitor.halted();
        }
    }
}

