/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jcvi.jillion.assembly.consed.ace.AceConsensusTagVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceContigReadVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceContigVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceFileVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceFileVisitorCallback;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.QualitySequence;

public class MultiAceFileVisitorAdapter
implements AceFileVisitor {
    private final List<AceFileVisitor> visitors;
    private List<AceContigVisitor> currentContigVisitors;
    private List<AceContigReadVisitor> currentReadVisitors;
    private List<AceConsensusTagVisitor> currentConsensusTagVisitors;
    private List<AceFileVisitorCallbackAdapter> currentCallbacks;
    private AceFileVisitorCallback ourCallback;

    public MultiAceFileVisitorAdapter(AceFileVisitor ... visitors) {
        this(Arrays.asList(visitors));
    }

    public MultiAceFileVisitorAdapter(Collection<? extends AceFileVisitor> visitors) {
        if (visitors.isEmpty()) {
            throw new IllegalArgumentException("must provide at least one visitor");
        }
        this.visitors = new ArrayList<AceFileVisitor>(visitors.size());
        for (AceFileVisitor aceFileVisitor : visitors) {
            if (aceFileVisitor == null) {
                throw new NullPointerException("visitor can not be null");
            }
            this.visitors.add(aceFileVisitor);
        }
    }

    private boolean handleHaltedVisitors() {
        if (this.ourCallback == null) {
            return false;
        }
        for (int i = this.currentCallbacks.size(); i >= 0; --i) {
            if (!this.currentCallbacks.get(i).isHalted()) continue;
            this.haltVisitor(i);
        }
        if (this.currentCallbacks.isEmpty()) {
            this.ourCallback.haltParsing();
            this.ourCallback = null;
            this.currentReadVisitors = null;
            this.currentContigVisitors = null;
            this.currentConsensusTagVisitors = null;
            return true;
        }
        return false;
    }

    private void haltVisitor(int i) {
        AceConsensusTagVisitor tagVisitor;
        AceContigVisitor contigVisitor;
        AceContigReadVisitor readVisitor;
        if (this.currentReadVisitors != null && (readVisitor = this.currentReadVisitors.remove(i)) != null) {
            readVisitor.halted();
        }
        if (this.currentContigVisitors != null && (contigVisitor = this.currentContigVisitors.remove(i)) != null) {
            contigVisitor.halted();
        }
        if (this.currentConsensusTagVisitors != null && (tagVisitor = this.currentConsensusTagVisitors.remove(i)) != null) {
            tagVisitor.halted();
        }
        AceFileVisitor visitor = this.visitors.remove(i);
        visitor.halted();
        this.currentCallbacks.remove(i);
    }

    @Override
    public void visitHeader(int numberOfContigs, long totalNumberOfReads) {
        for (AceFileVisitor visitor : this.visitors) {
            visitor.visitHeader(numberOfContigs, totalNumberOfReads);
        }
    }

    @Override
    public AceContigVisitor visitContig(AceFileVisitorCallback callback, String contigId, int numberOfBases, int numberOfReads, int numberOfBaseSegments, boolean reverseComplemented) {
        this.ourCallback = callback;
        this.currentCallbacks = new ArrayList<AceFileVisitorCallbackAdapter>(this.visitors.size());
        this.currentContigVisitors = new ArrayList<AceContigVisitor>(this.visitors.size());
        boolean skipContig = true;
        for (AceFileVisitor visitor : this.visitors) {
            AceFileVisitorCallbackAdapter adaptedCallback = new AceFileVisitorCallbackAdapter(callback);
            this.currentCallbacks.add(adaptedCallback);
            AceContigVisitor contigVisitor = visitor.visitContig(adaptedCallback, contigId, numberOfBases, numberOfReads, numberOfBaseSegments, reverseComplemented);
            this.currentContigVisitors.add(contigVisitor);
            if (contigVisitor == null) continue;
            skipContig = false;
        }
        if (this.handleHaltedVisitors()) {
            return null;
        }
        if (skipContig) {
            this.currentContigVisitors = null;
            return null;
        }
        return new MultiAceContigVisitor();
    }

    @Override
    public void visitReadTag(String id, String type, String creator, long gappedStart, long gappedEnd, Date creationDate, boolean isTransient) {
        for (AceFileVisitor visitor : this.visitors) {
            visitor.visitReadTag(id, type, creator, gappedStart, gappedEnd, creationDate, isTransient);
        }
    }

    @Override
    public AceConsensusTagVisitor visitConsensusTag(String id, String type, String creator, long gappedStart, long gappedEnd, Date creationDate, boolean isTransient) {
        this.currentConsensusTagVisitors = new ArrayList<AceConsensusTagVisitor>(this.visitors.size());
        boolean skipTag = true;
        for (AceFileVisitor visitor : this.visitors) {
            AceConsensusTagVisitor tagVisitor = visitor.visitConsensusTag(id, type, creator, gappedStart, gappedEnd, creationDate, isTransient);
            this.currentConsensusTagVisitors.add(tagVisitor);
            if (tagVisitor == null) continue;
            skipTag = true;
        }
        if (this.handleHaltedVisitors() || skipTag) {
            this.currentConsensusTagVisitors = null;
            return null;
        }
        return new MultiAceConsensusTagVisitor();
    }

    @Override
    public void visitWholeAssemblyTag(String type, String creator, Date creationDate, String data) {
        for (AceFileVisitor visitor : this.visitors) {
            visitor.visitWholeAssemblyTag(type, creator, creationDate, data);
        }
    }

    @Override
    public void visitEnd() {
        for (AceFileVisitor visitor : this.visitors) {
            visitor.visitEnd();
        }
    }

    @Override
    public void halted() {
        if (this.currentReadVisitors != null) {
            for (AceContigReadVisitor readVisitor : this.currentReadVisitors) {
                readVisitor.halted();
            }
        }
        if (this.currentContigVisitors != null) {
            for (AceContigVisitor contigVisitor : this.currentContigVisitors) {
                contigVisitor.halted();
            }
        }
        if (this.currentConsensusTagVisitors != null) {
            for (AceConsensusTagVisitor tagVisitor : this.currentConsensusTagVisitors) {
                tagVisitor.halted();
            }
        }
        for (AceFileVisitor visitor : this.visitors) {
            visitor.halted();
        }
    }

    private static class AceFileVisitorCallbackAdapter
    implements AceFileVisitorCallback {
        private final AceFileVisitorCallback callback;
        private volatile boolean halt;

        public AceFileVisitorCallbackAdapter(AceFileVisitorCallback callback) {
            this.callback = callback;
        }

        @Override
        public boolean canCreateMemento() {
            return this.callback.canCreateMemento();
        }

        @Override
        public AceFileVisitorCallback.AceFileVisitorMemento createMemento() {
            return this.callback.createMemento();
        }

        @Override
        public void haltParsing() {
            this.halt = true;
        }

        public boolean isHalted() {
            return this.halt;
        }
    }

    private class MultiAceContigReadVisitor
    implements AceContigReadVisitor {
        private MultiAceContigReadVisitor() {
        }

        @Override
        public void visitQualityLine(int qualLeft, int qualRight, int alignLeft, int alignRight) {
            for (AceContigReadVisitor visitor : MultiAceFileVisitorAdapter.this.currentReadVisitors) {
                if (visitor == null) continue;
                visitor.visitQualityLine(qualLeft, qualRight, alignLeft, alignRight);
            }
            MultiAceFileVisitorAdapter.this.handleHaltedVisitors();
        }

        @Override
        public void visitTraceDescriptionLine(String traceName, String phdName, Date date) {
            for (AceContigReadVisitor visitor : MultiAceFileVisitorAdapter.this.currentReadVisitors) {
                if (visitor == null) continue;
                visitor.visitTraceDescriptionLine(traceName, phdName, date);
            }
            MultiAceFileVisitorAdapter.this.handleHaltedVisitors();
        }

        @Override
        public void visitBasesLine(String mixedCaseBasecalls) {
            for (AceContigReadVisitor visitor : MultiAceFileVisitorAdapter.this.currentReadVisitors) {
                if (visitor == null) continue;
                visitor.visitBasesLine(mixedCaseBasecalls);
            }
            MultiAceFileVisitorAdapter.this.handleHaltedVisitors();
        }

        @Override
        public void visitEnd() {
            for (AceContigReadVisitor visitor : MultiAceFileVisitorAdapter.this.currentReadVisitors) {
                if (visitor == null) continue;
                visitor.visitEnd();
            }
            MultiAceFileVisitorAdapter.this.handleHaltedVisitors();
            MultiAceFileVisitorAdapter.this.currentReadVisitors = null;
        }

        @Override
        public void halted() {
        }
    }

    private class MultiAceContigVisitor
    implements AceContigVisitor {
        private MultiAceContigVisitor() {
        }

        @Override
        public void visitBasesLine(String mixedCaseBasecalls) {
            for (AceContigVisitor visitor : MultiAceFileVisitorAdapter.this.currentContigVisitors) {
                if (visitor == null) continue;
                visitor.visitBasesLine(mixedCaseBasecalls);
            }
            MultiAceFileVisitorAdapter.this.handleHaltedVisitors();
        }

        @Override
        public void visitConsensusQualities(QualitySequence ungappedConsensusQualities) {
            for (AceContigVisitor visitor : MultiAceFileVisitorAdapter.this.currentContigVisitors) {
                if (visitor == null) continue;
                visitor.visitConsensusQualities(ungappedConsensusQualities);
            }
            MultiAceFileVisitorAdapter.this.handleHaltedVisitors();
        }

        @Override
        public void visitAlignedReadInfo(String readId, Direction dir, int gappedStartPosition) {
            for (AceContigVisitor visitor : MultiAceFileVisitorAdapter.this.currentContigVisitors) {
                if (visitor == null) continue;
                visitor.visitAlignedReadInfo(readId, dir, gappedStartPosition);
            }
            MultiAceFileVisitorAdapter.this.handleHaltedVisitors();
        }

        @Override
        public void visitBaseSegment(Range gappedConsensusRange, String readId) {
            for (AceContigVisitor visitor : MultiAceFileVisitorAdapter.this.currentContigVisitors) {
                if (visitor == null) continue;
                visitor.visitBaseSegment(gappedConsensusRange, readId);
            }
            MultiAceFileVisitorAdapter.this.handleHaltedVisitors();
        }

        @Override
        public AceContigReadVisitor visitBeginRead(String readId, int gappedLength) {
            MultiAceFileVisitorAdapter.this.currentReadVisitors = new ArrayList(MultiAceFileVisitorAdapter.this.currentContigVisitors.size());
            boolean skipRead = true;
            for (AceContigVisitor visitor : MultiAceFileVisitorAdapter.this.currentContigVisitors) {
                if (visitor == null) {
                    MultiAceFileVisitorAdapter.this.currentReadVisitors.add(null);
                    continue;
                }
                AceContigReadVisitor readVisitor = visitor.visitBeginRead(readId, gappedLength);
                MultiAceFileVisitorAdapter.this.currentReadVisitors.add(readVisitor);
                if (readVisitor == null) continue;
                skipRead = false;
            }
            if (MultiAceFileVisitorAdapter.this.handleHaltedVisitors()) {
                return null;
            }
            if (skipRead) {
                MultiAceFileVisitorAdapter.this.currentReadVisitors = null;
                return null;
            }
            return new MultiAceContigReadVisitor();
        }

        @Override
        public void visitEnd() {
            for (AceContigVisitor visitor : MultiAceFileVisitorAdapter.this.currentContigVisitors) {
                if (visitor == null) continue;
                visitor.visitEnd();
            }
            MultiAceFileVisitorAdapter.this.currentContigVisitors = null;
            MultiAceFileVisitorAdapter.this.handleHaltedVisitors();
        }

        @Override
        public void halted() {
        }
    }

    private class MultiAceConsensusTagVisitor
    implements AceConsensusTagVisitor {
        private MultiAceConsensusTagVisitor() {
        }

        @Override
        public void visitComment(String comment) {
            for (AceConsensusTagVisitor visitor : MultiAceFileVisitorAdapter.this.currentConsensusTagVisitors) {
                if (visitor == null) continue;
                visitor.visitComment(comment);
            }
            MultiAceFileVisitorAdapter.this.handleHaltedVisitors();
        }

        @Override
        public void visitData(String data) {
            for (AceConsensusTagVisitor visitor : MultiAceFileVisitorAdapter.this.currentConsensusTagVisitors) {
                if (visitor == null) continue;
                visitor.visitData(data);
            }
            MultiAceFileVisitorAdapter.this.handleHaltedVisitors();
        }

        @Override
        public void visitEnd() {
            for (AceConsensusTagVisitor visitor : MultiAceFileVisitorAdapter.this.currentConsensusTagVisitors) {
                if (visitor == null) continue;
                visitor.visitEnd();
            }
            MultiAceFileVisitorAdapter.this.handleHaltedVisitors();
        }

        @Override
        public void halted() {
        }
    }
}

