/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jcvi.jillion.assembly.consed.ConsedUtil;
import org.jcvi.jillion.assembly.consed.ace.AbstractAceConsensusTagVisitor;
import org.jcvi.jillion.assembly.consed.ace.AbstractAceContigBuilderVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceConsensusTagVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceContig;
import org.jcvi.jillion.assembly.consed.ace.AceContigBuilder;
import org.jcvi.jillion.assembly.consed.ace.AceContigReadVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceContigVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceFileDataStore;
import org.jcvi.jillion.assembly.consed.ace.AceFileParser;
import org.jcvi.jillion.assembly.consed.ace.AceFileVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceFileVisitorCallback;
import org.jcvi.jillion.assembly.consed.ace.ConsensusAceTag;
import org.jcvi.jillion.assembly.consed.ace.ReadAceTag;
import org.jcvi.jillion.assembly.consed.ace.WholeAssemblyAceTag;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;
import org.jcvi.jillion.internal.core.util.iter.AbstractBlockingStreamingIterator;

final class LargeAceFileDataStore
implements AceFileDataStore {
    private final File aceFile;
    private Long numberOfContigs = null;
    private Long totalNumberOfReads = null;
    private List<WholeAssemblyAceTag> wholeAssemblyTags = null;
    private List<ConsensusAceTag> consensusTags = null;
    private List<ReadAceTag> readTags = null;
    private final DataStoreFilter contigIdFilter;
    private volatile boolean isClosed;

    public static AceFileDataStore create(File aceFile) throws FileNotFoundException {
        return new LargeAceFileDataStore(aceFile, DataStoreFilters.alwaysAccept());
    }

    public static AceFileDataStore create(File aceFile, DataStoreFilter contigIdFilter) throws FileNotFoundException {
        return new LargeAceFileDataStore(aceFile, contigIdFilter);
    }

    private LargeAceFileDataStore(File aceFile, DataStoreFilter contigIdFilter) throws FileNotFoundException {
        if (contigIdFilter == null) {
            throw new NullPointerException("filter can not be null");
        }
        if (aceFile == null) {
            throw new NullPointerException("ace file can not be null");
        }
        if (!aceFile.exists()) {
            throw new FileNotFoundException(String.format("ace file %s does not exist", aceFile.getAbsolutePath()));
        }
        this.aceFile = aceFile;
        this.contigIdFilter = contigIdFilter;
    }

    private final void throwExceptionIfClosed() {
        if (this.isClosed) {
            throw new DataStoreClosedException("DataStore is closed");
        }
    }

    @Override
    public final void close() throws IOException {
        this.isClosed = true;
    }

    @Override
    public final boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public synchronized StreamingIterator<String> idIterator() throws DataStoreException {
        this.throwExceptionIfClosed();
        IdIteratorImpl ids = new IdIteratorImpl();
        ids.start();
        return DataStoreStreamingIterator.create(this, ids);
    }

    @Override
    public AceContig get(String id) throws DataStoreException {
        this.throwExceptionIfClosed();
        if (!this.contigIdFilter.accept(id)) {
            return null;
        }
        SingleContigVisitor visitor = new SingleContigVisitor(id);
        try {
            AceFileParser.create(this.aceFile).parse(visitor);
        }
        catch (IOException e) {
            throw new DataStoreException("error parsing ace file", e);
        }
        return visitor.getContig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(String id) throws DataStoreException {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        this.throwExceptionIfClosed();
        if (!this.contigIdFilter.accept(id)) {
            return false;
        }
        StreamingIterator<String> ids = this.idIterator();
        try {
            while (ids.hasNext()) {
                String nextId = ids.next();
                if (!id.equals(nextId)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            IOUtil.closeAndIgnoreErrors(ids);
        }
        return false;
    }

    @Override
    public synchronized StreamingIterator<WholeAssemblyAceTag> getWholeAssemblyTagIterator() throws DataStoreException {
        this.throwExceptionIfClosed();
        if (this.wholeAssemblyTags == null) {
            this.setTagLists();
        }
        return IteratorUtil.createStreamingIterator(this.wholeAssemblyTags.iterator());
    }

    @Override
    public synchronized StreamingIterator<ReadAceTag> getReadTagIterator() throws DataStoreException {
        this.throwExceptionIfClosed();
        if (this.readTags == null) {
            this.setTagLists();
        }
        return IteratorUtil.createStreamingIterator(this.readTags.iterator());
    }

    @Override
    public synchronized StreamingIterator<ConsensusAceTag> getConsensusTagIterator() throws DataStoreException {
        this.throwExceptionIfClosed();
        if (this.consensusTags == null) {
            this.setTagLists();
        }
        return IteratorUtil.createStreamingIterator(this.consensusTags.iterator());
    }

    private void setTagLists() throws DataStoreException {
        try {
            AceTagsVisitor visitor = new AceTagsVisitor();
            AceFileParser.create(this.aceFile).parse(visitor);
            if (!visitor.isCompletlyParsed()) {
                throw new DataStoreException("could not completely parse tags from ace file");
            }
            this.wholeAssemblyTags = visitor.getWholeAssemblyTags();
            this.consensusTags = visitor.getConsensusTags();
            this.readTags = visitor.getReadTags();
        }
        catch (IOException e) {
            throw new DataStoreException("error parsing ace tags from ace file", e);
        }
    }

    @Override
    public synchronized long getNumberOfTotalReads() throws DataStoreException {
        this.throwExceptionIfClosed();
        if (this.totalNumberOfReads == null) {
            this.setNumContigsAndTotalReads();
        }
        return this.totalNumberOfReads;
    }

    @Override
    public synchronized long getNumberOfRecords() throws DataStoreException {
        this.throwExceptionIfClosed();
        if (this.numberOfContigs == null) {
            this.setNumContigsAndTotalReads();
        }
        return this.numberOfContigs;
    }

    private synchronized void setNumContigsAndTotalReads() throws DataStoreException {
        SizeVisitor visitor = new SizeVisitor();
        try {
            AceFileParser.create(this.aceFile).parse(visitor);
        }
        catch (IOException e) {
            throw new DataStoreException("error parsing number of contigs", e);
        }
        this.totalNumberOfReads = visitor.getTotalNumberOfReads();
        this.numberOfContigs = visitor.getNumberOfContigs();
    }

    @Override
    public StreamingIterator<AceContig> iterator() {
        this.throwExceptionIfClosed();
        AceFileDataStoreIterator iter = new AceFileDataStoreIterator();
        iter.start();
        return DataStoreStreamingIterator.create(this, iter);
    }

    @Override
    public final StreamingIterator<DataStoreEntry<AceContig>> entryIterator() throws DataStoreException {
        this.throwExceptionIfClosed();
        return new StreamingIterator<DataStoreEntry<AceContig>>(){
            StreamingIterator<AceContig> iter;
            {
                this.iter = LargeAceFileDataStore.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public void close() {
                this.iter.close();
            }

            @Override
            public DataStoreEntry<AceContig> next() {
                AceContig next = this.iter.next();
                return new DataStoreEntry<AceContig>(next.getId(), next);
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    private class AceTagsVisitor
    implements AceFileVisitor {
        private final List<WholeAssemblyAceTag> wholeAssemblyTags = new ArrayList<WholeAssemblyAceTag>();
        private final List<ConsensusAceTag> consensusTags = new ArrayList<ConsensusAceTag>();
        private final List<ReadAceTag> readTags = new ArrayList<ReadAceTag>();
        private boolean completlyParsed = false;

        private AceTagsVisitor() {
        }

        @Override
        public void visitHeader(int numberOfContigs, long totalNumberOfReads) {
        }

        @Override
        public AceContigVisitor visitContig(AceFileVisitorCallback callback, String contigId, int numberOfBases, int numberOfReads, int numberOfBaseSegments, boolean reverseComplemented) {
            return null;
        }

        @Override
        public void visitReadTag(String id, String type, String creator, long gappedStart, long gappedEnd, Date creationDate, boolean isTransient) {
            this.readTags.add(new ReadAceTag(id, type, creator, creationDate, Range.of(gappedStart, gappedEnd), isTransient));
        }

        @Override
        public AceConsensusTagVisitor visitConsensusTag(String id, String type, String creator, long gappedStart, long gappedEnd, Date creationDate, boolean isTransient) {
            if (LargeAceFileDataStore.this.contigIdFilter.accept(id)) {
                return new AbstractAceConsensusTagVisitor(id, type, creator, gappedStart, gappedEnd, creationDate, isTransient){

                    @Override
                    protected void visitConsensusTag(ConsensusAceTag consensusTag) {
                        AceTagsVisitor.this.consensusTags.add(consensusTag);
                    }
                };
            }
            return null;
        }

        @Override
        public void visitWholeAssemblyTag(String type, String creator, Date creationDate, String data) {
            this.wholeAssemblyTags.add(new WholeAssemblyAceTag(type, creator, creationDate, data.trim()));
        }

        @Override
        public void visitEnd() {
            this.completlyParsed = true;
        }

        @Override
        public void halted() {
        }

        public final List<WholeAssemblyAceTag> getWholeAssemblyTags() {
            return this.wholeAssemblyTags;
        }

        public final List<ConsensusAceTag> getConsensusTags() {
            return this.consensusTags;
        }

        public final List<ReadAceTag> getReadTags() {
            return this.readTags;
        }

        public final boolean isCompletlyParsed() {
            return this.completlyParsed;
        }
    }

    private final class IdIteratorImpl
    extends AbstractBlockingStreamingIterator<String> {
        private IdIteratorImpl() {
        }

        @Override
        protected void backgroundThreadRunMethod() {
            InnerVisitor builder = new InnerVisitor();
            try {
                AceFileParser.create(LargeAceFileDataStore.this.aceFile).parse(builder);
            }
            catch (Exception e) {
                throw new RuntimeException("error while iterating over ace file", e);
            }
        }

        private class InnerVisitor
        implements AceFileVisitor {
            private InnerVisitor() {
            }

            @Override
            public void visitHeader(int numberOfContigs, long totalNumberOfReads) {
            }

            @Override
            public AceContigVisitor visitContig(AceFileVisitorCallback callback, String contigId, int numberOfBases, int numberOfReads, int numberOfBaseSegments, boolean reverseComplemented) {
                if (LargeAceFileDataStore.this.contigIdFilter.accept(contigId)) {
                    IdIteratorImpl.this.blockingPut(contigId);
                }
                return null;
            }

            @Override
            public void visitReadTag(String id, String type, String creator, long gappedStart, long gappedEnd, Date creationDate, boolean isTransient) {
            }

            @Override
            public AceConsensusTagVisitor visitConsensusTag(String id, String type, String creator, long gappedStart, long gappedEnd, Date creationDate, boolean isTransient) {
                return null;
            }

            @Override
            public void visitWholeAssemblyTag(String type, String creator, Date creationDate, String data) {
            }

            @Override
            public void visitEnd() {
            }

            @Override
            public void halted() {
            }
        }
    }

    private static final class SingleContigVisitor
    implements AceFileVisitor {
        private AceContig contig;
        private final String contigIdToGet;

        public SingleContigVisitor(String contigIdToGet) {
            this.contigIdToGet = contigIdToGet;
        }

        public final AceContig getContig() {
            return this.contig;
        }

        @Override
        public void visitHeader(int numberOfContigs, long totalNumberOfReads) {
        }

        @Override
        public AceContigVisitor visitContig(final AceFileVisitorCallback callback, String contigId, int numberOfBases, int numberOfReads, int numberOfBaseSegments, boolean reverseComplemented) {
            if (contigId.equals(this.contigIdToGet)) {
                return new AbstractAceContigBuilderVisitor(contigId, numberOfBases, numberOfReads){

                    @Override
                    protected void visitContig(AceContigBuilder builder) {
                        contig = builder.build();
                        callback.haltParsing();
                    }
                };
            }
            return null;
        }

        @Override
        public void visitReadTag(String id, String type, String creator, long gappedStart, long gappedEnd, Date creationDate, boolean isTransient) {
        }

        @Override
        public AceConsensusTagVisitor visitConsensusTag(String id, String type, String creator, long gappedStart, long gappedEnd, Date creationDate, boolean isTransient) {
            return null;
        }

        @Override
        public void visitWholeAssemblyTag(String type, String creator, Date creationDate, String data) {
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }
    }

    private final class AceFileDataStoreIterator
    extends AbstractBlockingStreamingIterator<AceContig> {
        private AceFileDataStoreIterator() {
        }

        @Override
        protected void backgroundThreadRunMethod() {
            AceFileVisitor visitor = new AceFileVisitor(){

                @Override
                public void visitHeader(int numberOfContigs, long totalNumberOfReads) {
                }

                @Override
                public AceContigVisitor visitContig(AceFileVisitorCallback callback, String contigId, int numberOfBases, int numberOfReads, int numberOfBaseSegments, boolean reverseComplemented) {
                    if (LargeAceFileDataStore.this.contigIdFilter.accept(contigId)) {
                        return new AbstractAceContigBuilderVisitor(contigId, numberOfBases, numberOfReads){

                            @Override
                            protected void visitContig(AceContigBuilder builder) {
                                AceFileDataStoreIterator.this.blockingPut(builder.build());
                            }
                        };
                    }
                    return null;
                }

                @Override
                public void visitReadTag(String id, String type, String creator, long gappedStart, long gappedEnd, Date creationDate, boolean isTransient) {
                }

                @Override
                public AceConsensusTagVisitor visitConsensusTag(String id, String type, String creator, long gappedStart, long gappedEnd, Date creationDate, boolean isTransient) {
                    return null;
                }

                @Override
                public void visitWholeAssemblyTag(String type, String creator, Date creationDate, String data) {
                }

                @Override
                public void visitEnd() {
                }

                @Override
                public void halted() {
                }
            };
            try {
                AceFileParser.create(LargeAceFileDataStore.this.aceFile).parse(visitor);
            }
            catch (Exception e) {
                throw new RuntimeException("error while iterating over ace file", e);
            }
        }
    }

    private final class SizeVisitor
    implements AceFileVisitor {
        private final AceContigReadVisitor readVisitor = new AceContigReadVisitor(){

            @Override
            public void visitTraceDescriptionLine(String traceName, String phdName, Date date) {
            }

            @Override
            public void visitQualityLine(int qualLeft, int qualRight, int alignLeft, int alignRight) {
                ConsedUtil.ClipPointsType clipPointsType = ConsedUtil.ClipPointsType.getType(qualLeft, qualRight, alignLeft, alignRight);
                if (clipPointsType != ConsedUtil.ClipPointsType.VALID) {
                    SizeVisitor.this.totalNumberOfReads--;
                }
            }

            @Override
            public void visitEnd() {
            }

            @Override
            public void visitBasesLine(String mixedCaseBasecalls) {
            }

            @Override
            public void halted() {
            }
        };
        private long size = 0L;
        private long totalNumberOfReads = 0L;

        private SizeVisitor() {
        }

        public long getNumberOfContigs() {
            return this.size;
        }

        public long getTotalNumberOfReads() {
            return this.totalNumberOfReads;
        }

        @Override
        public void visitHeader(int numberOfContigs, long totalNumberOfReads) {
        }

        @Override
        public AceContigVisitor visitContig(AceFileVisitorCallback callback, String contigId, int numberOfBases, int numberOfReads, int numberOfBaseSegments, boolean reverseComplemented) {
            if (LargeAceFileDataStore.this.contigIdFilter.accept(contigId)) {
                ++this.size;
                this.totalNumberOfReads += (long)numberOfReads;
                return new AceContigVisitor(){

                    @Override
                    public void visitEnd() {
                    }

                    @Override
                    public void visitConsensusQualities(QualitySequence ungappedConsensusQualities) {
                    }

                    @Override
                    public AceContigReadVisitor visitBeginRead(String readId, int gappedLength) {
                        return SizeVisitor.this.readVisitor;
                    }

                    @Override
                    public void visitBasesLine(String mixedCaseBasecalls) {
                    }

                    @Override
                    public void visitBaseSegment(Range gappedConsensusRange, String readId) {
                    }

                    @Override
                    public void visitAlignedReadInfo(String readId, Direction dir, int gappedStartOffset) {
                    }

                    @Override
                    public void halted() {
                    }
                };
            }
            return null;
        }

        @Override
        public void visitReadTag(String id, String type, String creator, long gappedStart, long gappedEnd, Date creationDate, boolean isTransient) {
        }

        @Override
        public AceConsensusTagVisitor visitConsensusTag(String id, String type, String creator, long gappedStart, long gappedEnd, Date creationDate, boolean isTransient) {
            return null;
        }

        @Override
        public void visitWholeAssemblyTag(String type, String creator, Date creationDate, String data) {
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }
    }
}

