/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jcvi.jillion.assembly.consed.ace.AbstractAceConsensusTagVisitor;
import org.jcvi.jillion.assembly.consed.ace.AbstractAceContigBuilderVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceConsensusTagVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceContig;
import org.jcvi.jillion.assembly.consed.ace.AceContigBuilder;
import org.jcvi.jillion.assembly.consed.ace.AceContigVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceFileDataStore;
import org.jcvi.jillion.assembly.consed.ace.AceFileParser;
import org.jcvi.jillion.assembly.consed.ace.AceFileVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceFileVisitorCallback;
import org.jcvi.jillion.assembly.consed.ace.AceParser;
import org.jcvi.jillion.assembly.consed.ace.ConsensusAceTag;
import org.jcvi.jillion.assembly.consed.ace.LargeAceFileDataStore;
import org.jcvi.jillion.assembly.consed.ace.ReadAceTag;
import org.jcvi.jillion.assembly.consed.ace.WholeAssemblyAceTag;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.util.MapUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;

final class IndexedAceFileDataStore
implements AceFileDataStore {
    private final Map<String, AceFileVisitorCallback.AceFileVisitorMemento> mementos;
    private final List<WholeAssemblyAceTag> wholeAssemblyTags;
    private final List<ConsensusAceTag> consensusTags;
    private final List<ReadAceTag> readTags;
    private final AceParser parser;
    private final long totalNumberOfReads;
    private volatile boolean closed = false;
    private final DataStoreFilter filter;
    private final File aceFile;

    public static AceFileDataStore create(File aceFile, DataStoreFilter filter) throws IOException {
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        AceParser parser = AceFileParser.create(aceFile);
        VisitorBuilder visitorBuilder = new VisitorBuilder(filter);
        parser.parse(visitorBuilder);
        return new IndexedAceFileDataStore(visitorBuilder, parser, aceFile);
    }

    private IndexedAceFileDataStore(VisitorBuilder builder, AceParser parser, File aceFile) {
        this.parser = parser;
        this.mementos = builder.mementos;
        this.wholeAssemblyTags = builder.wholeAssemblyTags;
        this.consensusTags = builder.consensusTags;
        this.readTags = builder.readTags;
        this.totalNumberOfReads = builder.totalNumberOfReads;
        this.filter = builder.filter;
        this.aceFile = aceFile;
    }

    private void checkNotYetClosed() {
        if (this.closed) {
            throw new DataStoreClosedException("closed");
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public StreamingIterator<String> idIterator() throws DataStoreException {
        this.checkNotYetClosed();
        return DataStoreStreamingIterator.create(this, this.mementos.keySet().iterator());
    }

    @Override
    public AceContig get(String id) throws DataStoreException {
        if (!this.contains(id)) {
            return null;
        }
        AceFileVisitorCallback.AceFileVisitorMemento memento = this.mementos.get(id);
        SingleAceFileVisitor singleAceFileVisitor = new SingleAceFileVisitor();
        try {
            this.parser.parse(singleAceFileVisitor, memento);
            return singleAceFileVisitor.getContig();
        }
        catch (IOException e) {
            throw new DataStoreException("error re-parsing contig " + id, e);
        }
    }

    @Override
    public boolean contains(String id) throws DataStoreException {
        this.checkNotYetClosed();
        return this.mementos.containsKey(id);
    }

    @Override
    public long getNumberOfRecords() throws DataStoreException {
        this.checkNotYetClosed();
        return this.mementos.size();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public StreamingIterator<AceContig> iterator() throws DataStoreException {
        this.checkNotYetClosed();
        try {
            return DataStoreStreamingIterator.create(this, LargeAceFileDataStore.create(this.aceFile, this.filter).iterator());
        }
        catch (FileNotFoundException e) {
            throw new DataStoreException("error re-parsing ace file for iterator", e);
        }
    }

    @Override
    public StreamingIterator<DataStoreEntry<AceContig>> entryIterator() throws DataStoreException {
        this.checkNotYetClosed();
        try {
            return DataStoreStreamingIterator.create(this, LargeAceFileDataStore.create(this.aceFile, this.filter).entryIterator());
        }
        catch (FileNotFoundException e) {
            throw new DataStoreException("error re-parsing ace file for iterator", e);
        }
    }

    @Override
    public long getNumberOfTotalReads() throws DataStoreException {
        this.checkNotYetClosed();
        return this.totalNumberOfReads;
    }

    @Override
    public StreamingIterator<WholeAssemblyAceTag> getWholeAssemblyTagIterator() throws DataStoreException {
        this.checkNotYetClosed();
        return DataStoreStreamingIterator.create(this, this.wholeAssemblyTags.iterator());
    }

    @Override
    public StreamingIterator<ReadAceTag> getReadTagIterator() throws DataStoreException {
        this.checkNotYetClosed();
        return DataStoreStreamingIterator.create(this, this.readTags.iterator());
    }

    @Override
    public StreamingIterator<ConsensusAceTag> getConsensusTagIterator() throws DataStoreException {
        this.checkNotYetClosed();
        return DataStoreStreamingIterator.create(this, this.consensusTags.iterator());
    }

    public static final class SingleAceFileVisitor
    implements AceFileVisitor {
        private AceContig contig;

        public final AceContig getContig() {
            return this.contig;
        }

        @Override
        public void visitHeader(int numberOfContigs, long totalNumberOfReads) {
        }

        @Override
        public AceContigVisitor visitContig(final AceFileVisitorCallback callback, String contigId, int numberOfBases, int numberOfReads, int numberOfBaseSegments, boolean reverseComplemented) {
            return new AbstractAceContigBuilderVisitor(contigId, numberOfBases, numberOfReads){

                @Override
                protected void visitContig(AceContigBuilder builder) {
                    contig = builder.build();
                    callback.haltParsing();
                }
            };
        }

        @Override
        public void visitReadTag(String id, String type, String creator, long gappedStart, long gappedEnd, Date creationDate, boolean isTransient) {
        }

        @Override
        public AceConsensusTagVisitor visitConsensusTag(String id, String type, String creator, long gappedStart, long gappedEnd, Date creationDate, boolean isTransient) {
            return null;
        }

        @Override
        public void visitWholeAssemblyTag(String type, String creator, Date creationDate, String data) {
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }
    }

    private static class VisitorBuilder
    implements AceFileVisitor {
        private final List<WholeAssemblyAceTag> wholeAssemblyTags = new ArrayList<WholeAssemblyAceTag>();
        private final List<ConsensusAceTag> consensusTags = new ArrayList<ConsensusAceTag>();
        private final List<ReadAceTag> readTags = new ArrayList<ReadAceTag>();
        private final DataStoreFilter filter;
        private long totalNumberOfReads;
        Map<String, AceFileVisitorCallback.AceFileVisitorMemento> mementos;

        public VisitorBuilder(DataStoreFilter filter) {
            this.filter = filter;
        }

        @Override
        public void visitHeader(int numberOfContigs, long totalNumberOfReads) {
            int capacity = MapUtil.computeMinHashMapSizeWithoutRehashing(numberOfContigs);
            this.mementos = new LinkedHashMap<String, AceFileVisitorCallback.AceFileVisitorMemento>(capacity);
        }

        @Override
        public AceContigVisitor visitContig(AceFileVisitorCallback callback, String contigId, int numberOfBases, int numberOfReads, int numberOfBaseSegments, boolean reverseComplemented) {
            if (this.filter.accept(contigId)) {
                this.mementos.put(contigId, callback.createMemento());
                this.totalNumberOfReads += (long)numberOfReads;
            }
            return null;
        }

        @Override
        public void visitReadTag(String id, String type, String creator, long gappedStart, long gappedEnd, Date creationDate, boolean isTransient) {
            this.readTags.add(new ReadAceTag(id, type, creator, creationDate, Range.of(gappedStart, gappedEnd), isTransient));
        }

        @Override
        public AceConsensusTagVisitor visitConsensusTag(String id, String type, String creator, long gappedStart, long gappedEnd, Date creationDate, boolean isTransient) {
            if (this.filter.accept(id)) {
                return new AbstractAceConsensusTagVisitor(id, type, creator, gappedStart, gappedEnd, creationDate, isTransient){

                    @Override
                    protected void visitConsensusTag(ConsensusAceTag consensusTag) {
                        consensusTags.add(consensusTag);
                    }
                };
            }
            return null;
        }

        @Override
        public void visitWholeAssemblyTag(String type, String creator, Date creationDate, String data) {
            this.wholeAssemblyTags.add(new WholeAssemblyAceTag(type, creator, creationDate, data.trim()));
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }
    }
}

