/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jcvi.jillion.assembly.consed.ConsedUtil;
import org.jcvi.jillion.assembly.consed.ace.AbstractAceContigReadVisitor;
import org.jcvi.jillion.assembly.consed.ace.AbstractAceContigVisitor;
import org.jcvi.jillion.assembly.consed.ace.AbstractAceFileVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceContigReadVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceContigVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceFileParser;
import org.jcvi.jillion.assembly.consed.ace.AceFileVisitorCallback;
import org.jcvi.jillion.assembly.consed.ace.AceParser;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdBuilder;
import org.jcvi.jillion.assembly.consed.phd.PhdDataStore;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.util.MapUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;

public final class HighLowAceContigPhdDatastore
implements PhdDataStore {
    private final PhdDataStore delegate;

    public static PhdDataStore create(File aceContigFile) throws IOException {
        return new Builder(aceContigFile).build();
    }

    public static PhdDataStore create(InputStream aceContigFileStream) throws IOException {
        return new Builder(aceContigFileStream).build();
    }

    private HighLowAceContigPhdDatastore(Builder builder) throws IOException {
        FullLengthPhdParser2 visitor = new FullLengthPhdParser2(builder);
        builder.parser.parse(visitor);
        this.delegate = DataStore.of(visitor.getPhds(), PhdDataStore.class);
    }

    @Override
    public StreamingIterator<String> idIterator() throws DataStoreException {
        return this.delegate.idIterator();
    }

    @Override
    public Phd get(String id) throws DataStoreException {
        return (Phd)this.delegate.get(id);
    }

    @Override
    public boolean contains(String id) throws DataStoreException {
        return this.delegate.contains(id);
    }

    @Override
    public long getNumberOfRecords() throws DataStoreException {
        return this.delegate.getNumberOfRecords();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public StreamingIterator<Phd> iterator() throws DataStoreException {
        return this.delegate.iterator();
    }

    @Override
    public StreamingIterator<DataStoreEntry<Phd>> entryIterator() throws DataStoreException {
        return this.delegate.entryIterator();
    }

    public static final class Builder {
        static final int DEFAULT_LOW_QUALITY = 15;
        static final int DEFAULT_HIGH_QUALITY = 30;
        private final AceParser parser;
        private Predicate<String> readFilter = DataStoreFilters.alwaysAccept();
        private Predicate<String> contigFilter = DataStoreFilters.alwaysAccept();
        private PhredQuality lowQuality = PhredQuality.valueOf(15);
        private PhredQuality highQuality = PhredQuality.valueOf(30);
        private boolean oneContigOnly = false;

        public Builder(File aceFile) throws IOException {
            this.parser = AceFileParser.create(aceFile);
        }

        public Builder(InputStream in) throws IOException {
            this.parser = AceFileParser.create(in);
        }

        public Builder lowercaseQuality(int qv) {
            this.lowQuality = PhredQuality.valueOf(qv);
            return this;
        }

        public Builder uppercaseQuality(int qv) {
            this.highQuality = PhredQuality.valueOf(qv);
            return this;
        }

        public Builder readFilter(DataStoreFilter filter) {
            if (filter == null) {
                throw new NullPointerException("readFilter can not be null");
            }
            this.readFilter = filter;
            return this;
        }

        public Builder contigFilter(DataStoreFilter filter) {
            return this.contigFilter((Predicate<String>)filter);
        }

        public Builder contigFilter(Predicate<String> filter) {
            if (filter == null) {
                throw new NullPointerException("contigFilter can not be null");
            }
            this.contigFilter = filter;
            return this;
        }

        public Builder forOneContigOnly() {
            this.oneContigOnly = true;
            return this;
        }

        public PhdDataStore build() throws IOException {
            return new HighLowAceContigPhdDatastore(this);
        }
    }

    private static final class FullLengthPhdParser2
    extends AbstractAceFileVisitor {
        private Map<String, Phd> phds = null;
        private final Predicate<String> contigFilter;
        private final Predicate<String> readFilter;
        private final byte lowQuality;
        private final byte highQuality;
        private final boolean oneContigOnly;

        FullLengthPhdParser2(Builder builder) {
            this.contigFilter = builder.contigFilter;
            this.readFilter = builder.readFilter;
            this.lowQuality = builder.lowQuality.getQualityScore();
            this.highQuality = builder.highQuality.getQualityScore();
            this.oneContigOnly = builder.oneContigOnly;
        }

        public Map<String, Phd> getPhds() {
            return this.phds;
        }

        @Override
        public void visitHeader(int numberOfContigs, long totalNumberOfReads) {
            int mapSize = MapUtil.computeMinHashMapSizeWithoutRehashing(totalNumberOfReads);
            this.phds = new HashMap<String, Phd>(mapSize);
        }

        @Override
        public AceContigVisitor visitContig(final AceFileVisitorCallback callback, String contigId, int numberOfBases, final int numberOfReads, int numberOfBaseSegments, boolean reverseComplemented) {
            if (this.contigFilter.test(contigId)) {
                return new AbstractAceContigVisitor(){
                    int mapSize;
                    final Map<String, Direction> directions;
                    {
                        this.mapSize = MapUtil.computeMinHashMapSizeWithoutRehashing(numberOfReads);
                        this.directions = new HashMap<String, Direction>(this.mapSize);
                    }

                    @Override
                    public void visitAlignedReadInfo(String readId, Direction dir, int gappedStartOffset) {
                        if (readFilter.test(readId)) {
                            this.directions.put(readId, dir);
                        }
                    }

                    @Override
                    public void visitEnd() {
                        if (oneContigOnly) {
                            callback.haltParsing();
                        }
                    }

                    @Override
                    public AceContigReadVisitor visitBeginRead(String readId, int gappedLength) {
                        if (readFilter.test(readId)) {
                            return new IndividualReadPhdBuilderVisitor(readId, gappedLength, this.directions.get(readId));
                        }
                        return null;
                    }
                };
            }
            return null;
        }

        private class IndividualReadPhdBuilderVisitor
        extends AbstractAceContigReadVisitor {
            private final QualitySequenceBuilder highLowQualities;
            private final NucleotideSequenceBuilder sequenceBuilder;
            private final Direction dir;
            private final String readId;

            public IndividualReadPhdBuilderVisitor(String readId, int gappedLength, Direction dir) {
                this.readId = readId;
                this.dir = dir;
                this.highLowQualities = new QualitySequenceBuilder(gappedLength);
                this.sequenceBuilder = new NucleotideSequenceBuilder(gappedLength);
            }

            @Override
            public void visitBasesLine(String mixedCaseBasecalls) {
                this.highLowQualities.append(this.toHighLowQualities(mixedCaseBasecalls));
                this.sequenceBuilder.append(mixedCaseBasecalls);
            }

            private byte[] toHighLowQualities(String bases) {
                String ungappedGappedBases = ConsedUtil.convertAceGapsToContigGaps(bases).replaceAll("-", "");
                char[] chars = ungappedGappedBases.toCharArray();
                byte[] qualities = new byte[chars.length];
                for (int i = 0; i < chars.length; ++i) {
                    qualities[i] = Character.isUpperCase(chars[i]) ? FullLengthPhdParser2.this.highQuality : FullLengthPhdParser2.this.lowQuality;
                }
                return qualities;
            }

            @Override
            public void visitEnd() {
                this.sequenceBuilder.ungap();
                if (this.dir == Direction.REVERSE) {
                    this.sequenceBuilder.reverseComplement();
                    this.highLowQualities.reverse();
                }
                Phd phd = new PhdBuilder(this.readId, this.sequenceBuilder.build(), this.highLowQualities.build()).fakePeaks().build();
                FullLengthPhdParser2.this.phds.put(this.readId, phd);
            }
        }
    }
}

