/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jcvi.jillion.assembly.consed.ace.AbstractAceConsensusTagVisitor;
import org.jcvi.jillion.assembly.consed.ace.AbstractAceContigBuilderVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceConsensusTagVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceContig;
import org.jcvi.jillion.assembly.consed.ace.AceContigBuilder;
import org.jcvi.jillion.assembly.consed.ace.AceContigVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceFileDataStore;
import org.jcvi.jillion.assembly.consed.ace.AceFileParser;
import org.jcvi.jillion.assembly.consed.ace.AceFileVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceFileVisitorCallback;
import org.jcvi.jillion.assembly.consed.ace.AceParser;
import org.jcvi.jillion.assembly.consed.ace.ConsensusAceTag;
import org.jcvi.jillion.assembly.consed.ace.ReadAceTag;
import org.jcvi.jillion.assembly.consed.ace.WholeAssemblyAceTag;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;

final class DefaultAceFileDataStore
implements AceFileDataStore {
    private final DataStore<AceContig> delegate;
    private final long totalNumberOfReads;
    private final List<WholeAssemblyAceTag> wholeAssemblyTags;
    private final List<ConsensusAceTag> consensusTags;
    private final List<ReadAceTag> readTags;

    public static AceFileDataStore create(InputStream aceFileStream) throws IOException {
        return DefaultAceFileDataStore.create(aceFileStream, DataStoreFilters.alwaysAccept());
    }

    public static AceFileDataStore create(InputStream aceFileStream, DataStoreFilter filter) throws IOException {
        Visitor builder = new Visitor(filter);
        AceParser parser = AceFileParser.create(aceFileStream);
        parser.parse(builder);
        return new DefaultAceFileDataStore(builder);
    }

    public static AceFileDataStore create(File aceFile) throws IOException {
        return DefaultAceFileDataStore.create(aceFile, DataStoreFilters.alwaysAccept());
    }

    public static AceFileDataStore create(File aceFile, DataStoreFilter filter) throws IOException {
        Visitor builder = new Visitor(filter);
        AceParser parser = AceFileParser.create(aceFile);
        parser.parse(builder);
        return new DefaultAceFileDataStore(builder);
    }

    private DefaultAceFileDataStore(Visitor builder) {
        if (!builder.completed) {
            throw new IllegalStateException("did not completely parse ace file");
        }
        this.delegate = DataStore.of(builder.map);
        this.totalNumberOfReads = builder.totalNumberOfReads;
        this.wholeAssemblyTags = builder.wholeAssemblyTags;
        this.consensusTags = builder.consensusTags;
        this.readTags = builder.readTags;
    }

    @Override
    public StreamingIterator<String> idIterator() throws DataStoreException {
        return this.delegate.idIterator();
    }

    @Override
    public AceContig get(String id) throws DataStoreException {
        return this.delegate.get(id);
    }

    @Override
    public StreamingIterator<DataStoreEntry<AceContig>> entryIterator() throws DataStoreException {
        return this.delegate.entryIterator();
    }

    @Override
    public boolean contains(String id) throws DataStoreException {
        return this.delegate.contains(id);
    }

    @Override
    public long getNumberOfRecords() throws DataStoreException {
        return this.delegate.getNumberOfRecords();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public StreamingIterator<AceContig> iterator() throws DataStoreException {
        return this.delegate.iterator();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public long getNumberOfTotalReads() {
        if (this.isClosed()) {
            throw new DataStoreClosedException("closed");
        }
        return this.totalNumberOfReads;
    }

    @Override
    public StreamingIterator<WholeAssemblyAceTag> getWholeAssemblyTagIterator() throws DataStoreException {
        return DataStoreStreamingIterator.create(this, this.wholeAssemblyTags.iterator());
    }

    @Override
    public StreamingIterator<ReadAceTag> getReadTagIterator() throws DataStoreException {
        return DataStoreStreamingIterator.create(this, this.readTags.iterator());
    }

    @Override
    public StreamingIterator<ConsensusAceTag> getConsensusTagIterator() throws DataStoreException {
        return DataStoreStreamingIterator.create(this, this.consensusTags.iterator());
    }

    private static final class Visitor
    implements AceFileVisitor {
        private final DataStoreFilter filter;
        private Map<String, AceContig> map;
        private long totalNumberOfReads;
        private final List<WholeAssemblyAceTag> wholeAssemblyTags = new ArrayList<WholeAssemblyAceTag>();
        private final List<ConsensusAceTag> consensusTags = new ArrayList<ConsensusAceTag>();
        private final List<ReadAceTag> readTags = new ArrayList<ReadAceTag>();
        private boolean completed = false;

        public Visitor(DataStoreFilter filter) {
            this.filter = filter;
        }

        @Override
        public void visitHeader(int numberOfContigs, long totalNumberOfReads) {
            this.map = new LinkedHashMap<String, AceContig>(numberOfContigs);
        }

        @Override
        public AceContigVisitor visitContig(AceFileVisitorCallback callback, final String contigId, int numberOfBases, int numberOfReads, int numberOfBaseSegments, boolean reverseComplemented) {
            if (this.filter.accept(contigId)) {
                return new AbstractAceContigBuilderVisitor(contigId, numberOfBases, numberOfReads){

                    @Override
                    protected void visitContig(AceContigBuilder builder) {
                        totalNumberOfReads = totalNumberOfReads + (long)builder.numberOfReads();
                        map.put(contigId, builder.build());
                    }
                };
            }
            return null;
        }

        @Override
        public void visitReadTag(String id, String type, String creator, long gappedStart, long gappedEnd, Date creationDate, boolean isTransient) {
            this.readTags.add(new ReadAceTag(id, type, creator, creationDate, Range.of(gappedStart, gappedEnd), isTransient));
        }

        @Override
        public AceConsensusTagVisitor visitConsensusTag(String id, String type, String creator, long gappedStart, long gappedEnd, Date creationDate, boolean isTransient) {
            if (this.filter.accept(id)) {
                return new AbstractAceConsensusTagVisitor(id, type, creator, gappedStart, gappedEnd, creationDate, isTransient){

                    @Override
                    protected void visitConsensusTag(ConsensusAceTag consensusTag) {
                        consensusTags.add(consensusTag);
                    }
                };
            }
            return null;
        }

        @Override
        public void visitWholeAssemblyTag(String type, String creator, Date creationDate, String data) {
            this.wholeAssemblyTags.add(new WholeAssemblyAceTag(type, creator, creationDate, data.trim()));
        }

        @Override
        public void visitEnd() {
            this.completed = true;
        }

        @Override
        public void halted() {
        }
    }
}

