/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import java.util.List;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.AssembledReadBuilder;
import org.jcvi.jillion.assembly.ReadInfo;
import org.jcvi.jillion.assembly.consed.ace.AceAssembledRead;
import org.jcvi.jillion.assembly.consed.ace.AceAssembledReadBuilder;
import org.jcvi.jillion.assembly.consed.ace.AceContigBuilder;
import org.jcvi.jillion.assembly.consed.ace.PhdInfo;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.residue.nt.ReferenceMappedNucleotideSequence;
import org.jcvi.jillion.internal.assembly.DefaultAssembledRead;

final class DefaultAceAssembledRead
implements AceAssembledRead {
    private final PhdInfo phdInfo;
    private final AssembledRead placedRead;

    public static AceAssembledReadBuilder createBuilder(String readId, NucleotideSequence validBases, int offset, Direction dir, Range clearRange, PhdInfo phdInfo, int ungappedFullLength, AceContigBuilder callback) {
        return new Builder(readId, validBases, offset, dir, clearRange, phdInfo, ungappedFullLength, callback);
    }

    private DefaultAceAssembledRead(AssembledRead placedRead, PhdInfo phdInfo) {
        this.placedRead = placedRead;
        this.phdInfo = phdInfo;
    }

    @Override
    public ReadInfo getReadInfo() {
        return this.placedRead.getReadInfo();
    }

    @Override
    public PhdInfo getPhdInfo() {
        return this.phdInfo;
    }

    public String toString() {
        return "DefaultAcePlacedRead [placedRead=" + this.placedRead + ", phdInfo=" + this.phdInfo + "]";
    }

    @Override
    public String getId() {
        return this.placedRead.getId();
    }

    @Override
    public ReferenceMappedNucleotideSequence getNucleotideSequence() {
        return this.placedRead.getNucleotideSequence();
    }

    @Override
    public long getGappedLength() {
        return this.placedRead.getGappedLength();
    }

    @Override
    public long getGappedStartOffset() {
        return this.placedRead.getGappedStartOffset();
    }

    @Override
    public long getGappedEndOffset() {
        return this.placedRead.getGappedEndOffset();
    }

    @Override
    public Range getGappedContigRange() {
        return this.placedRead.getGappedContigRange();
    }

    @Override
    public Range asRange() {
        return this.placedRead.asRange();
    }

    @Override
    public Direction getDirection() {
        return this.placedRead.getDirection();
    }

    @Override
    public long toGappedValidRangeOffset(long referenceIndex) {
        return this.placedRead.toGappedValidRangeOffset(referenceIndex);
    }

    @Override
    public long toReferenceOffset(long validRangeIndex) {
        return this.placedRead.toReferenceOffset(validRangeIndex);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.phdInfo == null ? 0 : this.phdInfo.hashCode());
        result = 31 * result + (this.placedRead == null ? 0 : this.placedRead.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultAceAssembledRead other = (DefaultAceAssembledRead)obj;
        if (this.phdInfo == null ? other.phdInfo != null : !this.phdInfo.equals(other.phdInfo)) {
            return false;
        }
        return !(this.placedRead == null ? other.placedRead != null : !this.placedRead.equals(other.placedRead));
    }

    protected static final class IllegalReAbacus
    extends IllegalArgumentException {
        private static final long serialVersionUID = -8272559886165301526L;

        public IllegalReAbacus(List<Nucleotide> oldUngappedBasecalls, List<Nucleotide> newUngappedBasecalls) {
            super(String.format("reAbacusing must retain same ungapped basecalls! '%s' vs '%s'", new NucleotideSequenceBuilder(oldUngappedBasecalls).toString(), new NucleotideSequenceBuilder(newUngappedBasecalls).toString()));
        }
    }

    static final class Builder
    implements AceAssembledReadBuilder {
        private final PhdInfo phdInfo;
        private final AssembledReadBuilder<AssembledRead> delegateBuilder;
        private AceContigBuilder contigBuilder;

        public Builder(String readId, NucleotideSequence validBases, int offset, Direction dir, Range clearRange, PhdInfo phdInfo, int ungappedFullLength, AceContigBuilder callback) {
            this.delegateBuilder = DefaultAssembledRead.createBuilder(readId, validBases, offset, dir, clearRange, ungappedFullLength);
            this.phdInfo = phdInfo;
            this.contigBuilder = callback;
        }

        private Builder(Builder copy) {
            this.delegateBuilder = copy.delegateBuilder.copy();
            this.phdInfo = copy.phdInfo;
        }

        public AceAssembledReadBuilder trim(Range trimRange) {
            this.delegateBuilder.trim(trimRange);
            this.fireContigSizeUpdate();
            return this;
        }

        @Override
        public AceAssembledReadBuilder copy() {
            return new Builder(this);
        }

        public void setParentContigBuilder(AceContigBuilder contigBuilder) {
            this.contigBuilder = contigBuilder;
        }

        private void fireContigSizeUpdate() {
            if (this.contigBuilder != null) {
                this.contigBuilder.updatedReadRange(this.getId(), this.getBegin(), this.getEnd());
            }
        }

        @Override
        public long getBegin() {
            return this.delegateBuilder.getBegin();
        }

        @Override
        public String getId() {
            return this.delegateBuilder.getId();
        }

        public Builder setStartOffset(int newOffset) {
            this.delegateBuilder.setStartOffset(newOffset);
            this.fireContigSizeUpdate();
            return this;
        }

        public Builder shift(int numberOfBases) {
            this.delegateBuilder.shift(numberOfBases);
            this.fireContigSizeUpdate();
            return this;
        }

        @Override
        public Range getClearRange() {
            return this.delegateBuilder.getClearRange();
        }

        @Override
        public PhdInfo getPhdInfo() {
            return this.phdInfo;
        }

        @Override
        public Direction getDirection() {
            return this.delegateBuilder.getDirection();
        }

        @Override
        public int getUngappedFullLength() {
            return this.delegateBuilder.getUngappedFullLength();
        }

        @Override
        public DefaultAceAssembledRead build(NucleotideSequence consensus) {
            return new DefaultAceAssembledRead(this.delegateBuilder.build(consensus), this.phdInfo);
        }

        public Builder reAbacus(Range gappedValidRangeToChange, NucleotideSequence newBasecalls) {
            this.delegateBuilder.reAbacus(gappedValidRangeToChange, newBasecalls);
            this.fireContigSizeUpdate();
            return this;
        }

        @Override
        public synchronized long getLength() {
            return this.delegateBuilder.getLength();
        }

        @Override
        public long getEnd() {
            return this.delegateBuilder.getEnd();
        }

        @Override
        public Range asRange() {
            return this.delegateBuilder.asRange();
        }

        @Override
        public synchronized NucleotideSequence getCurrentNucleotideSequence() {
            return this.delegateBuilder.getCurrentNucleotideSequence();
        }

        public AceAssembledReadBuilder append(Nucleotide base) {
            this.delegateBuilder.append(base);
            this.fireContigSizeUpdate();
            return this;
        }

        public AceAssembledReadBuilder append(Iterable<Nucleotide> sequence) {
            this.delegateBuilder.append(sequence);
            this.fireContigSizeUpdate();
            return this;
        }

        public AceAssembledReadBuilder append(String sequence) {
            this.delegateBuilder.append(sequence);
            this.fireContigSizeUpdate();
            return this;
        }

        public AceAssembledReadBuilder insert(int offset, String sequence) {
            this.delegateBuilder.insert(offset, sequence);
            this.fireContigSizeUpdate();
            return this;
        }

        public AceAssembledReadBuilder replace(int offset, Nucleotide replacement) {
            this.delegateBuilder.replace(offset, replacement);
            this.fireContigSizeUpdate();
            return this;
        }

        public AceAssembledReadBuilder delete(Range range) {
            this.delegateBuilder.delete(range);
            this.fireContigSizeUpdate();
            return this;
        }

        @Override
        public int getNumGaps() {
            return this.delegateBuilder.getNumGaps();
        }

        @Override
        public int getNumNs() {
            return this.delegateBuilder.getNumNs();
        }

        @Override
        public int getNumAmbiguities() {
            return this.delegateBuilder.getNumAmbiguities();
        }

        public AceAssembledReadBuilder prepend(String sequence) {
            this.delegateBuilder.prepend(sequence);
            this.fireContigSizeUpdate();
            return this;
        }

        public AceAssembledReadBuilder insert(int offset, Iterable<Nucleotide> sequence) {
            this.delegateBuilder.insert(offset, sequence);
            this.fireContigSizeUpdate();
            return this;
        }

        public AceAssembledReadBuilder insert(int offset, Nucleotide base) {
            this.delegateBuilder.insert(offset, base);
            this.fireContigSizeUpdate();
            return this;
        }

        public AceAssembledReadBuilder prepend(Iterable<Nucleotide> sequence) {
            this.delegateBuilder.prepend(sequence);
            this.fireContigSizeUpdate();
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.delegateBuilder == null ? 0 : this.delegateBuilder.hashCode());
            result = 31 * result + (this.phdInfo == null ? 0 : this.phdInfo.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)obj;
            if (this.delegateBuilder == null ? other.delegateBuilder != null : !this.delegateBuilder.equals(other.delegateBuilder)) {
                return false;
            }
            return !(this.phdInfo == null ? other.phdInfo != null : !this.phdInfo.equals(other.phdInfo));
        }
    }
}

