/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jcvi.jillion.assembly.consed.ace.AbstractDefaultPlacedAceTag;
import org.jcvi.jillion.assembly.consed.ace.ConsensusAceTag;
import org.jcvi.jillion.core.Rangeable;
import org.jcvi.jillion.core.util.Builder;

public final class ConsensusAceTagBuilder
implements Builder<ConsensusAceTag> {
    private final List<String> comments = new ArrayList<String>();
    private final String id;
    private final Rangeable location;
    private final boolean isTransient;
    private final String type;
    private final String creator;
    private final Date creationDate;
    private final StringBuilder dataBuilder = new StringBuilder();

    public ConsensusAceTagBuilder(String id, String type, String creator, Date creationDate, Rangeable location, boolean isTransient) {
        this.id = id;
        this.location = location;
        this.isTransient = isTransient;
        this.type = type;
        this.creator = creator;
        this.creationDate = new Date(creationDate.getTime());
    }

    public ConsensusAceTagBuilder appendData(String data) {
        this.dataBuilder.append(data);
        return this;
    }

    public ConsensusAceTagBuilder addComment(String comment) {
        this.comments.add(comment);
        return this;
    }

    @Override
    public ConsensusAceTag build() {
        return new DefaultConsensusAceTagBuilderImpl(this.id, this.type, this.creator, this.creationDate, this.location, this.dataBuilder.toString(), this.comments, this.isTransient);
    }

    private static final class DefaultConsensusAceTagBuilderImpl
    extends AbstractDefaultPlacedAceTag
    implements ConsensusAceTag {
        private final List<String> comments;

        private DefaultConsensusAceTagBuilderImpl(String id, String type, String creator, Date creationDate, Rangeable location, String data, List<String> comments, boolean isTransient) {
            super(id, type, creator, creationDate, location, data, isTransient);
            this.comments = comments;
        }

        @Override
        public List<String> getComments() {
            return this.comments;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.comments == null ? 0 : this.comments.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConsensusAceTag)) {
                return false;
            }
            ConsensusAceTag other = (ConsensusAceTag)obj;
            if (!this.getId().equals(other.getId())) {
                return false;
            }
            if (this.isTransient() != other.isTransient()) {
                return false;
            }
            if (this.asRange() == null ? other.asRange() != null : !this.asRange().equals(other.asRange())) {
                return false;
            }
            return !(this.comments == null ? other.getComments() != null : !this.comments.equals(other.getComments()));
        }

        public String toString() {
            return "DefaultConsensusAceTag [comments=" + this.comments + ", range()=" + this.asRange() + ", getId()=" + this.getId() + ", isTransient()=" + this.isTransient() + ", getCreationDate()=" + this.getCreationDate() + ", getCreator()=" + this.getCreator() + ", getData()=" + this.getData() + ", getType()=" + this.getType() + "]";
        }
    }
}

