/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.AssemblyUtil;
import org.jcvi.jillion.assembly.Contig;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.qual.QualitySequenceDataStore;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.util.JillionUtil;

final class ConsedConsensusQualityComputer {
    private static final int MAX_CONSED_COMPUTED_QUALITY = 90;
    private static final int BONUS_VALUE = 5;
    private static final int NUMBER_OF_NON_GAPS_IN_WINDOW = 2;

    private ConsedConsensusQualityComputer() {
    }

    public static QualitySequence computeConsensusQualities(Contig<? extends AssembledRead> contig, QualitySequenceDataStore readQualities) throws DataStoreException {
        if (contig == null) {
            throw new NullPointerException("contig can not be null");
        }
        if (readQualities == null) {
            throw new NullPointerException("read quality datastore can not be null");
        }
        return ConsedConsensusQualityComputer.computeConsensusQualities(contig.getConsensusSequence(), contig.getReadIterator(), readQualities);
    }

    public static QualitySequence computeConsensusQualities(NucleotideSequence consensusSequence, Iterable<? extends AssembledRead> reads, QualitySequenceDataStore readQualities) throws DataStoreException {
        if (consensusSequence == null) {
            throw new NullPointerException("consensus can not be null");
        }
        if (readQualities == null) {
            throw new NullPointerException("read quality datastore can not be null");
        }
        return ConsedConsensusQualityComputer.computeConsensusQualities(consensusSequence, IteratorUtil.createStreamingIterator(reads.iterator()), readQualities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QualitySequence computeConsensusQualities(NucleotideSequence consensusSequence, StreamingIterator<? extends AssembledRead> iter, QualitySequenceDataStore readQualities) throws DataStoreException {
        try {
            int[] consensusGapsArray = ConsedConsensusQualityComputer.toIntArray(consensusSequence.getGapOffsets());
            int consensusLength = (int)consensusSequence.getLength();
            ArrayList<List<QualityPosition>> forwardQualitiesTowardsConsensus = new ArrayList<List<QualityPosition>>((int)consensusSequence.getLength());
            ArrayList<List<QualityPosition>> reverseQualitiesTowardsConsensus = new ArrayList<List<QualityPosition>>((int)consensusSequence.getLength());
            for (int i = 0; i < consensusLength; ++i) {
                forwardQualitiesTowardsConsensus.add(new ArrayList());
                reverseQualitiesTowardsConsensus.add(new ArrayList());
            }
            while (iter.hasNext()) {
                AssembledRead read = iter.next();
                long start = read.getGappedStartOffset();
                int[] differenceArray = ConsedConsensusQualityComputer.toIntArray(read.getNucleotideSequence().getDifferenceMap().keySet());
                int[] readGaps = ConsedConsensusQualityComputer.toIntArray(read.getNucleotideSequence().getGapOffsets());
                Range validRange = read.getReadInfo().getValidRange();
                Direction dir = read.getDirection();
                if (dir == Direction.REVERSE) {
                    validRange = AssemblyUtil.reverseComplementValidRange(validRange, read.getReadInfo().getUngappedFullLength());
                }
                QualitySequence validQualities = AssemblyUtil.getUngappedComplementedValidRangeQualities(read, (QualitySequence)readQualities.get(read.getId()));
                Iterator qualIter = validQualities.iterator();
                int i = 0;
                while (qualIter.hasNext()) {
                    if (ConsedConsensusQualityComputer.notAGap(readGaps, i)) {
                        PhredQuality qual = (PhredQuality)qualIter.next();
                        int consensusOffset = (int)((long)i + start);
                        if (ConsedConsensusQualityComputer.notAGap(consensusGapsArray, consensusOffset) && ConsedConsensusQualityComputer.readMatchesWindow(consensusGapsArray, consensusLength, read, start, differenceArray, i)) {
                            ConsedConsensusQualityComputer.addQualityToConsensusConsideration(forwardQualitiesTowardsConsensus, reverseQualitiesTowardsConsensus, start, dir, qual, consensusOffset);
                        }
                    }
                    ++i;
                }
            }
            QualitySequenceBuilder consensusQualitiesBuilder = new QualitySequenceBuilder(consensusLength);
            for (int i = 0; i < consensusLength; ++i) {
                consensusQualitiesBuilder.append(ConsedConsensusQualityComputer.computeConsensusQuality(forwardQualitiesTowardsConsensus, reverseQualitiesTowardsConsensus, i));
            }
            ConsedConsensusQualityComputer.removeConsensusGaps(consensusQualitiesBuilder, consensusGapsArray);
            QualitySequence qualitySequence = consensusQualitiesBuilder.build();
            return qualitySequence;
        }
        finally {
            IOUtil.closeAndIgnoreErrors(iter);
        }
    }

    private static void addQualityToConsensusConsideration(List<List<QualityPosition>> forwardQualitiesTowardsConsensus, List<List<QualityPosition>> reverseQualitiesTowardsConsensus, long start, Direction dir, PhredQuality qual, int consensusOffset) {
        QualityPosition position = new QualityPosition(qual, start);
        if (dir == Direction.FORWARD) {
            forwardQualitiesTowardsConsensus.get(consensusOffset).add(position);
        } else {
            reverseQualitiesTowardsConsensus.get(consensusOffset).add(position);
        }
    }

    private static void removeConsensusGaps(QualitySequenceBuilder consensusQualitiesBuilder, int[] consensusGapsArray) {
        for (int i = consensusGapsArray.length - 1; i >= 0; --i) {
            consensusQualitiesBuilder.delete(Range.of(consensusGapsArray[i]));
        }
    }

    private static boolean notDifferentThan(int[] differenceArray, int offset) {
        return ConsedConsensusQualityComputer.notAGap(differenceArray, offset);
    }

    private static boolean notAGap(int[] consensusGapsArray, int consensusOffset) {
        return Arrays.binarySearch(consensusGapsArray, consensusOffset) < 0;
    }

    private static int computeConsensusQuality(List<List<QualityPosition>> forwardQualitiesTowardsConsensus, List<List<QualityPosition>> reverseQualitiesTowardsConsensus, int i) {
        List<QualityPosition> forwards = forwardQualitiesTowardsConsensus.get(i);
        Collections.sort(forwards);
        List<QualityPosition> reverses = reverseQualitiesTowardsConsensus.get(i);
        Collections.sort(reverses);
        byte highestForwardQuality = forwards.isEmpty() ? (byte)0 : forwards.get(forwards.size() - 1).quality;
        byte highestReverseQuality = reverses.isEmpty() ? (byte)0 : reverses.get(reverses.size() - 1).quality;
        int sum = highestForwardQuality + highestReverseQuality;
        if (ConsedConsensusQualityComputer.hasBonusCoverage(forwards) || ConsedConsensusQualityComputer.hasBonusCoverage(reverses)) {
            sum += 5;
        }
        return Math.min(sum, 90);
    }

    public static boolean readMatchesWindow(int[] consensusGapsArray, int consensusLength, AssembledRead read, long start, int[] differenceArray, int i) {
        boolean windowMatches = ConsedConsensusQualityComputer.notDifferentThan(differenceArray, i);
        int windowLeftSize = ConsedConsensusQualityComputer.computeWindowLeft(consensusGapsArray, (long)i + start);
        for (int j = i - windowLeftSize; windowMatches && j >= 0 && j < i; ++j) {
            windowMatches = ConsedConsensusQualityComputer.notDifferentThan(differenceArray, j);
        }
        if (windowMatches) {
            int windowRightSize = ConsedConsensusQualityComputer.computeWindowRight(consensusGapsArray, (long)i + start, consensusLength);
            for (int j = i + 1; windowMatches && j <= i + windowRightSize && (long)j < read.getGappedLength(); ++j) {
                windowMatches = ConsedConsensusQualityComputer.notDifferentThan(differenceArray, j);
            }
        }
        return windowMatches;
    }

    private static int[] toIntArray(Collection<Integer> ints) {
        int[] array = new int[ints.size()];
        Iterator<Integer> iter = ints.iterator();
        int i = 0;
        while (iter.hasNext()) {
            array[i] = iter.next();
            ++i;
        }
        return array;
    }

    private static int computeWindowLeft(int[] consensusGapsArray, long startPosition) {
        int numberOfBasesInWindow = 0;
        for (int position = (int)startPosition - 1; position >= 0 && numberOfBasesInWindow < 2; --position) {
            if (!ConsedConsensusQualityComputer.notAGap(consensusGapsArray, position)) continue;
            ++numberOfBasesInWindow;
        }
        return numberOfBasesInWindow;
    }

    private static int computeWindowRight(int[] consensusGapsArray, long startPosition, int consensusLength) {
        int numberOfBasesInWindow = 0;
        int numberOfNonGapsInWindow = 0;
        for (int position = (int)startPosition + 1; position < consensusLength && numberOfNonGapsInWindow < 2; ++position) {
            if (ConsedConsensusQualityComputer.notAGap(consensusGapsArray, position)) {
                ++numberOfNonGapsInWindow;
            }
            ++numberOfBasesInWindow;
        }
        return numberOfBasesInWindow;
    }

    private static boolean hasBonusCoverage(List<QualityPosition> forwards) {
        if (forwards.isEmpty()) {
            return false;
        }
        Iterator<QualityPosition> iter = forwards.iterator();
        long firstOffset = iter.next().startOffset;
        while (iter.hasNext()) {
            long nextOffset = iter.next().startOffset;
            if (firstOffset == nextOffset) continue;
            return true;
        }
        return false;
    }

    private static final class QualityPosition
    implements Comparable<QualityPosition> {
        private final byte quality;
        private final long startOffset;

        public QualityPosition(PhredQuality quality, long startOffset) {
            this.quality = quality.getQualityScore();
            this.startOffset = startOffset;
        }

        @Override
        public int compareTo(QualityPosition other) {
            return JillionUtil.compare(this.quality, other.quality);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.quality;
            result = 31 * result + (int)(this.startOffset ^ this.startOffset >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof QualityPosition)) {
                return false;
            }
            QualityPosition other = (QualityPosition)obj;
            if (this.quality != other.quality) {
                return false;
            }
            return this.startOffset == other.startOffset;
        }
    }
}

