/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.consed.ace.AceAssembledRead;
import org.jcvi.jillion.assembly.consed.ace.AceBaseSegment;
import org.jcvi.jillion.assembly.consed.ace.AceContig;
import org.jcvi.jillion.assembly.consed.ace.DefaultAceBaseSegment;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.ReferenceMappedNucleotideSequence;
import org.jcvi.jillion.core.util.MapValueComparator;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.PeekableIterator;
import org.jcvi.jillion.core.util.iter.PeekableStreamingIterator;

final class BaseSegmentUtil {
    private BaseSegmentUtil() {
    }

    public static List<AceBaseSegment> computeBestSegmentsFor(AceContig contig) {
        ArrayList<AceBaseSegment> baseSegments = new ArrayList<AceBaseSegment>();
        NucleotideSequence consensus = contig.getConsensusSequence();
        PeekableIterator<Nucleotide> consensusIterator = IteratorUtil.createPeekableIterator(consensus.iterator());
        PeekableStreamingIterator<AceAssembledRead> readIter = IteratorUtil.createPeekableStreamingIterator(contig.getReadIterator());
        SortedMap<String, Range> sortedReadRanges = BaseSegmentUtil.createSortedRangeMapFor(readIter, 0L);
        Nucleotide consensusBase = (Nucleotide)consensusIterator.peek();
        CurrentMatchingRead currentMatchingRead = BaseSegmentUtil.findFirstReadThatMatchesConsensus(contig, sortedReadRanges, consensusBase);
        long consensusOffsetToBeCovered = BaseSegmentUtil.computeNextBaseSegment(baseSegments, 0L, consensusIterator, currentMatchingRead);
        while (consensusIterator.hasNext()) {
            consensusBase = consensusIterator.peek();
            sortedReadRanges = BaseSegmentUtil.createSortedRangeMapFor(readIter, consensusOffsetToBeCovered, sortedReadRanges);
            currentMatchingRead = BaseSegmentUtil.findReadThatMatchesConsensus(contig, sortedReadRanges, consensusBase, consensusOffsetToBeCovered);
            consensusOffsetToBeCovered = BaseSegmentUtil.computeNextBaseSegment(baseSegments, consensusOffsetToBeCovered, consensusIterator, currentMatchingRead);
        }
        return baseSegments;
    }

    private static long computeNextBaseSegment(List<AceBaseSegment> bestSegments, long offset, PeekableIterator<Nucleotide> consensusIterator, CurrentMatchingRead currentMatchingRead) {
        boolean stillMatches = true;
        long consensusOffsetToBeCovered = offset;
        while (consensusIterator.hasNext() && currentMatchingRead.getBaseIterator().hasNext() && stillMatches) {
            Nucleotide readBase;
            Nucleotide consensusBase = consensusIterator.peek();
            stillMatches = consensusBase.equals(readBase = currentMatchingRead.getBaseIterator().next());
            if (!stillMatches) continue;
            ++consensusOffsetToBeCovered;
            consensusIterator.next();
        }
        bestSegments.add(new DefaultAceBaseSegment(currentMatchingRead.getRead().getId(), Range.of(currentMatchingRead.getStartMatchOffset(), consensusOffsetToBeCovered - 1L)));
        return consensusOffsetToBeCovered;
    }

    private static SortedMap<String, Range> createSortedRangeMapFor(PeekableStreamingIterator<AceAssembledRead> readIter, long offset, SortedMap<String, Range> sortedReadRanges) {
        Iterator<Map.Entry<String, Range>> iter = sortedReadRanges.entrySet().iterator();
        LinkedHashMap<String, Range> map = new LinkedHashMap<String, Range>();
        while (iter.hasNext()) {
            Map.Entry<String, Range> entry = iter.next();
            if (entry.getValue().getEnd() < offset) {
                iter.remove();
                continue;
            }
            map.put(entry.getKey(), entry.getValue());
        }
        boolean done = false;
        while (readIter.hasNext() && !done) {
            AceAssembledRead currentRead = (AceAssembledRead)readIter.peek();
            if (currentRead.getGappedStartOffset() <= offset) {
                readIter.next();
                map.put(currentRead.getId(), currentRead.asRange());
                continue;
            }
            done = true;
        }
        return MapValueComparator.sortAscending(map, Range.Comparators.DEPARTURE);
    }

    private static CurrentMatchingRead findFirstReadThatMatchesConsensus(AceContig contig, SortedMap<String, Range> sortedReadRanges, Nucleotide consensusBase) {
        return BaseSegmentUtil.findReadThatMatchesConsensus(contig, sortedReadRanges, consensusBase, 0L);
    }

    private static CurrentMatchingRead findReadThatMatchesConsensus(AceContig contig, SortedMap<String, Range> sortedReadRanges, Nucleotide consensusBase, long consensusOffset) {
        Iterator<String> idIterator = sortedReadRanges.keySet().iterator();
        boolean foundMatch = false;
        AssembledRead currentBestRead = null;
        while (!foundMatch && idIterator.hasNext()) {
            Nucleotide base;
            String id = idIterator.next();
            AceAssembledRead read = (AceAssembledRead)contig.getRead(id);
            ReferenceMappedNucleotideSequence readSequence = read.getNucleotideSequence();
            long gappedStartOffset = read.getGappedStartOffset();
            long readOffset = consensusOffset - gappedStartOffset;
            if (readSequence.getLength() <= readOffset || !(base = (Nucleotide)readSequence.get(readOffset)).equals(consensusBase)) continue;
            foundMatch = true;
            currentBestRead = read;
        }
        if (currentBestRead == null) {
            throw new NoReadMatchesConsensusException(consensusBase, consensusOffset);
        }
        Range readRange = Range.of(consensusOffset - currentBestRead.getGappedStartOffset(), currentBestRead.getGappedEndOffset() - currentBestRead.getGappedStartOffset());
        return new CurrentMatchingRead((AceAssembledRead)currentBestRead, currentBestRead.getNucleotideSequence().iterator(readRange), consensusOffset);
    }

    private static SortedMap<String, Range> createSortedRangeMapFor(PeekableStreamingIterator<AceAssembledRead> readIter, long offset) {
        return BaseSegmentUtil.createSortedRangeMapFor(readIter, offset, new TreeMap<String, Range>());
    }

    private static class CurrentMatchingRead {
        private final AceAssembledRead read;
        private final Iterator<Nucleotide> baseIterator;
        private final long startMatchOffset;

        public CurrentMatchingRead(AceAssembledRead read, Iterator<Nucleotide> baseIterator, long startMatchOffset) {
            this.read = read;
            this.baseIterator = baseIterator;
            this.startMatchOffset = startMatchOffset;
        }

        protected final AceAssembledRead getRead() {
            return this.read;
        }

        protected final Iterator<Nucleotide> getBaseIterator() {
            return this.baseIterator;
        }

        protected final long getStartMatchOffset() {
            return this.startMatchOffset;
        }
    }

    public static class NoReadMatchesConsensusException
    extends IllegalStateException {
        private static final long serialVersionUID = 2738190645917425718L;

        NoReadMatchesConsensusException(Nucleotide consensusBase, long offset) {
            super(String.format("consensus ='%s' at offset %d", consensusBase, offset));
        }
    }
}

