/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import org.jcvi.jillion.core.Direction;

final class AlignedReadInfo {
    private static final Direction[] DIR_VALUES = Direction.values();
    private final byte dirOrdinal;
    private final int startOffset;

    public AlignedReadInfo(int startOffset, Direction dir) {
        if (dir == null) {
            throw new NullPointerException("direction can not be null");
        }
        this.startOffset = startOffset;
        this.dirOrdinal = (byte)dir.ordinal();
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public Direction getDirection() {
        return DIR_VALUES[this.dirOrdinal];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dirOrdinal;
        result = 31 * result + this.startOffset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlignedReadInfo other = (AlignedReadInfo)obj;
        if (this.dirOrdinal != other.dirOrdinal) {
            return false;
        }
        return this.startOffset == other.startOffset;
    }

    public String toString() {
        return "AlignedReadInfo [dir=" + (Object)((Object)this.getDirection()) + ", startOffset=" + this.startOffset + "]";
    }
}

