/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jcvi.jillion.assembly.consed.ace.AbstractAceFileWriter;
import org.jcvi.jillion.assembly.consed.ace.AceContig;
import org.jcvi.jillion.assembly.consed.ace.AceFileUtil;
import org.jcvi.jillion.assembly.consed.ace.AceFileWriter;
import org.jcvi.jillion.assembly.consed.ace.ConsensusAceTag;
import org.jcvi.jillion.assembly.consed.ace.ReadAceTag;
import org.jcvi.jillion.assembly.consed.ace.WholeAssemblyAceTag;
import org.jcvi.jillion.assembly.consed.phd.PhdDataStore;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;

@SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="\n character is required for .ace format (?) we don't want to accidentally put in a \r\n on diffent OSand break consed")
public final class AceFileWriterBuilder {
    private boolean createBsRecords = false;
    private final PhdDataStore phdDataStore;
    private final OutputStream out;
    private File tmpDir;

    public AceFileWriterBuilder(File outputAceFile, PhdDataStore datastore) throws IOException {
        if (outputAceFile == null) {
            throw new NullPointerException("output ace file can not be null");
        }
        if (datastore == null) {
            throw new NullPointerException("datastore can not be null");
        }
        IOUtil.mkdirs(outputAceFile.getParentFile());
        this.phdDataStore = datastore;
        this.out = new FileOutputStream(outputAceFile);
    }

    public AceFileWriterBuilder tmpDir(File tmpDir) throws IOException {
        if (tmpDir == null) {
            throw new NullPointerException("tmp dir path can not be null");
        }
        if (tmpDir.exists() && !tmpDir.isDirectory()) {
            throw new IllegalArgumentException("tmp dir must be a directory");
        }
        IOUtil.mkdirs(tmpDir);
        this.tmpDir = tmpDir;
        return this;
    }

    public AceFileWriterBuilder includeBaseSegments() {
        this.createBsRecords = true;
        return this;
    }

    public AceFileWriter build() throws IOException {
        return new DefaultAceFileWriter(this.out, this.phdDataStore, this.tmpDir, this.createBsRecords);
    }

    private static final class DefaultAceFileWriter
    extends AbstractAceFileWriter {
        private final PhdDataStore phdDatastore;
        private final OutputStream out;
        private final File tempFile;
        private long numberOfContigs = 0L;
        private long numberOfReads = 0L;
        private final Writer tempWriter;
        ByteArrayOutputStream tagOutputStream = new ByteArrayOutputStream(32768);
        private volatile boolean isOpen = true;

        private DefaultAceFileWriter(OutputStream out, PhdDataStore phdDatastore, File tmpDir, boolean createBsRecords) throws IOException {
            super(createBsRecords);
            this.out = new BufferedOutputStream(out, 32768);
            this.phdDatastore = phdDatastore;
            IOUtil.mkdirs(tmpDir);
            this.tempFile = File.createTempFile("aceWriter", null, tmpDir);
            this.tempFile.deleteOnExit();
            this.tempWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.tempFile), IOUtil.UTF_8), 32768);
        }

        @Override
        public void close() throws IOException {
            if (this.isOpen) {
                this.isOpen = false;
                this.tempWriter.close();
                this.writeAceFileHeader();
                this.copyTempFileData();
                this.copyTagData();
                this.out.close();
                IOUtil.deleteIgnoreError(this.tempFile);
            }
        }

        private void copyTagData() throws IOException {
            if (this.tagOutputStream.size() > 0) {
                this.out.write(this.tagOutputStream.toByteArray());
            }
        }

        private void copyTempFileData() throws FileNotFoundException, IOException {
            FileInputStream in = new FileInputStream(this.tempFile);
            try {
                IOUtil.copy(in, this.out);
            }
            finally {
                IOUtil.closeAndIgnoreErrors((Closeable)in);
            }
        }

        private void writeAceFileHeader() throws IOException {
            this.out.write(String.format("AS %d %d%s%s", this.numberOfContigs, this.numberOfReads, "\n", "\n").getBytes(IOUtil.UTF_8));
        }

        @Override
        public void write(AceContig contig) throws IOException {
            ++this.numberOfContigs;
            this.numberOfReads += contig.getNumberOfReads();
            this.write(this.tempWriter, contig, this.phdDatastore);
        }

        @Override
        public void write(ReadAceTag readTag) throws IOException {
            Range range = readTag.asRange();
            String formattedTag = String.format("RT{\n%s %s %s %d %d %s\n}\n", readTag.getId(), readTag.getType(), readTag.getCreator(), range.getBegin(), range.getEnd(), AceFileUtil.formatTagDate(readTag.getCreationDate()));
            this.tagOutputStream.write(formattedTag.getBytes(IOUtil.UTF_8));
        }

        @Override
        public void write(ConsensusAceTag consensusTag) throws IOException {
            StringBuilder tagBodyBuilder = new StringBuilder();
            if (consensusTag.getData() != null) {
                tagBodyBuilder.append(consensusTag.getData());
            }
            if (!consensusTag.getComments().isEmpty()) {
                for (String comment : consensusTag.getComments()) {
                    tagBodyBuilder.append(String.format("COMMENT{\n%sC}\n", comment));
                }
            }
            Range range = consensusTag.asRange();
            String formattedTag = String.format("CT{\n%s %s %s %d %d %s%s\n%s}\n", consensusTag.getId(), consensusTag.getType(), consensusTag.getCreator(), range.getBegin(), range.getEnd(), AceFileUtil.formatTagDate(consensusTag.getCreationDate()), consensusTag.isTransient() ? " NoTrans" : "", tagBodyBuilder.toString());
            this.tagOutputStream.write(formattedTag.getBytes(IOUtil.UTF_8));
        }

        @Override
        public void write(WholeAssemblyAceTag wholeAssemblyTag) throws IOException {
            String formattedTag = String.format("WA{\n%s %s %s\n%s\n}\n", wholeAssemblyTag.getType(), wholeAssemblyTag.getCreator(), AceFileUtil.formatTagDate(wholeAssemblyTag.getCreationDate()), wholeAssemblyTag.getData());
            this.tagOutputStream.write(formattedTag.getBytes(IOUtil.UTF_8));
        }
    }
}

