/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.AssemblyUtil;
import org.jcvi.jillion.assembly.Contig;
import org.jcvi.jillion.assembly.consed.ace.AceAssembledRead;
import org.jcvi.jillion.assembly.consed.ace.AceContig;
import org.jcvi.jillion.assembly.consed.ace.ConsedConsensusQualityComputer;
import org.jcvi.jillion.assembly.consed.ace.ConsensusAceTag;
import org.jcvi.jillion.assembly.consed.ace.PhdInfo;
import org.jcvi.jillion.assembly.consed.ace.ReadAceTag;
import org.jcvi.jillion.assembly.consed.ace.WholeAssemblyAceTag;
import org.jcvi.jillion.assembly.consed.phd.Phd;
import org.jcvi.jillion.assembly.consed.phd.PhdDataStore;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.qual.QualitySequenceDataStore;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.ReferenceMappedNucleotideSequence;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.util.JillionUtil;

public final class AceFileUtil {
    public static final PhredQuality ACE_DEFAULT_HIGH_QUALITY_THRESHOLD = PhredQuality.valueOf(26);
    private static ThreadLocal<DateFormat> CHROMAT_DATE_TIME_FORMATTER = new ThreadLocal<DateFormat>(){

        @Override
        public DateFormat get() {
            return (DateFormat)super.get();
        }

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);
            format.setLenient(false);
            return format;
        }
    };
    private static ThreadLocal<KnownFormats> TAG_DATE_TIME_FORMATTER = new ThreadLocal<KnownFormats>(){

        @Override
        public KnownFormats get() {
            return (KnownFormats)super.get();
        }

        @Override
        protected KnownFormats initialValue() {
            return new KnownFormats("yyMMdd:HHmmss", "yyMMdd");
        }
    };
    private static final String CONTIG_HEADER = "CO %s %d %d %d %s%n";
    private static final int INITIAL_READ_BUFFER_SIZE = 1024;

    private AceFileUtil() {
    }

    public static Date parsePhdDate(String text) throws ParseException {
        return CHROMAT_DATE_TIME_FORMATTER.get().parse(text);
    }

    public static String formatPhdDate(Date date) {
        return CHROMAT_DATE_TIME_FORMATTER.get().format(date);
    }

    public static Date parseTagDate(String text) throws ParseException {
        return TAG_DATE_TIME_FORMATTER.get().parse(text);
    }

    public static String formatTagDate(Date date) {
        return TAG_DATE_TIME_FORMATTER.get().format(date);
    }

    public static String convertToAcePaddedBasecalls(NucleotideSequence basecalls) {
        return AceFileUtil.convertToAcePaddedBasecalls(basecalls, null);
    }

    public static String convertToAcePaddedBasecalls(NucleotideSequence basecalls, QualitySequence optionalQualities) {
        long length = basecalls.getLength();
        StringBuilder result = new StringBuilder((int)length);
        Iterator qualityIterator = optionalQualities == null ? null : optionalQualities.iterator();
        for (Nucleotide base : basecalls) {
            if (base == Nucleotide.Gap) {
                result.append('*');
                continue;
            }
            if (optionalQualities == null) {
                result.append(base);
                continue;
            }
            if (!qualityIterator.hasNext()) {
                throw new IllegalArgumentException(String.format("not enough ungapped qualities for input basecalls found only %d qualities", optionalQualities.getLength()));
            }
            PhredQuality quality = (PhredQuality)qualityIterator.next();
            if (quality.compareTo(ACE_DEFAULT_HIGH_QUALITY_THRESHOLD) < 0) {
                result.append(base.toString().toLowerCase(Locale.ENGLISH));
                continue;
            }
            result.append(base);
        }
        String consedBasecalls = result.toString().replaceAll("(.{50})", "$1" + String.format("%n", new Object[0]));
        if (length % 50L == 0L) {
            return consedBasecalls.substring(0, consedBasecalls.length() - 1);
        }
        return consedBasecalls;
    }

    private static String createPhdRecord(PhdInfo phdInfo) {
        return String.format("DS CHROMAT_FILE: %s PHD_FILE: %s TIME: %s", phdInfo.getTraceName(), phdInfo.getPhdName(), AceFileUtil.formatPhdDate(phdInfo.getPhdDate()));
    }

    private static String createQualityRangeRecord(NucleotideSequence gappedValidBases, Range ungappedValidRange, Direction dir, long ungappedFullLength) {
        int numberOfGaps = gappedValidBases.getNumberOfGaps();
        Range gappedValidRange = AceFileUtil.buildGappedValidRangeFor(ungappedValidRange, numberOfGaps, dir, ungappedFullLength);
        return String.format("QA %d %d %d %d", gappedValidRange.getBegin(Range.CoordinateSystem.RESIDUE_BASED), gappedValidRange.getEnd(Range.CoordinateSystem.RESIDUE_BASED), gappedValidRange.getBegin(Range.CoordinateSystem.RESIDUE_BASED), gappedValidRange.getEnd(Range.CoordinateSystem.RESIDUE_BASED));
    }

    private static Range buildGappedValidRangeFor(Range ungappedValidRange, int numberOfGaps, Direction dir, long ungappedFullLength) {
        Range gappedValidRange = Range.of(ungappedValidRange.getBegin(), ungappedValidRange.getEnd() + (long)numberOfGaps);
        if (dir == Direction.REVERSE) {
            gappedValidRange = AssemblyUtil.reverseComplementValidRange(gappedValidRange, ungappedFullLength + (long)numberOfGaps);
        }
        return gappedValidRange;
    }

    public static synchronized String createAcePlacedReadRecord(String readId, AssembledRead placedRead, Phd phd, PhdInfo phdInfo) {
        ReferenceMappedNucleotideSequence nucleotideSequence;
        if (phd == null) {
            throw new NullPointerException("phd can not be null for " + readId);
        }
        ReferenceMappedNucleotideSequence gappedValidBasecalls = nucleotideSequence = placedRead.getNucleotideSequence();
        Range ungappedValidRange = placedRead.getReadInfo().getValidRange();
        Direction dir = placedRead.getDirection();
        NucleotideSequence fullBasecalls = phd.getNucleotideSequence();
        NucleotideSequence fullGappedValidRange = AssemblyUtil.buildGappedComplementedFullRangeBases(placedRead, fullBasecalls);
        QualitySequence qualities = dir == Direction.REVERSE ? new QualitySequenceBuilder(phd.getQualitySequence()).reverse().build() : phd.getQualitySequence();
        return new StringBuilder(1024).append(String.format("RD %s %d 0 0%n", readId, fullGappedValidRange.getLength())).append(String.format("%s%n%n", AceFileUtil.convertToAcePaddedBasecalls(fullGappedValidRange, qualities))).append(String.format("%s%n", AceFileUtil.createQualityRangeRecord(gappedValidBasecalls, ungappedValidRange, dir, fullBasecalls.getUngappedLength()))).append(String.format("%s%n", AceFileUtil.createPhdRecord(phdInfo))).toString();
    }

    public static void writeAceContigHeader(String contigId, long consensusLength, long numberOfReads, int numberOfBaseSegments, boolean isComplimented, OutputStream out) throws IOException {
        AceFileUtil.writeString(String.format(CONTIG_HEADER, contigId, consensusLength, numberOfReads, numberOfBaseSegments, isComplimented ? "C" : "U"), out);
    }

    public static void writeAceFileHeader(long numberOfContigs, long numberOfReads, OutputStream out) throws IOException {
        AceFileUtil.writeString(String.format("AS %d %d%n%n", numberOfContigs, numberOfReads), out);
    }

    private static void writeString(String s, OutputStream out) throws IOException {
        out.write(s.getBytes(IOUtil.UTF_8));
    }

    public static void writeWholeAssemblyTag(WholeAssemblyAceTag wholeAssemblyTag, OutputStream out) throws IOException {
        AceFileUtil.writeString(String.format("WA{%n%s %s %s%n%s%n}%n", wholeAssemblyTag.getType(), wholeAssemblyTag.getCreator(), AceFileUtil.formatTagDate(wholeAssemblyTag.getCreationDate()), wholeAssemblyTag.getData()), out);
    }

    public static void writeConsensusTag(ConsensusAceTag consensusTag, OutputStream out) throws IOException {
        StringBuilder tagBodyBuilder = new StringBuilder();
        if (consensusTag.getData() != null) {
            tagBodyBuilder.append(consensusTag.getData());
        }
        if (!consensusTag.getComments().isEmpty()) {
            for (String comment : consensusTag.getComments()) {
                tagBodyBuilder.append(String.format("COMMENT{%n%sC}%n", comment));
            }
        }
        Range range = consensusTag.asRange();
        AceFileUtil.writeString(String.format("CT{%n%s %s %s %d %d %s%s%n%s}%n", consensusTag.getId(), consensusTag.getType(), consensusTag.getCreator(), range.getBegin(), range.getEnd(), AceFileUtil.formatTagDate(consensusTag.getCreationDate()), consensusTag.isTransient() ? " NoTrans" : "", tagBodyBuilder.toString()), out);
    }

    public static void writeReadTag(ReadAceTag readTag, OutputStream out) throws IOException {
        Range range = readTag.asRange();
        AceFileUtil.writeString(String.format("RT{%n%s %s %s %d %d %s%n}%n", readTag.getId(), readTag.getType(), readTag.getCreator(), range.getBegin(), range.getEnd(), AceFileUtil.formatTagDate(readTag.getCreationDate())), out);
    }

    public static void writeAceContig(AceContig contig, PhdDataStore phdDataStore, OutputStream out) throws IOException, DataStoreException {
        NucleotideSequence consensus = contig.getConsensusSequence();
        AceFileUtil.writeAceContigHeader(contig.getId(), consensus.getLength(), contig.getNumberOfReads(), 0, contig.isComplemented(), out);
        out.flush();
        AceFileUtil.writeString(String.format("%s%n%n%n", AceFileUtil.convertToAcePaddedBasecalls(consensus)), out);
        out.flush();
        AceFileUtil.writeFakeUngappedConsensusQualities(consensus, out);
        AceFileUtil.writeString(String.format("%n", new Object[0]), out);
        out.flush();
        List<IdAlignedReadInfo> assembledFroms = AceFileUtil.getSortedAssembledFromsFor(contig);
        StringBuilder assembledFromBuilder = new StringBuilder();
        StringBuilder placedReadBuilder = new StringBuilder();
        for (IdAlignedReadInfo assembledFrom : assembledFroms) {
            String id = assembledFrom.getId();
            Phd phd = (Phd)phdDataStore.get(id);
            AceAssembledRead realPlacedRead = (AceAssembledRead)contig.getRead(id);
            long fullLength = realPlacedRead.getReadInfo().getUngappedFullLength();
            assembledFromBuilder.append(AceFileUtil.createAssembledFromRecord(realPlacedRead, fullLength));
            placedReadBuilder.append(AceFileUtil.createPlacedReadRecord(realPlacedRead, phd));
        }
        assembledFromBuilder.append(String.format("%n", new Object[0]));
        placedReadBuilder.append(String.format("%n", new Object[0]));
        AceFileUtil.writeString(assembledFromBuilder.toString(), out);
        out.flush();
        AceFileUtil.writeString(placedReadBuilder.toString(), out);
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<IdAlignedReadInfo> getSortedAssembledFromsFor(Contig<AceAssembledRead> contig) {
        ArrayList<IdAlignedReadInfo> assembledFroms = new ArrayList<IdAlignedReadInfo>((int)contig.getNumberOfReads());
        StreamingIterator<AceAssembledRead> iter = null;
        try {
            iter = contig.getReadIterator();
            while (iter.hasNext()) {
                AceAssembledRead read = iter.next();
                long fullLength = read.getReadInfo().getUngappedFullLength();
                assembledFroms.add(IdAlignedReadInfo.createFrom(read, fullLength));
            }
        }
        finally {
            IOUtil.closeAndIgnoreErrors(iter);
        }
        Collections.sort(assembledFroms);
        return assembledFroms;
    }

    private static void writeFakeUngappedConsensusQualities(NucleotideSequence consensus, OutputStream out) throws IOException {
        StringBuilder result = new StringBuilder((int)consensus.getLength());
        int numberOfQualitiesSoFar = 0;
        for (Nucleotide base : consensus) {
            if (base.isGap()) continue;
            result.append(" 90");
            if (++numberOfQualitiesSoFar % 50 != 0) continue;
            result.append(String.format("%n", new Object[0]));
        }
        AceFileUtil.writeString(String.format("BQ%n%s%n", result.toString()), out);
    }

    private static String createAssembledFromRecord(AceAssembledRead read, long fullLength) {
        IdAlignedReadInfo assembledFrom = IdAlignedReadInfo.createFrom(read, fullLength);
        return String.format("AF %s %s %d%n", assembledFrom.getId(), assembledFrom.getDirection() == Direction.FORWARD ? "U" : "C", assembledFrom.getStartOffset());
    }

    private static String createPlacedReadRecord(AceAssembledRead read, Phd phd) {
        return AceFileUtil.createAcePlacedReadRecord(read.getId(), read, phd, read.getPhdInfo());
    }

    public static QualitySequence computeConsensusQualities(Contig<? extends AssembledRead> contig, QualitySequenceDataStore readQualities) throws DataStoreException {
        return ConsedConsensusQualityComputer.computeConsensusQualities(contig, readQualities);
    }

    private static final class IdAlignedReadInfo
    implements Comparable<IdAlignedReadInfo> {
        private static final int TO_STRING_BUFFER_SIZE = 30;
        private final String id;
        private final byte dir;
        private final int startOffset;
        private static final Direction[] DIRECTION_VALUES = Direction.values();

        public static IdAlignedReadInfo createFrom(AssembledRead read, long ungappedFullLength) {
            Direction dir = read.getDirection();
            Range readValidRange = read.getReadInfo().getValidRange();
            Range validRange = dir == Direction.REVERSE ? AssemblyUtil.reverseComplementValidRange(readValidRange, ungappedFullLength) : readValidRange;
            return new IdAlignedReadInfo(read.getId(), (int)(read.getGappedStartOffset() - validRange.getBegin() + 1L), dir);
        }

        private IdAlignedReadInfo(String id, int startOffset, Direction dir) {
            this.id = id;
            this.dir = (byte)dir.ordinal();
            this.startOffset = startOffset;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IdAlignedReadInfo)) {
                return false;
            }
            IdAlignedReadInfo other = (IdAlignedReadInfo)obj;
            return this.id.equals(other.getId());
        }

        public String getId() {
            return this.id;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public Direction getDirection() {
            return DIRECTION_VALUES[this.dir];
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(30);
            builder.append(this.id).append(' ').append(this.startOffset).append("is complemented? ").append(this.getDirection() == Direction.REVERSE);
            return builder.toString();
        }

        @Override
        public int compareTo(IdAlignedReadInfo o) {
            return JillionUtil.compare(this.getStartOffset(), o.getStartOffset());
        }
    }

    private static class KnownFormats {
        private final List<DateFormat> knownFormats;

        public KnownFormats(String ... formats) {
            this.knownFormats = new ArrayList<DateFormat>(formats.length);
            for (String format : formats) {
                SimpleDateFormat f = new SimpleDateFormat(format, Locale.US);
                f.setLenient(true);
                this.knownFormats.add(f);
            }
        }

        public Date parse(String dateString) throws ParseException {
            for (DateFormat f : this.knownFormats) {
                try {
                    return f.parse(dateString);
                }
                catch (ParseException parseException) {
                }
            }
            throw new ParseException("Unparseable date: \"" + dateString + "\"", 0);
        }

        public String format(Date date) {
            return this.knownFormats.get(0).format(date);
        }
    }
}

