/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.EnumSet;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.assembly.consed.ace.AceConsensusTagVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceContigReadVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceContigVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceFileUtil;
import org.jcvi.jillion.assembly.consed.ace.AceFileVisitor;
import org.jcvi.jillion.assembly.consed.ace.AceFileVisitorCallback;
import org.jcvi.jillion.assembly.consed.ace.AceParser;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.internal.core.io.OpenAwareInputStream;
import org.jcvi.jillion.internal.core.io.RandomAccessFileInputStream;
import org.jcvi.jillion.internal.core.io.TextLineParser;

public abstract class AceFileParser
implements AceParser {
    private static Pattern HEADER_PATTERN = Pattern.compile("^AS\\s+(\\d+)\\s+(\\d+)");

    private AceFileParser() {
    }

    public static AceParser create(File aceFile) throws IOException {
        return new FileBasedParser(aceFile);
    }

    public static AceParser create(InputStream aceFileStream) {
        return new InputStreamParser(aceFileStream);
    }

    public void accept(InputStream inputStream, AceFileVisitor visitor) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("input stream can not be null");
        }
        AceFileParser.assertVisitorNotNull(visitor);
        AceParserState parserState = AceParserState.create(inputStream, visitor, null);
        this.parseAceData(parserState, visitor);
    }

    private static void assertVisitorNotNull(AceFileVisitor visitor) {
        if (visitor == null) {
            throw new NullPointerException("visitor can not be null");
        }
    }

    protected final void parseAceData(AceParserState parserState, AceFileVisitor visitor) throws IOException {
        while (!parserState.done()) {
            parserState.parseNextSection();
        }
        parserState.handleEndOfParsing();
    }

    private static final class NoMementoCallbackFactory
    implements AceFileVisitorCallbackFactory {
        private NoMementoCallbackFactory() {
        }

        @Override
        public AceFileVisitorCallback newCallback(long fileOffset, final AtomicBoolean stopParsing) {
            return new AceFileVisitorCallback(){

                @Override
                public void haltParsing() {
                    stopParsing.set(true);
                }

                @Override
                public AceFileVisitorCallback.AceFileVisitorMemento createMemento() {
                    throw new UnsupportedOperationException("can not create mementos");
                }

                @Override
                public boolean canCreateMemento() {
                    return false;
                }
            };
        }
    }

    private static interface AceFileVisitorCallbackFactory {
        public AceFileVisitorCallback newCallback(long var1, AtomicBoolean var3);
    }

    private static final class InputStreamParser
    extends AceFileParser {
        private final OpenAwareInputStream in;

        public InputStreamParser(InputStream in) {
            if (in == null) {
                throw new NullPointerException("input stream can not be null");
            }
            this.in = new OpenAwareInputStream(new BufferedInputStream(in));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(AceFileVisitor visitor) throws IOException {
            AceFileParser.assertVisitorNotNull(visitor);
            if (!this.canParse()) {
                throw new IllegalStateException("inputstream has been closed");
            }
            try {
                TextLineParser parser = new TextLineParser(this.in);
                NoMementoCallbackFactory callbackFactory = new NoMementoCallbackFactory();
                AceParserState parserState = AceParserState.create(parser, visitor, (AceFileVisitorCallbackFactory)callbackFactory);
                this.parseAceData(parserState, visitor);
            }
            finally {
                IOUtil.closeAndIgnoreErrors((Closeable)this.in);
            }
        }

        @Override
        public void parse(AceFileVisitor visitor, AceFileVisitorCallback.AceFileVisitorMemento memento) throws IOException {
            throw new UnsupportedOperationException("mementos not supported");
        }

        @Override
        public boolean canParse() {
            return this.in.isOpen();
        }
    }

    private static final class FileBasedParser
    extends AceFileParser {
        private final File aceFile;

        public FileBasedParser(File aceFile) throws FileNotFoundException {
            if (!aceFile.exists()) {
                throw new FileNotFoundException("ace file does not exist: " + aceFile.getAbsolutePath());
            }
            this.aceFile = aceFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(AceFileVisitor visitor) throws IOException {
            AceFileParser.assertVisitorNotNull(visitor);
            FileInputStream in = new FileInputStream(this.aceFile);
            try {
                TextLineParser parser = new TextLineParser(new BufferedInputStream(in));
                String firstLine = parser.nextLine();
                Matcher matcher = HEADER_PATTERN.matcher(firstLine);
                if (!matcher.find()) {
                    throw new IOException("not valid ace file header : " + firstLine);
                }
                int numberOfContigs = Integer.parseInt(matcher.group(1));
                int totalNumberOfReads = Integer.parseInt(matcher.group(2));
                visitor.visitHeader(numberOfContigs, totalNumberOfReads);
                MementoCallbackFactory callbackFactory = new MementoCallbackFactory();
                AceParserState parserState = AceParserState.create(parser, visitor, (AceFileVisitorCallbackFactory)callbackFactory);
                this.parseAceData(parserState, visitor);
            }
            finally {
                IOUtil.closeAndIgnoreErrors((Closeable)in);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(AceFileVisitor visitor, AceFileVisitorCallback.AceFileVisitorMemento memento) throws IOException {
            if (memento == null) {
                throw new NullPointerException("memento can not be null");
            }
            AceFileParser.assertVisitorNotNull(visitor);
            if (!(memento instanceof AceFileMemento)) {
                throw new IllegalArgumentException("unknown memento type " + memento);
            }
            AceFileMemento aceFileMemento = (AceFileMemento)memento;
            if (aceFileMemento.getParentParser() != this) {
                throw new IllegalArgumentException("memento must be used by the parser instance that created it");
            }
            long offset = aceFileMemento.getStartOffset();
            RandomAccessFileInputStream in = null;
            try {
                in = new RandomAccessFileInputStream(this.aceFile, offset);
                AceParserState parserState = AceParserState.create(in, visitor, new MementoCallbackFactory(), offset);
                this.parseAceData(parserState, visitor);
            }
            catch (Throwable throwable) {
                IOUtil.closeAndIgnoreErrors(in);
                throw throwable;
            }
            IOUtil.closeAndIgnoreErrors((Closeable)in);
        }

        @Override
        public boolean canParse() {
            return true;
        }

        private class AceFileMemento
        implements AceFileVisitorCallback.AceFileVisitorMemento {
            private final long startOffset;

            public AceFileMemento(long startOffset) {
                this.startOffset = startOffset;
            }

            public final long getStartOffset() {
                return this.startOffset;
            }

            AceParser getParentParser() {
                return FileBasedParser.this;
            }
        }

        private final class MementoCallbackFactory
        implements AceFileVisitorCallbackFactory {
            private MementoCallbackFactory() {
            }

            @Override
            public AceFileVisitorCallback newCallback(final long fileOffset, final AtomicBoolean stopParsing) {
                return new AceFileVisitorCallback(){

                    @Override
                    public void haltParsing() {
                        stopParsing.set(true);
                    }

                    @Override
                    public AceFileVisitorCallback.AceFileVisitorMemento createMemento() {
                        return new AceFileMemento(fileOffset);
                    }

                    @Override
                    public boolean canCreateMemento() {
                        return true;
                    }
                };
            }
        }
    }

    private static enum SectionHandler {
        ACE_HEADER("^AS\\s+(\\d+)\\s+(\\d+)"){

            @Override
            void handle(Matcher headerMatcher, AceParserState struct, String line) {
                int numberOfContigs = Integer.parseInt(headerMatcher.group(1));
                long totalNumberOfReads = Long.parseLong(headerMatcher.group(2));
                struct.fileVisitor.visitHeader(numberOfContigs, totalNumberOfReads);
            }
        }
        ,
        CONSENSUS_QUALITIES("^BQ\\s*"){

            @Override
            void handle(Matcher matcher, AceParserState parserState, String line) {
                if (parserState.parseCurrentContig()) {
                    parserState.inConsensusQualities(true);
                }
            }
        }
        ,
        BASECALLS("^([\\-*a-zA-Z]+)\\s*$"){

            @Override
            void handle(Matcher basecallMatcher, AceParserState parserState, String line) {
                if (line.indexOf(45) != -1) {
                    throw new IllegalStateException("invalid ace file: found '-' used as a gap instead of '*' : " + line);
                }
                if (parserState.parseCurrentContig()) {
                    parserState.visitBasesLine(basecallMatcher.group(1));
                }
            }
        }
        ,
        CONTIG_HEADER("^CO\\s+(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+([UC])"){

            @Override
            void handle(Matcher contigMatcher, AceParserState struct, String line) {
                AceParserState ret = struct;
                ret.handleEndOfContig();
                if (ret.done()) {
                    return;
                }
                String contigId = contigMatcher.group(1);
                int numberOfBases = Integer.parseInt(contigMatcher.group(2));
                int numberOfReads = Integer.parseInt(contigMatcher.group(3));
                int numberOfBaseSegments = Integer.parseInt(contigMatcher.group(4));
                boolean reverseComplemented = this.isComplimented(contigMatcher.group(5));
                ret.visitBeginContig(contigId, numberOfBases, numberOfReads, numberOfBaseSegments, reverseComplemented);
            }
        }
        ,
        ASSEMBLED_FROM("^AF\\s+(\\S+)\\s+([U|C])\\s+(-?\\d+)"){

            @Override
            void handle(Matcher assembledFromMatcher, AceParserState parserState, String line) {
                if (parserState.inConsensusQualities()) {
                    parserState.inConsensusQualities(false);
                }
                if (parserState.parseCurrentContig()) {
                    String name = assembledFromMatcher.group(1);
                    String group = assembledFromMatcher.group(2);
                    Direction dir = this.isComplimented(group) ? Direction.REVERSE : Direction.FORWARD;
                    int fullRangeOffset = Integer.parseInt(assembledFromMatcher.group(3));
                    parserState.visitAlignedReadInfo(name, dir, fullRangeOffset);
                }
            }
        }
        ,
        READ_HEADER("^RD\\s+(\\S+)\\s+(\\d+)"){

            @Override
            void handle(Matcher readMatcher, AceParserState parserState, String line) {
                if (parserState.parseCurrentContig()) {
                    String readId = readMatcher.group(1);
                    int fullLength = Integer.parseInt(readMatcher.group(2));
                    parserState.handleNewRead(readId, fullLength);
                }
            }
        }
        ,
        READ_QUALITY("^QA\\s+(-?\\d+)\\s+(-?\\d+)\\s+(-?\\d+)\\s+(-?\\d+)"){

            @Override
            void handle(Matcher qualityMatcher, AceParserState parserState, String line) {
                if (parserState.parseCurrentRead()) {
                    int qualLeft = Integer.parseInt(qualityMatcher.group(1));
                    int qualRight = Integer.parseInt(qualityMatcher.group(2));
                    int alignLeft = Integer.parseInt(qualityMatcher.group(3));
                    int alignRight = Integer.parseInt(qualityMatcher.group(4));
                    parserState.visitQualityLine(qualLeft, qualRight, alignLeft, alignRight);
                }
            }
        }
        ,
        TRACE_DESCRIPTION("^DS\\s+"){
            private final Pattern chromatFilePattern = Pattern.compile("CHROMAT_FILE:\\s+(\\S+)\\s+");
            private final Pattern phdFilePattern = Pattern.compile("PHD_FILE:\\s+(\\S+)\\s+");
            private final Pattern timePattern = Pattern.compile("TIME:\\s+(.+:\\d\\d\\s+\\d\\d\\d\\d)");
            private final Pattern sffFakeChromatogramPattern = Pattern.compile("sff:(\\S+)?\\.sff:(\\S+)");
            private final Pattern chemPattern = Pattern.compile("CHEM:\\s+(\\S+)\\s+");
            private final Pattern dyePattern = Pattern.compile("DYE:\\s+(\\S+)\\s+");
            private final Pattern templatePattern = Pattern.compile("TEMPLATE:\\s+(\\S+)\\s+");
            private final Pattern dirPattern = Pattern.compile("DIR:\\s+(\\S+)\\s+");

            @Override
            void handle(Matcher qualityMatcher, AceParserState parserState, String line) throws IOException {
                if (parserState.parseCurrentRead()) {
                    Date date;
                    Matcher chromatogramMatcher = this.chromatFilePattern.matcher(line);
                    if (!chromatogramMatcher.find()) {
                        throw new IOException("could not parse chromatogram name from " + line);
                    }
                    String traceName = chromatogramMatcher.group(1);
                    String phdName = this.parsePhdName(line, traceName);
                    Matcher timeMatcher = this.timePattern.matcher(line);
                    if (!timeMatcher.find()) {
                        throw new IOException("could not parse phd time stamp from " + line);
                    }
                    try {
                        date = AceFileUtil.parsePhdDate(timeMatcher.group(1));
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("error parsing chromatogram time stamp '" + timeMatcher.group(1) + "'", e);
                    }
                    parserState.visitTraceDescriptionLine(traceName, phdName, date);
                }
                parserState.seenRead();
            }

            private String parsePhdName(String line, String traceName) {
                String phdName;
                Matcher phdMatcher = this.phdFilePattern.matcher(line);
                if (phdMatcher.find()) {
                    phdName = phdMatcher.group(1);
                } else {
                    Matcher sffNameMatcher = this.sffFakeChromatogramPattern.matcher(traceName);
                    if (sffNameMatcher.find()) {
                        String sffRootName = sffNameMatcher.group(2);
                        String group = sffNameMatcher.group(1);
                        boolean isForward = group.startsWith("-f:");
                        phdName = String.format("%s_%s", sffRootName, isForward ? "left" : "right");
                    } else {
                        phdName = traceName;
                    }
                }
                return phdName;
            }
        }
        ,
        READ_TAG("^RT\\{"){
            private final Pattern readTagPattern = Pattern.compile("(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d{6}:\\d{6})");

            @Override
            void handle(Matcher qualityMatcher, AceParserState parserState, String line) throws IOException {
                Date creationDate;
                String lineWithCR;
                Matcher readTagMatcher;
                AceParserState currentParserState = parserState;
                if (currentParserState.inAContig() && currentParserState.seenAllExpectedReads()) {
                    currentParserState.handleEndOfContig();
                    currentParserState = currentParserState.notInAContig();
                    if (currentParserState.done()) {
                        return;
                    }
                }
                if (!(readTagMatcher = this.readTagPattern.matcher(lineWithCR = currentParserState.parser.nextLine())).find()) {
                    throw new IllegalStateException("expected read tag infomration: " + lineWithCR);
                }
                String id = readTagMatcher.group(1);
                String type = readTagMatcher.group(2);
                String creator = readTagMatcher.group(3);
                long gappedStart = Long.parseLong(readTagMatcher.group(4)) - 1L;
                long gappedEnd = Long.parseLong(readTagMatcher.group(5)) - 1L;
                try {
                    creationDate = AceFileUtil.parseTagDate(readTagMatcher.group(6));
                }
                catch (ParseException e) {
                    throw new IllegalStateException("error parsing date from read tag", e);
                }
                currentParserState.fileVisitor.visitReadTag(id, type, creator, gappedStart, gappedEnd, creationDate, true);
                lineWithCR = currentParserState.parser.nextLine();
                if (!lineWithCR.startsWith("}")) {
                    throw new IllegalStateException("expected close read tag: " + lineWithCR);
                }
            }
        }
        ,
        WHOLE_ASSEMBLY_TAG("^WA\\{"){
            private final Pattern wholeAssemblyTagPattern = Pattern.compile("(\\S+)\\s+(\\S+)\\s+(\\d{6}:\\d{6})");

            @Override
            void handle(Matcher qualityMatcher, AceParserState parserState, String line) throws IOException {
                Date creationDate;
                String lineWithCR;
                Matcher tagMatcher;
                AceParserState currentParserState = parserState;
                if (currentParserState.inAContig() && currentParserState.seenAllExpectedReads()) {
                    currentParserState.handleEndOfContig();
                    currentParserState = currentParserState.notInAContig();
                    if (currentParserState.done()) {
                        return;
                    }
                }
                if (!(tagMatcher = this.wholeAssemblyTagPattern.matcher(lineWithCR = currentParserState.parser.nextLine())).find()) {
                    throw new IllegalStateException("expected whole assembly tag information: " + lineWithCR);
                }
                String type = tagMatcher.group(1);
                String creator = tagMatcher.group(2);
                try {
                    creationDate = AceFileUtil.parseTagDate(tagMatcher.group(3));
                }
                catch (ParseException e) {
                    throw new IllegalStateException("error parsing date from while assembly tag", e);
                }
                StringBuilder data = this.parseWholeAssemblyTagData(currentParserState);
                currentParserState.fileVisitor.visitWholeAssemblyTag(type, creator, creationDate, data.toString());
            }

            private StringBuilder parseWholeAssemblyTagData(AceParserState parserState) throws IOException {
                boolean doneTag = false;
                StringBuilder data = new StringBuilder();
                while (!doneTag && parserState.parser.hasNextLine()) {
                    String lineWithCR = parserState.parser.nextLine();
                    if (lineWithCR.startsWith("}")) {
                        doneTag = true;
                        continue;
                    }
                    data.append(lineWithCR);
                }
                if (!doneTag) {
                    throw new IllegalStateException("unexpected EOF, Whole Assembly Tag not closed!");
                }
                return data;
            }
        }
        ,
        CONSENSUS_TAG("^CT\\{"){
            private final Pattern consensusTagPattern = Pattern.compile("(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d{6}(:\\d{6})?)(\\s+(noTrans))?");

            @Override
            void handle(Matcher qualityMatcher, AceParserState parserState, String line) throws IOException {
                Date creationDate;
                String lineWithCR;
                Matcher tagMatcher;
                AceParserState currentParserState = parserState;
                if (currentParserState.inAContig() && currentParserState.seenAllExpectedReads()) {
                    currentParserState.handleEndOfContig();
                    currentParserState = currentParserState.notInAContig();
                    if (currentParserState.done()) {
                        return;
                    }
                }
                if (!(tagMatcher = this.consensusTagPattern.matcher(lineWithCR = currentParserState.parser.nextLine())).find()) {
                    throw new IllegalStateException("expected read tag infomration: " + lineWithCR);
                }
                String id = tagMatcher.group(1);
                String type = tagMatcher.group(2);
                String creator = tagMatcher.group(3);
                long gappedStart = Long.parseLong(tagMatcher.group(4));
                long gappedEnd = Long.parseLong(tagMatcher.group(5));
                try {
                    creationDate = AceFileUtil.parseTagDate(tagMatcher.group(6));
                }
                catch (ParseException e) {
                    throw new IllegalStateException("error parsing date from consensus tag", e);
                }
                boolean isTransient = tagMatcher.group(8) != null;
                AceConsensusTagVisitor tagVisitor = currentParserState.fileVisitor.visitConsensusTag(id, type, creator, gappedStart, gappedEnd, creationDate, isTransient);
                this.parseConsensusTagData(currentParserState, tagVisitor);
                if (tagVisitor != null) {
                    tagVisitor.visitEnd();
                }
            }

            private void parseConsensusTagData(AceParserState parserState, AceConsensusTagVisitor tagVisitor) throws IOException {
                StringBuilder consensusComment = null;
                boolean doneTag = false;
                boolean inComment = false;
                while (!doneTag && parserState.parser.hasNextLine()) {
                    String lineWithCR = parserState.parser.nextLine();
                    if (lineWithCR.startsWith("COMMENT{")) {
                        inComment = true;
                        consensusComment = new StringBuilder();
                        continue;
                    }
                    if (inComment) {
                        if (lineWithCR.startsWith("C}")) {
                            if (tagVisitor != null) {
                                tagVisitor.visitComment(consensusComment.toString());
                            }
                            inComment = false;
                            continue;
                        }
                        consensusComment.append(lineWithCR);
                        continue;
                    }
                    if (lineWithCR.startsWith("}")) {
                        doneTag = true;
                        continue;
                    }
                    if (tagVisitor == null) continue;
                    tagVisitor.visitData(lineWithCR);
                }
                if (!doneTag) {
                    throw new IllegalStateException("unexpected EOF, Consensus Tag not closed!");
                }
            }
        }
        ,
        IGNORE{

            @Override
            void handle(Matcher matcher, AceParserState parserState, String line) throws IOException {
                if (parserState.inConsensusQualities()) {
                    Scanner scanner = new Scanner(line);
                    while (scanner.hasNext()) {
                        parserState.currentQualitySequenceBuilder.append(scanner.nextInt());
                    }
                }
            }
        };

        private static final String COMPLIMENT_STRING = "C";
        private static final EnumSet<SectionHandler> HANDLERS_TO_CONSIDER;
        private final Pattern pattern;

        private SectionHandler() {
            this.pattern = null;
        }

        private SectionHandler(String patternStr) {
            this.pattern = Pattern.compile(patternStr);
        }

        final Matcher matcher(String line) {
            return this.pattern.matcher(line);
        }

        final boolean isComplimented(String orientation) {
            return COMPLIMENT_STRING.equals(orientation);
        }

        abstract void handle(Matcher var1, AceParserState var2, String var3) throws IOException;

        private static ResultHandler findCorrectHandlerFor(String line) {
            for (SectionHandler handler : HANDLERS_TO_CONSIDER) {
                Matcher matcher = handler.matcher(line);
                if (!matcher.find()) continue;
                return new ResultHandler(handler, matcher);
            }
            return new ResultHandler(IGNORE, null);
        }

        public static void handleSection(String line, AceParserState struct) throws IOException {
            SectionHandler.findCorrectHandlerFor(line).handle(line, struct);
        }

        static {
            HANDLERS_TO_CONSIDER = EnumSet.complementOf(EnumSet.of(IGNORE));
        }

        private static class ResultHandler {
            final SectionHandler handler;
            final Matcher matcher;

            ResultHandler(SectionHandler handler, Matcher matcher) {
                this.handler = handler;
                this.matcher = matcher;
            }

            void handle(String line, AceParserState struct) throws IOException {
                this.handler.handle(this.matcher, struct, line);
            }
        }
    }

    private static class AceParserState
    implements Closeable {
        final AceFileVisitor fileVisitor;
        private AceContigVisitor currentContigVisitor;
        private AceContigReadVisitor currentReadVisitor;
        final TextLineParser parser;
        private final AtomicBoolean stopParsing = new AtomicBoolean(false);
        private boolean inAContig;
        private int expectedNumberOfReads;
        private int numberOfReadsSeen;
        private boolean inConsensusQualities = false;
        private boolean readReadPoritionOfContig = false;
        private QualitySequenceBuilder currentQualitySequenceBuilder;
        private final AceFileVisitorCallbackFactory callbackFactory;
        private long startPositionOfCurrentSection = 0L;

        public static AceParserState create(InputStream in, AceFileVisitor visitor, AceFileVisitorCallbackFactory callbackFactory, long startOffset) throws IOException {
            AceParserState parserState = AceParserState.create(new TextLineParser(new BufferedInputStream(in)), visitor, callbackFactory);
            parserState.startPositionOfCurrentSection = startOffset;
            return parserState;
        }

        public static AceParserState create(InputStream in, AceFileVisitor visitor, AceFileVisitorCallbackFactory callbackFactory) throws IOException {
            return AceParserState.create(new TextLineParser(new BufferedInputStream(in)), visitor, callbackFactory);
        }

        public static AceParserState create(TextLineParser parser, AceFileVisitor visitor, AceFileVisitorCallbackFactory callbackFactory) throws IOException {
            return new AceParserState(visitor, parser, false, 0, 0, callbackFactory);
        }

        public boolean seenAllExpectedReads() {
            return this.numberOfReadsSeen == this.expectedNumberOfReads;
        }

        public AceParserState seenRead() {
            ++this.numberOfReadsSeen;
            if (this.currentReadVisitor != null) {
                this.currentReadVisitor.visitEnd();
            }
            return this;
        }

        public boolean inConsensusQualities() {
            return this.inConsensusQualities;
        }

        public boolean inAContig() {
            return this.inAContig;
        }

        public AceParserState inConsensusQualities(boolean inConsensusQualities) {
            this.inConsensusQualities = inConsensusQualities;
            if (!inConsensusQualities) {
                if (this.currentContigVisitor != null) {
                    this.currentContigVisitor.visitConsensusQualities(this.currentQualitySequenceBuilder.build());
                }
                this.currentQualitySequenceBuilder = null;
            }
            return this;
        }

        public void parseNextSection() throws IOException {
            this.startPositionOfCurrentSection = this.parser.getPosition();
            String lineWithCR = this.parser.nextLine();
            SectionHandler.handleSection(lineWithCR, this);
        }

        AceParserState(AceFileVisitor visitor, TextLineParser parser, boolean inAContig, int numberOfExpectedReads, int numberOfReadsSeen, AceFileVisitorCallbackFactory callbackFactory) {
            this.fileVisitor = visitor;
            this.parser = parser;
            this.inAContig = inAContig;
            this.numberOfReadsSeen = numberOfReadsSeen;
            this.expectedNumberOfReads = numberOfExpectedReads;
            this.callbackFactory = callbackFactory;
        }

        public boolean done() {
            return this.stopParsing.get() || !this.parser.hasNextLine();
        }

        public boolean parseCurrentContig() {
            return this.currentContigVisitor != null;
        }

        void handleNewContig(AceContigVisitor contigVisitor, int numberOfExpectedReads, int numberOfConsensusBases) {
            this.inAContig = true;
            this.numberOfReadsSeen = 0;
            this.expectedNumberOfReads = numberOfExpectedReads;
            this.currentQualitySequenceBuilder = new QualitySequenceBuilder(numberOfConsensusBases);
            this.currentContigVisitor = contigVisitor;
            this.currentReadVisitor = null;
            this.readReadPoritionOfContig = false;
        }

        void handleNewRead(String readId, int fulllLength) {
            this.readReadPoritionOfContig = true;
            if (this.currentContigVisitor != null) {
                this.currentReadVisitor = this.currentContigVisitor.visitBeginRead(readId, fulllLength);
            }
        }

        void handleEndOfContig() {
            if (this.expectedNumberOfReads != this.numberOfReadsSeen) {
                throw new IllegalStateException(String.format("did not visit all expected reads : %d vs %d", this.numberOfReadsSeen, this.expectedNumberOfReads));
            }
            if (this.currentContigVisitor != null) {
                this.currentContigVisitor.visitEnd();
            }
        }

        void handleEndOfParsing() {
            if (this.stopParsing.get()) {
                if (this.currentContigVisitor != null) {
                    if (this.currentReadVisitor != null) {
                        this.currentReadVisitor.halted();
                    }
                    this.currentContigVisitor.halted();
                }
                this.fileVisitor.halted();
                IOUtil.closeAndIgnoreErrors((Closeable)this);
            } else {
                if (this.inAContig) {
                    this.handleEndOfContig();
                }
                this.fileVisitor.visitEnd();
            }
        }

        AceParserState notInAContig() {
            this.inAContig = false;
            this.expectedNumberOfReads = 0;
            this.numberOfReadsSeen = 0;
            return this;
        }

        @Override
        public void close() throws IOException {
            this.parser.close();
        }

        public void visitBasesLine(String mixedCaseBasecalls) {
            if (this.currentContigVisitor != null) {
                if (this.readReadPoritionOfContig) {
                    if (this.currentReadVisitor != null) {
                        this.currentReadVisitor.visitBasesLine(mixedCaseBasecalls);
                    }
                } else {
                    this.currentContigVisitor.visitBasesLine(mixedCaseBasecalls);
                }
            }
        }

        public void visitAlignedReadInfo(String name, Direction dir, int fullRangeOffset) {
            if (this.currentContigVisitor != null) {
                this.currentContigVisitor.visitAlignedReadInfo(name, dir, fullRangeOffset);
            }
        }

        public void visitBeginContig(String contigId, int numberOfBases, int numberOfReads, int numberOfBaseSegments, boolean reverseComplemented) {
            AceFileVisitorCallback callback = this.callbackFactory.newCallback(this.startPositionOfCurrentSection, this.stopParsing);
            AceContigVisitor contigVisitor = this.fileVisitor.visitContig(callback, contigId, numberOfBases, numberOfReads, numberOfBaseSegments, reverseComplemented);
            this.handleNewContig(contigVisitor, numberOfReads, numberOfBases);
        }

        public boolean parseCurrentRead() {
            return this.currentContigVisitor != null && this.currentReadVisitor != null;
        }

        public void visitQualityLine(int qualLeft, int qualRight, int alignLeft, int alignRight) {
            this.currentReadVisitor.visitQualityLine(qualLeft, qualRight, alignLeft, alignRight);
        }

        public void visitTraceDescriptionLine(String traceName, String phdName, Date date) {
            this.currentReadVisitor.visitTraceDescriptionLine(traceName, phdName, date);
        }
    }
}

