/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.consed.ace;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.jcvi.jillion.assembly.consed.ace.AceFileDataStore;
import org.jcvi.jillion.assembly.consed.ace.DefaultAceFileDataStore;
import org.jcvi.jillion.assembly.consed.ace.IndexedAceFileDataStore;
import org.jcvi.jillion.assembly.consed.ace.LargeAceFileDataStore;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.datastore.DataStoreProviderHint;

public final class AceFileDataStoreBuilder {
    private final File aceFile;
    private DataStoreFilter filter = DataStoreFilters.alwaysAccept();
    private DataStoreProviderHint hint = DataStoreProviderHint.RANDOM_ACCESS_OPTIMIZE_SPEED;
    private final InputStream aceStream;

    public AceFileDataStoreBuilder(File aceFile) throws IOException {
        if (aceFile == null) {
            throw new NullPointerException("ace file can not be null");
        }
        if (!aceFile.exists()) {
            throw new FileNotFoundException("ace file must exist");
        }
        if (!aceFile.canRead()) {
            throw new IOException("ace file is not readable");
        }
        this.aceFile = aceFile;
        this.aceStream = null;
    }

    public AceFileDataStoreBuilder(InputStream aceStream) {
        if (aceStream == null) {
            throw new NullPointerException("inputstream can not be null");
        }
        this.aceFile = null;
        this.aceStream = aceStream;
    }

    public AceFileDataStoreBuilder filter(DataStoreFilter filter) {
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        this.filter = filter;
        return this;
    }

    public AceFileDataStoreBuilder hint(DataStoreProviderHint hint) {
        if (hint == null) {
            throw new NullPointerException("hint can not be null");
        }
        this.hint = hint;
        return this;
    }

    public AceFileDataStore build() throws IOException {
        if (this.aceStream == null) {
            return this.buildFromFile();
        }
        return DefaultAceFileDataStore.create(this.aceStream, this.filter);
    }

    private AceFileDataStore buildFromFile() throws IOException, FileNotFoundException {
        switch (this.hint) {
            case RANDOM_ACCESS_OPTIMIZE_SPEED: {
                return DefaultAceFileDataStore.create(this.aceFile, this.filter);
            }
            case RANDOM_ACCESS_OPTIMIZE_MEMORY: {
                return IndexedAceFileDataStore.create(this.aceFile, this.filter);
            }
            case ITERATION_ONLY: {
                return LargeAceFileDataStore.create(this.aceFile, this.filter);
            }
        }
        throw new IllegalArgumentException("unknown provider hint : " + (Object)((Object)this.hint));
    }
}

